/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sourceforge.pmd.lang.java.typeresolution.visitors.PMDASMVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class PMDASMClassLoader
extends ClassLoader {
    private static PMDASMClassLoader cachedPMDASMClassLoader;
    private static ClassLoader cachedClassLoader;
    private final ConcurrentMap<String, Boolean> dontBother = new ConcurrentHashMap<String, Boolean>();

    private PMDASMClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static synchronized PMDASMClassLoader getInstance(ClassLoader parent) {
        if (parent.equals(cachedClassLoader)) {
            return cachedPMDASMClassLoader;
        }
        cachedClassLoader = parent;
        cachedPMDASMClassLoader = new PMDASMClassLoader(parent);
        return cachedPMDASMClassLoader;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.dontBother.containsKey(name)) {
            throw new ClassNotFoundException(name);
        }
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            this.dontBother.put(name, Boolean.TRUE);
            throw e;
        }
        catch (NoClassDefFoundError e) {
            this.dontBother.put(name, Boolean.TRUE);
            throw new ClassNotFoundException(name, e);
        }
    }

    public boolean couldResolve(String name) {
        return !this.dontBother.containsKey(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Map<String, String> getImportedClasses(String name) throws ClassNotFoundException {
        if (this.dontBother.containsKey(name)) {
            throw new ClassNotFoundException(name);
        }
        try (InputStream classResource = this.getResourceAsStream(name.replace('.', '/') + ".class");){
            ClassReader reader = new ClassReader(classResource);
            PMDASMVisitor asmVisitor = new PMDASMVisitor(name);
            reader.accept((ClassVisitor)asmVisitor, 0);
            List<String> inner = asmVisitor.getInnerClasses();
            if (inner != null && !inner.isEmpty()) {
                inner = new ArrayList<String>(inner);
                for (String str : inner) {
                    InputStream innerClassStream = this.getResourceAsStream(str.replace('.', '/') + ".class");
                    Throwable throwable = null;
                    try {
                        if (innerClassStream == null) continue;
                        reader = new ClassReader(innerClassStream);
                        reader.accept((ClassVisitor)asmVisitor, 0);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (innerClassStream == null) continue;
                        if (throwable != null) {
                            try {
                                innerClassStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        innerClassStream.close();
                    }
                }
            }
            Map<String, String> map = asmVisitor.getPackages();
            return map;
        }
        catch (IOException e) {
            this.dontBother.put(name, Boolean.TRUE);
            throw new ClassNotFoundException(name, e);
        }
    }

    static {
        PMDASMClassLoader.registerAsParallelCapable();
    }
}

