/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimsAndInits;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExclusiveOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInclusiveOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTInstanceOfExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNormalAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTRelationalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTShiftExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSingleMemberAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArgument;
import net.sourceforge.pmd.lang.java.ast.ASTTypeArguments;
import net.sourceforge.pmd.lang.java.ast.ASTTypeBound;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTWildcardBounds;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.typeresolution.MethodType;
import net.sourceforge.pmd.lang.java.typeresolution.MethodTypeResolution;
import net.sourceforge.pmd.lang.java.typeresolution.PMDASMClassLoader;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinition;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinitionType;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ClassTypeResolver
extends JavaParserVisitorAdapter {
    private static final Logger LOG = Logger.getLogger(ClassTypeResolver.class.getName());
    private static final Map<String, Class<?>> PRIMITIVE_TYPES;
    private static final Map<String, String> JAVA_LANG;
    private Map<String, JavaTypeDefinition> staticFieldImageToTypeDef;
    private Map<String, List<JavaTypeDefinition>> staticNamesToClasses;
    private List<JavaTypeDefinition> importOnDemandStaticClasses;
    private ASTCompilationUnit currentAcu;
    private final PMDASMClassLoader pmdClassLoader;
    private Map<String, String> importedClasses;
    private List<String> importedOnDemand;
    private Map<Node, AnonymousClassMetadata> anonymousClassMetadata = new HashMap<Node, AnonymousClassMetadata>();

    public ClassTypeResolver() {
        this(ClassTypeResolver.class.getClassLoader());
    }

    public ClassTypeResolver(ClassLoader classLoader) {
        this.pmdClassLoader = PMDASMClassLoader.getInstance(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        String className = null;
        try {
            this.currentAcu = node;
            this.importedOnDemand = new ArrayList<String>();
            this.importedClasses = new HashMap<String, String>();
            this.staticFieldImageToTypeDef = new HashMap<String, JavaTypeDefinition>();
            this.staticNamesToClasses = new HashMap<String, List<JavaTypeDefinition>>();
            this.importOnDemandStaticClasses = new ArrayList<JavaTypeDefinition>();
            className = this.getClassName(node);
            if (className != null) {
                this.populateClassName(node, className);
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Could not find class " + className + ", due to: " + e);
            }
        }
        catch (NoClassDefFoundError e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Could not find class " + className + ", due to: " + e);
            }
        }
        catch (LinkageError e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Could not find class " + className + ", due to: " + e);
            }
        }
        finally {
            this.populateImports(node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTPackageDeclaration node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ASTName importedType = (ASTName)node.jjtGetChild(0);
        if (importedType.getType() != null) {
            node.setType(importedType.getType());
        } else {
            this.populateType(node, importedType.getImage());
        }
        if (node.getType() != null) {
            node.setPackage(node.getType().getPackage());
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeDeclaration node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        AnonymousClassMetadata parentAnonymousClassMetadata;
        super.visit(node, data);
        String typeName = node.getImage();
        if (node.isAnonymousClass() && (parentAnonymousClassMetadata = this.getParentAnonymousClassMetadata(node)) != null) {
            typeName = parentAnonymousClassMetadata.name + "$" + ++parentAnonymousClassMetadata.anonymousClassCounter;
            this.anonymousClassMetadata.put(node, new AnonymousClassMetadata(typeName));
        }
        this.populateType(node, typeName, node.getArrayDepth());
        ASTTypeArguments typeArguments = (ASTTypeArguments)node.getFirstChildOfType(ASTTypeArguments.class);
        if (typeArguments != null) {
            JavaTypeDefinition[] boundGenerics = new JavaTypeDefinition[typeArguments.jjtGetNumChildren()];
            for (int i = 0; i < typeArguments.jjtGetNumChildren(); ++i) {
                boundGenerics[i] = ((TypeNode)typeArguments.jjtGetChild(i)).getTypeDefinition();
            }
            node.setTypeDefinition(JavaTypeDefinition.forClass(node.getType(), boundGenerics));
        }
        return data;
    }

    private AnonymousClassMetadata getParentAnonymousClassMetadata(ASTClassOrInterfaceType node) {
        AnonymousClassMetadata newMetadata;
        ASTClassOrInterfaceType parent = node;
        while ((parent = parent.jjtGetParent()) != null && !(parent instanceof ASTClassOrInterfaceBody) && !(parent instanceof ASTEnumBody)) {
        }
        if (parent == null) {
            return null;
        }
        TypeNode typedParent = (parent = parent.jjtGetParent()) instanceof ASTAllocationExpression ? (TypeNode)parent.getFirstChildOfType(ASTClassOrInterfaceType.class) : (parent instanceof ASTClassOrInterfaceDeclaration || parent instanceof ASTEnumDeclaration ? (TypeNode)parent : (TypeNode)parent.getFirstParentOfType(ASTEnumDeclaration.class));
        AnonymousClassMetadata metadata = this.anonymousClassMetadata.get(typedParent);
        if (metadata != null) {
            return metadata;
        }
        if (typedParent instanceof ASTClassOrInterfaceType) {
            ASTClassOrInterfaceType parentTypeNode = (ASTClassOrInterfaceType)typedParent;
            if (parentTypeNode.isAnonymousClass()) {
                AnonymousClassMetadata parentMetadata = this.getParentAnonymousClassMetadata(parentTypeNode);
                newMetadata = new AnonymousClassMetadata(parentMetadata.name + "$" + ++parentMetadata.anonymousClassCounter);
            } else {
                newMetadata = new AnonymousClassMetadata(parentTypeNode.getImage());
            }
        } else {
            newMetadata = new AnonymousClassMetadata(typedParent.getImage());
        }
        this.anonymousClassMetadata.put(typedParent, newMetadata);
        return newMetadata;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    private int searchNodeNameForClass(TypeNode node) {
        int startIndex = node.getImage().split("\\.").length;
        String reducedImage = node.getImage();
        while (true) {
            this.populateType(node, reducedImage);
            if (node.getType() != null) break;
            --startIndex;
            int lastDotIndex = reducedImage.lastIndexOf(46);
            if (lastDotIndex == -1) break;
            reducedImage = reducedImage.substring(0, lastDotIndex);
        }
        return startIndex;
    }

    private ASTArgumentList getArgumentList(ASTArguments args) {
        if (args != null) {
            return (ASTArgumentList)args.getFirstChildOfType(ASTArgumentList.class);
        }
        return null;
    }

    private int getArgumentListArity(ASTArgumentList argList) {
        if (argList != null) {
            return argList.jjtGetNumChildren();
        }
        return 0;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        Class<?> nodeType;
        JavaTypeDefinition previousType;
        Class<?> accessingClass = this.getEnclosingTypeDeclarationClass(node);
        String[] dotSplitImage = node.getImage().split("\\.");
        int startIndex = this.searchNodeNameForClass(node);
        ASTArguments astArguments = this.getSuffixMethodArgs(node);
        ASTArgumentList astArgumentList = this.getArgumentList(astArguments);
        int methodArgsArity = this.getArgumentListArity(astArgumentList);
        if (node.getType() != null) {
            previousType = node.getTypeDefinition();
        } else {
            if (dotSplitImage.length == 1 && astArguments != null) {
                List<MethodType> methods = this.getLocalApplicableMethods(node, dotSplitImage[0], Collections.emptyList(), methodArgsArity, accessingClass);
                TypeNode enclosingType = this.getEnclosingTypeDeclaration(node);
                if (enclosingType == null) {
                    return data;
                }
                previousType = MethodTypeResolution.getBestMethodReturnType(enclosingType.getTypeDefinition(), methods, astArgumentList);
            } else {
                previousType = this.getTypeDefinitionOfVariableFromScope(node.getScope(), dotSplitImage[0], accessingClass);
            }
            startIndex = 1;
        }
        if (node.getNameDeclaration() != null && previousType == null && node.getNameDeclaration().getNode() instanceof TypeNode && (nodeType = ((TypeNode)node.getNameDeclaration().getNode()).getType()) != null) {
            node.setType(nodeType);
            return super.visit(node, data);
        }
        for (int i = startIndex; i < dotSplitImage.length && previousType != null; ++i) {
            if (i == dotSplitImage.length - 1 && astArguments != null) {
                List<MethodType> methods = MethodTypeResolution.getApplicableMethods(previousType, dotSplitImage[i], Collections.emptyList(), methodArgsArity, accessingClass);
                previousType = MethodTypeResolution.getBestMethodReturnType(previousType, methods, astArgumentList);
                continue;
            }
            previousType = this.getFieldType(previousType, dotSplitImage[i], accessingClass);
        }
        if (previousType != null) {
            node.setTypeDefinition(previousType);
        }
        return super.visit(node, data);
    }

    private List<MethodType> getLocalApplicableMethods(TypeNode node, String methodName, List<JavaTypeDefinition> typeArguments, int argArity, Class<?> accessingClass) {
        ArrayList<MethodType> foundMethods = new ArrayList<MethodType>();
        if (accessingClass == null) {
            return foundMethods;
        }
        node = this.getEnclosingTypeDeclaration(node);
        while (node != null) {
            foundMethods.addAll(MethodTypeResolution.getApplicableMethods(node.getTypeDefinition(), methodName, typeArguments, argArity, accessingClass));
            node = this.getEnclosingTypeDeclaration(node.jjtGetParent());
        }
        foundMethods.addAll(this.searchImportedStaticMethods(methodName, typeArguments, argArity, accessingClass));
        return foundMethods;
    }

    private List<MethodType> searchImportedStaticMethods(String methodName, List<JavaTypeDefinition> typeArguments, int argArity, Class<?> accessingClass) {
        ArrayList<MethodType> foundMethods = new ArrayList<MethodType>();
        List<JavaTypeDefinition> explicitImports = this.staticNamesToClasses.get(methodName);
        if (explicitImports != null) {
            for (JavaTypeDefinition anImport : explicitImports) {
                foundMethods.addAll(MethodTypeResolution.getApplicableMethods(anImport, methodName, typeArguments, argArity, accessingClass));
            }
        }
        if (!foundMethods.isEmpty()) {
            return foundMethods;
        }
        for (JavaTypeDefinition anOnDemandImport : this.importOnDemandStaticClasses) {
            foundMethods.addAll(MethodTypeResolution.getApplicableMethods(anOnDemandImport, methodName, typeArguments, argArity, accessingClass));
        }
        return foundMethods;
    }

    private ASTArguments getSuffixMethodArgs(Node node) {
        Node prefix = node.jjtGetParent();
        if (prefix instanceof ASTPrimaryPrefix && prefix.jjtGetParent().jjtGetNumChildren() >= 2) {
            return (ASTArguments)prefix.jjtGetParent().jjtGetChild(1).getFirstChildOfType(ASTArguments.class);
        }
        return null;
    }

    private JavaTypeDefinition getFieldType(JavaTypeDefinition typeToSearch, String fieldImage, Class<?> accessingClass) {
        while (typeToSearch != null && typeToSearch.getType() != Object.class) {
            try {
                Field field = typeToSearch.getType().getDeclaredField(fieldImage);
                if (MethodTypeResolution.isMemberVisibleFromClass(typeToSearch.getType(), field.getModifiers(), accessingClass)) {
                    return typeToSearch.resolveTypeDefinition(field.getGenericType());
                }
            }
            catch (NoSuchFieldException field) {
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            typeToSearch = typeToSearch.resolveTypeDefinition(typeToSearch.getType().getGenericSuperclass());
        }
        return null;
    }

    private JavaTypeDefinition getTypeDefinitionOfVariableFromScope(Scope scope, String image, Class<?> accessingClass) {
        if (accessingClass == null) {
            return null;
        }
        while (scope != null) {
            for (Map.Entry entry : scope.getDeclarations(VariableNameDeclaration.class).entrySet()) {
                if (!((VariableNameDeclaration)entry.getKey()).getImage().equals(image)) continue;
                ASTType typeNode = ((VariableNameDeclaration)entry.getKey()).getDeclaratorId().getTypeNode();
                if (typeNode == null) {
                    return null;
                }
                if (typeNode.jjtGetChild(0) instanceof ASTReferenceType) {
                    return ((TypeNode)typeNode.jjtGetChild(0)).getTypeDefinition();
                }
                return JavaTypeDefinition.forClass(typeNode.getType(), new JavaTypeDefinition[0]);
            }
            if (scope instanceof ClassScope) {
                try {
                    JavaTypeDefinition superClass = this.getSuperClassTypeDefinition((Node)((ClassScope)scope).getClassDeclaration().getNode(), null);
                    JavaTypeDefinition foundTypeDef = this.getFieldType(superClass, image, accessingClass);
                    if (foundTypeDef != null) {
                        return foundTypeDef;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            scope = scope.getParent();
        }
        return this.searchImportedStaticFields(image);
    }

    private JavaTypeDefinition searchImportedStaticFields(String fieldName) {
        if (this.staticFieldImageToTypeDef.containsKey(fieldName)) {
            return this.staticFieldImageToTypeDef.get(fieldName);
        }
        for (JavaTypeDefinition anOnDemandImport : this.importOnDemandStaticClasses) {
            JavaTypeDefinition typeDef = this.getFieldType(anOnDemandImport, fieldName, this.currentAcu.getType());
            if (typeDef == null) continue;
            this.staticFieldImageToTypeDef.put(fieldName, typeDef);
            return typeDef;
        }
        return null;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclarator node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node == null || node.getNameDeclaration() == null) {
            return super.visit(node, data);
        }
        String name = node.getNameDeclaration().getTypeImage();
        if (name != null) {
            this.populateType(node, name, node.getNameDeclaration().getArrayDepth());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTType node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTReferenceType node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPrimitiveType node, Object data) {
        this.populateType(node, node.getImage());
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        super.visit(node, data);
        if (!node.isTernary()) {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalAndExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTInclusiveOrExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTExclusiveOrExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTAndExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTEqualityExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTInstanceOfExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTRelationalExpression node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTShiftExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTMultiplicativeExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeBinaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnaryNumericPromotion(node);
        return data;
    }

    @Override
    public Object visit(ASTPreIncrementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPreDecrementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpressionNotPlusMinus node, Object data) {
        super.visit(node, data);
        if ("!".equals(node.getImage())) {
            this.populateType(node, "boolean");
        } else {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTPostfixExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTCastExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTPrimaryExpression primaryNode, Object data) {
        for (int i = primaryNode.jjtGetNumChildren() - 1; i >= 0; --i) {
            ((JavaNode)primaryNode.jjtGetChild(i)).jjtAccept(this, data);
        }
        JavaTypeDefinition primaryNodeType = null;
        AbstractJavaTypeNode previousChild = null;
        Class<?> accessingClass = this.getEnclosingTypeDeclarationClass(primaryNode);
        for (int childIndex = 0; childIndex < primaryNode.jjtGetNumChildren(); ++childIndex) {
            AbstractJavaTypeNode nextChild;
            AbstractJavaTypeNode currentChild = (AbstractJavaTypeNode)primaryNode.jjtGetChild(childIndex);
            AbstractJavaTypeNode abstractJavaTypeNode = nextChild = childIndex + 1 < primaryNode.jjtGetNumChildren() ? (AbstractJavaTypeNode)primaryNode.jjtGetChild(childIndex + 1) : null;
            if (currentChild.getType() == null) {
                if (currentChild.jjtGetLastToken().toString().equals("this")) {
                    if (previousChild != null) {
                        currentChild.setTypeDefinition(previousChild.getTypeDefinition());
                    } else {
                        ASTClassOrInterfaceDeclaration typeDeclaration = (ASTClassOrInterfaceDeclaration)currentChild.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
                        if (typeDeclaration != null) {
                            currentChild.setTypeDefinition(typeDeclaration.getTypeDefinition());
                        }
                    }
                } else if (currentChild.jjtGetLastToken().toString().equals("super")) {
                    if (previousChild != null) {
                        currentChild.setTypeDefinition(this.getSuperClassTypeDefinition(currentChild, previousChild.getType()));
                    } else {
                        currentChild.setTypeDefinition(this.getSuperClassTypeDefinition(currentChild, null));
                    }
                } else if (currentChild.getFirstChildOfType(ASTArguments.class) != null) {
                    currentChild.setTypeDefinition(previousChild.getTypeDefinition());
                } else if (previousChild != null && previousChild.getType() != null) {
                    ASTArguments astArguments;
                    String currentChildImage = currentChild.getImage();
                    if (currentChildImage == null) {
                        currentChildImage = currentChild.jjtGetLastToken().toString();
                    }
                    ASTArguments aSTArguments = astArguments = nextChild != null ? (ASTArguments)nextChild.getFirstChildOfType(ASTArguments.class) : null;
                    if (astArguments != null) {
                        ASTArgumentList astArgumentList = this.getArgumentList(astArguments);
                        int methodArgsArity = this.getArgumentListArity(astArgumentList);
                        List<JavaTypeDefinition> typeArguments = MethodTypeResolution.getMethodExplicitTypeArugments(currentChild);
                        List<MethodType> methods = MethodTypeResolution.getApplicableMethods(previousChild.getTypeDefinition(), currentChildImage, typeArguments, methodArgsArity, accessingClass);
                        currentChild.setTypeDefinition(MethodTypeResolution.getBestMethodReturnType(previousChild.getTypeDefinition(), methods, astArgumentList));
                    } else {
                        currentChild.setTypeDefinition(this.getFieldType(previousChild.getTypeDefinition(), currentChildImage, accessingClass));
                    }
                }
            }
            if (currentChild.getType() == null) {
                primaryNodeType = null;
                break;
            }
            primaryNodeType = currentChild.getTypeDefinition();
            previousChild = currentChild;
        }
        primaryNode.setTypeDefinition(primaryNodeType);
        return data;
    }

    private TypeNode getEnclosingTypeDeclaration(Node node) {
        Node previousNode = null;
        while (node != null) {
            if (node instanceof ASTClassOrInterfaceDeclaration) {
                return (TypeNode)node;
            }
            if (node instanceof ASTAllocationExpression && node.getFirstChildOfType(ASTArrayDimsAndInits.class) == null && !(previousNode instanceof ASTArguments)) {
                return (TypeNode)node;
            }
            previousNode = node;
            node = node.jjtGetParent();
        }
        return null;
    }

    private Class<?> getEnclosingTypeDeclarationClass(Node node) {
        TypeNode typeDecl = this.getEnclosingTypeDeclaration(node);
        if (typeDecl == null) {
            return null;
        }
        return typeDecl.getType();
    }

    private JavaTypeDefinition getSuperClassTypeDefinition(Node node, Class<?> clazz) {
        Node previousNode = null;
        while (node != null) {
            if (node instanceof ASTClassOrInterfaceDeclaration && (((TypeNode)node).getType() == clazz || clazz == null)) {
                ASTExtendsList extendsList = (ASTExtendsList)node.getFirstChildOfType(ASTExtendsList.class);
                if (extendsList != null) {
                    return ((TypeNode)extendsList.jjtGetChild(0)).getTypeDefinition();
                }
                return JavaTypeDefinition.forClass(Object.class, new JavaTypeDefinition[0]);
            }
            if (clazz == null && node instanceof ASTAllocationExpression && node.getFirstChildOfType(ASTArrayDimsAndInits.class) == null && !(previousNode instanceof ASTArguments)) {
                return ((ASTClassOrInterfaceType)node.getFirstChildOfType(ASTClassOrInterfaceType.class)).getTypeDefinition();
            }
            previousNode = node;
            node = node.jjtGetParent();
        }
        return null;
    }

    @Override
    public Object visit(ASTPrimaryPrefix node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTTypeArgument node, Object data) {
        if (node.jjtGetNumChildren() == 0) {
            node.setTypeDefinition(JavaTypeDefinition.forClass(TypeDefinitionType.UPPER_WILDCARD, Object.class, new JavaTypeDefinition[0]));
        } else {
            super.visit(node, data);
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTWildcardBounds node, Object data) {
        super.visit(node, data);
        JavaTypeDefinition childType = ((TypeNode)node.jjtGetChild(0)).getTypeDefinition();
        if (node.jjtGetFirstToken().toString().equals("super")) {
            node.setTypeDefinition(JavaTypeDefinition.forClass(TypeDefinitionType.LOWER_WILDCARD, childType));
        } else {
            node.setTypeDefinition(JavaTypeDefinition.forClass(TypeDefinitionType.UPPER_WILDCARD, childType));
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeParameters node, Object data) {
        super.visit(node, data);
        if (node.jjtGetParent() instanceof ASTClassOrInterfaceDeclaration) {
            TypeNode parent = (TypeNode)node.jjtGetParent();
            JavaTypeDefinition[] boundGenerics = new JavaTypeDefinition[node.jjtGetNumChildren()];
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                boundGenerics[i] = ((TypeNode)node.jjtGetChild(i)).getTypeDefinition();
            }
            parent.setTypeDefinition(JavaTypeDefinition.forClass(parent.getType(), boundGenerics));
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeParameter node, Object data) {
        if (node.jjtGetNumChildren() == 0) {
            node.setTypeDefinition(JavaTypeDefinition.forClass(TypeDefinitionType.UPPER_BOUND, Object.class, new JavaTypeDefinition[0]));
        } else {
            super.visit(node, data);
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTTypeBound node, Object data) {
        super.visit(node, data);
        List typeNodes = node.findChildrenOfType(TypeNode.class);
        JavaTypeDefinition[] bounds = new JavaTypeDefinition[typeNodes.size()];
        for (int index = 0; index < typeNodes.size(); ++index) {
            bounds[index] = ((TypeNode)typeNodes.get(index)).getTypeDefinition();
        }
        node.setTypeDefinition(JavaTypeDefinition.forClass(TypeDefinitionType.UPPER_BOUND, bounds));
        return data;
    }

    @Override
    public Object visit(ASTNullLiteral node, Object data) {
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTBooleanLiteral node, Object data) {
        this.populateType(node, "boolean");
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        super.visit(node, data);
        if (node.jjtGetNumChildren() != 0) {
            this.rollupTypeUnary(node);
        } else if (node.isIntLiteral()) {
            this.populateType(node, "int");
        } else if (node.isLongLiteral()) {
            this.populateType(node, "long");
        } else if (node.isFloatLiteral()) {
            this.populateType(node, "float");
        } else if (node.isDoubleLiteral()) {
            this.populateType(node, "double");
        } else if (node.isCharLiteral()) {
            this.populateType(node, "char");
        } else if (node.isStringLiteral()) {
            this.populateType(node, "java.lang.String");
        } else {
            throw new IllegalStateException("PMD error, unknown literal type!");
        }
        return data;
    }

    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        super.visit(node, data);
        ASTArrayDimsAndInits dims = (ASTArrayDimsAndInits)node.getFirstChildOfType(ASTArrayDimsAndInits.class);
        if (dims != null) {
            Class<?> arrayType = ((TypeNode)node.jjtGetChild(0)).getType();
            if (arrayType != null) {
                node.setType(Array.newInstance(arrayType, (int[])Array.newInstance(Integer.TYPE, dims.getArrayDepth())).getClass());
            }
        } else {
            this.rollupTypeUnary(node);
        }
        return data;
    }

    @Override
    public Object visit(ASTStatementExpression node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTNormalAnnotation node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTMarkerAnnotation node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    @Override
    public Object visit(ASTSingleMemberAnnotation node, Object data) {
        super.visit(node, data);
        this.rollupTypeUnary(node);
        return data;
    }

    private void rollupTypeUnary(TypeNode typeNode) {
        Node child;
        TypeNode node = typeNode;
        if (node.jjtGetNumChildren() >= 1 && (child = node.jjtGetChild(0)) instanceof TypeNode) {
            typeNode.setTypeDefinition(((TypeNode)child).getTypeDefinition());
        }
    }

    private void rollupTypeUnaryNumericPromotion(TypeNode typeNode) {
        Class<?> type;
        Node child;
        TypeNode node = typeNode;
        if (node.jjtGetNumChildren() >= 1 && (child = node.jjtGetChild(0)) instanceof TypeNode && (type = ((TypeNode)child).getType()) != null) {
            if ("byte".equals(type.getName()) || "short".equals(type.getName()) || "char".equals(type.getName())) {
                this.populateType(typeNode, "int");
            } else {
                typeNode.setType(((TypeNode)child).getType());
            }
        }
    }

    private void rollupTypeBinaryNumericPromotion(TypeNode typeNode) {
        TypeNode node = typeNode;
        if (node.jjtGetNumChildren() >= 2) {
            Node child1 = node.jjtGetChild(0);
            Node child2 = node.jjtGetChild(1);
            if (child1 instanceof TypeNode && child2 instanceof TypeNode) {
                Class<?> type1 = ((TypeNode)child1).getType();
                Class<?> type2 = ((TypeNode)child2).getType();
                if (type1 != null && type2 != null) {
                    if ("java.lang.String".equals(type1.getName()) || "java.lang.String".equals(type2.getName())) {
                        this.populateType(typeNode, "java.lang.String");
                    } else if ("boolean".equals(type1.getName()) || "boolean".equals(type2.getName())) {
                        this.populateType(typeNode, "boolean");
                    } else if ("double".equals(type1.getName()) || "double".equals(type2.getName())) {
                        this.populateType(typeNode, "double");
                    } else if ("float".equals(type1.getName()) || "float".equals(type2.getName())) {
                        this.populateType(typeNode, "float");
                    } else if ("long".equals(type1.getName()) || "long".equals(type2.getName())) {
                        this.populateType(typeNode, "long");
                    } else {
                        this.populateType(typeNode, "int");
                    }
                } else if ((type1 != null || type2 != null) && (type1 != null && "java.lang.String".equals(type1.getName()) || type2 != null && "java.lang.String".equals(type2.getName()))) {
                    this.populateType(typeNode, "java.lang.String");
                }
            }
        }
    }

    private void populateType(TypeNode node, String className) {
        this.populateType(node, className, 0);
    }

    private void populateType(TypeNode node, String className, int arrayDimens) {
        String qualifiedName = className;
        Class<?> myType = PRIMITIVE_TYPES.get(className);
        if (myType == null && this.importedClasses != null) {
            if (this.importedClasses.containsKey(className)) {
                qualifiedName = this.importedClasses.get(className);
            } else if (this.importedClasses.containsValue(className)) {
                qualifiedName = className;
            }
            if (qualifiedName != null) {
                try {
                    myType = this.pmdClassLoader.loadClass(qualifiedName);
                }
                catch (ClassNotFoundException e) {
                    myType = this.processOnDemand(qualifiedName);
                }
                catch (LinkageError e) {
                    myType = this.processOnDemand(qualifiedName);
                }
            }
        }
        if (myType == null && qualifiedName != null && qualifiedName.contains(".")) {
            String qualifiedNameInner = qualifiedName.substring(0, qualifiedName.lastIndexOf(46)) + "$" + qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
            try {
                myType = this.pmdClassLoader.loadClass(qualifiedNameInner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (myType == null && qualifiedName != null && !qualifiedName.contains(".")) {
            try {
                myType = this.pmdClassLoader.loadClass("java.lang." + qualifiedName);
            }
            catch (Exception qualifiedNameInner) {
                // empty catch block
            }
        }
        if (myType == null) {
            ASTTypeParameter parameter = this.getTypeParameterDeclaration(node, className);
            if (parameter != null) {
                node.setTypeDefinition(parameter.getTypeDefinition());
            }
        } else {
            if (arrayDimens > 0) {
                myType = Array.newInstance(myType, (int[])Array.newInstance(Integer.TYPE, arrayDimens)).getClass();
            }
            node.setType(myType);
        }
    }

    private ASTTypeParameter getTypeParameterDeclaration(Node startNode, String image) {
        for (Node parent = startNode.jjtGetParent(); parent != null; parent = parent.jjtGetParent()) {
            ASTTypeParameters typeParameters = null;
            if (parent instanceof ASTTypeParameters) {
                typeParameters = (ASTTypeParameters)parent;
            } else if (parent instanceof ASTConstructorDeclaration || parent instanceof ASTMethodDeclaration || parent instanceof ASTClassOrInterfaceDeclaration) {
                typeParameters = (ASTTypeParameters)parent.getFirstChildOfType(ASTTypeParameters.class);
            }
            if (typeParameters == null) continue;
            for (int index = 0; index < typeParameters.jjtGetNumChildren(); ++index) {
                String imageToCompareTo = typeParameters.jjtGetChild(index).getImage();
                if (imageToCompareTo == null || !imageToCompareTo.equals(image)) continue;
                return (ASTTypeParameter)typeParameters.jjtGetChild(index);
            }
        }
        return null;
    }

    public boolean classNameExists(String fullyQualifiedClassName) {
        try {
            this.pmdClassLoader.loadClass(fullyQualifiedClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public Class<?> loadClass(String fullyQualifiedClassName) {
        try {
            return this.pmdClassLoader.loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Class<?> processOnDemand(String qualifiedName) {
        for (String entry : this.importedOnDemand) {
            try {
                return this.pmdClassLoader.loadClass(entry + "." + qualifiedName);
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    private String getClassName(ASTCompilationUnit node) {
        ASTClassOrInterfaceDeclaration classDecl = (ASTClassOrInterfaceDeclaration)node.getFirstDescendantOfType(ASTClassOrInterfaceDeclaration.class);
        if (classDecl == null) {
            return null;
        }
        if (node.declarationsAreInDefaultPackage()) {
            return classDecl.getImage();
        }
        ASTPackageDeclaration pkgDecl = node.getPackageDeclaration();
        this.importedOnDemand.add(pkgDecl.getPackageNameImage());
        return pkgDecl.getPackageNameImage() + "." + classDecl.getImage();
    }

    private void populateImports(ASTCompilationUnit node) {
        List theImportDeclarations = node.findChildrenOfType(ASTImportDeclaration.class);
        this.importedClasses.putAll(JAVA_LANG);
        for (ASTImportDeclaration anImportDeclaration : theImportDeclarations) {
            String strName;
            String strPackage = anImportDeclaration.getPackageName();
            if (anImportDeclaration.isStatic()) {
                List<JavaTypeDefinition> typeList;
                if (anImportDeclaration.isImportOnDemand()) {
                    this.importOnDemandStaticClasses.add(JavaTypeDefinition.forClass(this.loadClass(strPackage), new JavaTypeDefinition[0]));
                    continue;
                }
                strName = anImportDeclaration.getImportedName();
                String fieldName = strName.substring(strName.lastIndexOf(46) + 1);
                Class<?> staticClassWithField = this.loadClass(strPackage);
                if (staticClassWithField != null) {
                    JavaTypeDefinition typeDef = this.getFieldType(JavaTypeDefinition.forClass(staticClassWithField, new JavaTypeDefinition[0]), fieldName, this.currentAcu.getType());
                    this.staticFieldImageToTypeDef.put(fieldName, typeDef);
                }
                if ((typeList = this.staticNamesToClasses.get(fieldName)) == null) {
                    typeList = new ArrayList<JavaTypeDefinition>();
                }
                typeList.add(JavaTypeDefinition.forClass(staticClassWithField, new JavaTypeDefinition[0]));
                this.staticNamesToClasses.put(fieldName, typeList);
                continue;
            }
            if (anImportDeclaration.isImportOnDemand()) {
                this.importedOnDemand.add(strPackage);
                continue;
            }
            strName = anImportDeclaration.getImportedName();
            this.importedClasses.put(strName, strName);
            this.importedClasses.put(strName.substring(strPackage.length() + 1), strName);
        }
    }

    private void populateClassName(ASTCompilationUnit node, String className) throws ClassNotFoundException {
        node.setType(this.pmdClassLoader.loadClass(className));
        this.importedClasses.putAll(this.pmdClassLoader.getImportedClasses(className));
    }

    static {
        HashMap<String, Class<Object>> thePrimitiveTypes = new HashMap<String, Class<Object>>();
        thePrimitiveTypes.put("void", Void.TYPE);
        thePrimitiveTypes.put("boolean", Boolean.TYPE);
        thePrimitiveTypes.put("byte", Byte.TYPE);
        thePrimitiveTypes.put("char", Character.TYPE);
        thePrimitiveTypes.put("short", Short.TYPE);
        thePrimitiveTypes.put("int", Integer.TYPE);
        thePrimitiveTypes.put("long", Long.TYPE);
        thePrimitiveTypes.put("float", Float.TYPE);
        thePrimitiveTypes.put("double", Double.TYPE);
        PRIMITIVE_TYPES = Collections.unmodifiableMap(thePrimitiveTypes);
        HashMap<String, String> theJavaLang = new HashMap<String, String>();
        theJavaLang.put("Boolean", "java.lang.Boolean");
        theJavaLang.put("Byte", "java.lang.Byte");
        theJavaLang.put("Character", "java.lang.Character");
        theJavaLang.put("CharSequence", "java.lang.CharSequence");
        theJavaLang.put("Class", "java.lang.Class");
        theJavaLang.put("ClassLoader", "java.lang.ClassLoader");
        theJavaLang.put("Cloneable", "java.lang.Cloneable");
        theJavaLang.put("Comparable", "java.lang.Comparable");
        theJavaLang.put("Compiler", "java.lang.Compiler");
        theJavaLang.put("Double", "java.lang.Double");
        theJavaLang.put("Float", "java.lang.Float");
        theJavaLang.put("InheritableThreadLocal", "java.lang.InheritableThreadLocal");
        theJavaLang.put("Integer", "java.lang.Integer");
        theJavaLang.put("Long", "java.lang.Long");
        theJavaLang.put("Math", "java.lang.Math");
        theJavaLang.put("Number", "java.lang.Number");
        theJavaLang.put("Object", "java.lang.Object");
        theJavaLang.put("Package", "java.lang.Package");
        theJavaLang.put("Process", "java.lang.Process");
        theJavaLang.put("Runnable", "java.lang.Runnable");
        theJavaLang.put("Runtime", "java.lang.Runtime");
        theJavaLang.put("RuntimePermission", "java.lang.RuntimePermission");
        theJavaLang.put("SecurityManager", "java.lang.SecurityManager");
        theJavaLang.put("Short", "java.lang.Short");
        theJavaLang.put("StackTraceElement", "java.lang.StackTraceElement");
        theJavaLang.put("StrictMath", "java.lang.StrictMath");
        theJavaLang.put("String", "java.lang.String");
        theJavaLang.put("StringBuffer", "java.lang.StringBuffer");
        theJavaLang.put("System", "java.lang.System");
        theJavaLang.put("Thread", "java.lang.Thread");
        theJavaLang.put("ThreadGroup", "java.lang.ThreadGroup");
        theJavaLang.put("ThreadLocal", "java.lang.ThreadLocal");
        theJavaLang.put("Throwable", "java.lang.Throwable");
        theJavaLang.put("Void", "java.lang.Void");
        JAVA_LANG = Collections.unmodifiableMap(theJavaLang);
    }

    private static class AnonymousClassMetadata {
        public final String name;
        public int anonymousClassCounter;

        AnonymousClassMetadata(String className) {
            this.name = className;
        }
    }
}

