/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.LocalScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class LawOfDemeterRule
extends AbstractJavaRule {
    private static final String REASON_METHOD_CHAIN_CALLS = "method chain calls";
    private static final String REASON_OBJECT_NOT_CREATED_LOCALLY = "object not created locally";
    private static final String REASON_STATIC_ACCESS = "static property access";

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        List primaryExpressions = node.findDescendantsOfType(ASTPrimaryExpression.class);
        for (ASTPrimaryExpression expression : primaryExpressions) {
            List<MethodCall> calls = MethodCall.createMethodCalls(expression);
            this.addViolations(calls, (RuleContext)data);
        }
        return null;
    }

    private void addViolations(List<MethodCall> calls, RuleContext ctx) {
        for (MethodCall method : calls) {
            if (!method.isViolation()) continue;
            this.addViolationWithMessage(ctx, method.getExpression(), this.getMessage() + " (" + method.getViolationReason() + ")");
        }
    }

    private static class Assignment
    implements Comparable<Assignment> {
        private int line;
        private boolean allocation;
        private boolean iterator;
        private boolean forLoop;

        Assignment(int line, boolean allocation, boolean iterator, boolean forLoop) {
            this.line = line;
            this.allocation = allocation;
            this.iterator = iterator;
            this.forLoop = forLoop;
        }

        public String toString() {
            return "assignment: line=" + this.line + " allocation:" + this.allocation + " iterator:" + this.iterator + " forLoop: " + this.forLoop;
        }

        @Override
        public int compareTo(Assignment o) {
            return o.line - this.line;
        }
    }

    private static class MethodCall {
        private static final String METHOD_CALL_CHAIN = "result from previous method call";
        private static final String SIMPLE_ASSIGNMENT_OPERATOR = "=";
        private static final String SCOPE_METHOD_CHAINING = "method-chaining";
        private static final String SCOPE_CLASS = "class";
        private static final String SCOPE_METHOD = "method";
        private static final String SCOPE_LOCAL = "local";
        private static final String SCOPE_STATIC_CHAIN = "static-chain";
        private static final String SUPER = "super";
        private static final String THIS = "this";
        private static final String PREFIX_EXCLUSION_PATTERN = "^.*(b|B)uilder$";
        private ASTPrimaryExpression expression;
        private String baseName;
        private String methodName;
        private String baseScope;
        private String baseTypeName;
        private Class<?> baseType;
        private boolean violation;
        private boolean baseNameInWhitelist;
        private String violationReason;

        private MethodCall(ASTPrimaryExpression expression, ASTPrimaryPrefix prefix) {
            this.expression = expression;
            this.analyze(prefix);
            this.determineType();
            this.checkViolation();
        }

        private MethodCall(ASTPrimaryExpression expression, ASTPrimarySuffix suffix) {
            this.expression = expression;
            this.analyze(suffix);
            this.determineType();
            this.checkViolation();
        }

        public static List<MethodCall> createMethodCalls(ASTPrimaryExpression expression) {
            ArrayList<MethodCall> result = new ArrayList<MethodCall>();
            if (MethodCall.isNotAConstructorCall(expression) && MethodCall.isNotLiteral(expression) && MethodCall.hasSuffixesWithArguments(expression)) {
                ASTPrimaryPrefix prefixNode = (ASTPrimaryPrefix)expression.getFirstDescendantOfType(ASTPrimaryPrefix.class);
                MethodCall firstMethodCallInChain = new MethodCall(expression, prefixNode);
                result.add(firstMethodCallInChain);
                if (firstMethodCallInChain.isNotBuilder()) {
                    List<ASTPrimarySuffix> suffixes = MethodCall.findSuffixesWithoutArguments(expression);
                    for (ASTPrimarySuffix suffix : suffixes) {
                        result.add(new MethodCall(expression, suffix));
                    }
                }
            }
            return result;
        }

        private static boolean isNotAConstructorCall(ASTPrimaryExpression expression) {
            return !expression.hasDescendantOfType(ASTAllocationExpression.class);
        }

        private static boolean isNotLiteral(ASTPrimaryExpression expression) {
            ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)expression.getFirstDescendantOfType(ASTPrimaryPrefix.class);
            if (prefix != null) {
                return !prefix.hasDescendantOfType(ASTLiteral.class);
            }
            return true;
        }

        private boolean isNotBuilder() {
            return this.baseType != StringBuffer.class && this.baseType != StringBuilder.class && !"StringBuilder".equals(this.baseTypeName) && !"StringBuffer".equals(this.baseTypeName);
        }

        private static List<ASTPrimarySuffix> findSuffixesWithoutArguments(ASTPrimaryExpression expr) {
            ArrayList<ASTPrimarySuffix> result = new ArrayList<ASTPrimarySuffix>();
            if (MethodCall.hasRealPrefix(expr)) {
                List suffixes = expr.findDescendantsOfType(ASTPrimarySuffix.class);
                for (ASTPrimarySuffix suffix : suffixes) {
                    if (suffix.isArguments()) continue;
                    result.add(suffix);
                }
            }
            return result;
        }

        private static boolean hasRealPrefix(ASTPrimaryExpression expr) {
            ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)expr.getFirstDescendantOfType(ASTPrimaryPrefix.class);
            return !prefix.usesThisModifier() && !prefix.usesSuperModifier();
        }

        private static boolean hasSuffixesWithArguments(ASTPrimaryExpression expr) {
            boolean result = false;
            if (MethodCall.hasRealPrefix(expr)) {
                List suffixes = expr.findDescendantsOfType(ASTPrimarySuffix.class);
                for (ASTPrimarySuffix suffix : suffixes) {
                    if (!suffix.isArguments()) continue;
                    result = true;
                    break;
                }
            }
            return result;
        }

        private void analyze(ASTPrimaryPrefix prefixNode) {
            List names = prefixNode.findDescendantsOfType(ASTName.class);
            this.baseName = "unknown";
            this.methodName = "unknown";
            if (!names.isEmpty()) {
                this.baseName = ((ASTName)names.get(0)).getImage();
                int dot = this.baseName.lastIndexOf(46);
                if (dot == -1) {
                    this.methodName = this.baseName;
                    this.baseName = THIS;
                } else {
                    this.methodName = this.baseName.substring(dot + 1);
                    this.baseName = this.baseName.substring(0, dot);
                    this.baseNameInWhitelist = this.baseName.matches(PREFIX_EXCLUSION_PATTERN);
                }
            } else if (prefixNode.usesThisModifier()) {
                this.baseName = THIS;
            } else if (prefixNode.usesSuperModifier()) {
                this.baseName = SUPER;
            }
        }

        private void analyze(ASTPrimarySuffix suffix) {
            this.baseName = METHOD_CALL_CHAIN;
            this.methodName = suffix.getImage();
        }

        private void checkViolation() {
            this.violation = false;
            this.violationReason = null;
            if (this.baseNameInWhitelist) {
                return;
            }
            if (SCOPE_LOCAL.equals(this.baseScope)) {
                Assignment lastAssignment = this.determineLastAssignment();
                if (!(lastAssignment == null || lastAssignment.allocation || lastAssignment.iterator || lastAssignment.forLoop)) {
                    this.violation = true;
                    this.violationReason = LawOfDemeterRule.REASON_OBJECT_NOT_CREATED_LOCALLY;
                }
            } else if (SCOPE_METHOD_CHAINING.equals(this.baseScope)) {
                this.violation = true;
                this.violationReason = LawOfDemeterRule.REASON_METHOD_CHAIN_CALLS;
            } else if (SCOPE_STATIC_CHAIN.equals(this.baseScope)) {
                this.violation = true;
                this.violationReason = LawOfDemeterRule.REASON_STATIC_ACCESS;
            }
        }

        private void determineType() {
            VariableNameDeclaration var = null;
            Scope scope = this.expression.getScope();
            this.baseScope = SCOPE_LOCAL;
            var = this.findInLocalScope(this.baseName, scope);
            if (var == null) {
                this.baseScope = SCOPE_METHOD;
                var = this.determineTypeOfVariable(this.baseName, ((MethodScope)scope.getEnclosingScope(MethodScope.class)).getVariableDeclarations().keySet());
            }
            if (var == null) {
                this.baseScope = SCOPE_CLASS;
                var = this.determineTypeOfVariable(this.baseName, ((ClassScope)scope.getEnclosingScope(ClassScope.class)).getVariableDeclarations().keySet());
            }
            if (var == null) {
                this.baseScope = SCOPE_METHOD_CHAINING;
            }
            if (var == null && (THIS.equals(this.baseName) || SUPER.equals(this.baseName))) {
                this.baseScope = SCOPE_CLASS;
            }
            if (var instanceof TypedNameDeclaration) {
                this.baseTypeName = ((TypedNameDeclaration)var).getTypeImage();
                this.baseType = ((TypedNameDeclaration)var).getType();
            } else {
                this.baseScope = METHOD_CALL_CHAIN.equals(this.baseName) ? SCOPE_METHOD_CHAINING : (this.baseName.contains(".") && !this.baseName.startsWith("System.") ? SCOPE_STATIC_CHAIN : null);
            }
        }

        private VariableNameDeclaration findInLocalScope(String name, Scope scope) {
            VariableNameDeclaration result = null;
            result = this.determineTypeOfVariable(name, scope.getDeclarations(VariableNameDeclaration.class).keySet());
            if (result == null && scope.getParent() instanceof LocalScope) {
                result = this.findInLocalScope(name, scope.getParent());
            }
            return result;
        }

        private VariableNameDeclaration determineTypeOfVariable(String variableName, Set<VariableNameDeclaration> declarations) {
            VariableNameDeclaration result = null;
            for (VariableNameDeclaration var : declarations) {
                if (!variableName.equals(var.getImage())) continue;
                result = var;
                break;
            }
            return result;
        }

        private Assignment determineLastAssignment() {
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            ASTBlock block = (ASTBlock)((ASTMethodDeclaration)this.expression.getFirstParentOfType(ASTMethodDeclaration.class)).getFirstChildOfType(ASTBlock.class);
            List variableDeclarators = block.findDescendantsOfType(ASTVariableDeclarator.class);
            for (Object declarator : variableDeclarators) {
                ASTVariableDeclaratorId variableDeclaratorId = (ASTVariableDeclaratorId)declarator.getFirstChildOfType(ASTVariableDeclaratorId.class);
                if (!variableDeclaratorId.hasImageEqualTo(this.baseName)) continue;
                boolean allocationFound = declarator.getFirstDescendantOfType(ASTAllocationExpression.class) != null;
                boolean iterator = this.isIterator() || this.isFactory((ASTVariableDeclarator)declarator);
                boolean forLoop = this.isForLoop((ASTVariableDeclarator)declarator);
                assignments.add(new Assignment(declarator.getBeginLine(), allocationFound, iterator, forLoop));
            }
            List assignmentStmts = block.findDescendantsOfType(ASTAssignmentOperator.class);
            for (ASTAssignmentOperator stmt : assignmentStmts) {
                ASTName prefixName;
                ASTPrimaryPrefix primaryPrefix;
                if (stmt.getBeginLine() > this.expression.getBeginLine() || !stmt.hasImageEqualTo(SIMPLE_ASSIGNMENT_OPERATOR) || (primaryPrefix = (ASTPrimaryPrefix)stmt.jjtGetParent().getFirstDescendantOfType(ASTPrimaryPrefix.class)) == null || (prefixName = (ASTName)primaryPrefix.getFirstChildOfType(ASTName.class)) == null || !prefixName.hasImageEqualTo(this.baseName)) continue;
                boolean allocationFound = stmt.jjtGetParent().getFirstDescendantOfType(ASTAllocationExpression.class) != null;
                boolean iterator = this.isIterator();
                assignments.add(new Assignment(stmt.getBeginLine(), allocationFound, iterator, false));
            }
            Assignment result = null;
            if (!assignments.isEmpty()) {
                Collections.sort(assignments);
                result = (Assignment)assignments.get(0);
            }
            return result;
        }

        private boolean isIterator() {
            boolean iterator = false;
            if (this.baseType != null && this.baseType == Iterator.class || this.baseTypeName != null && this.baseTypeName.endsWith("Iterator")) {
                iterator = true;
            }
            return iterator;
        }

        private boolean isFactory(ASTVariableDeclarator declarator) {
            boolean factory = false;
            List names = declarator.findDescendantsOfType(ASTName.class);
            for (ASTName name : names) {
                if (!name.getImage().toLowerCase().contains("factory")) continue;
                factory = true;
                break;
            }
            return factory;
        }

        private boolean isForLoop(ASTVariableDeclarator declarator) {
            return declarator.jjtGetParent().jjtGetParent() instanceof ASTForStatement;
        }

        public ASTPrimaryExpression getExpression() {
            return this.expression;
        }

        public boolean isViolation() {
            return this.violation;
        }

        public String getViolationReason() {
            return this.violationReason;
        }

        public String toString() {
            return "MethodCall on line " + this.expression.getBeginLine() + ":\n  " + this.baseName + " name: " + this.methodName + "\n  type: " + this.baseTypeName + " (" + this.baseType + "), \n  scope: " + this.baseScope + "\n  violation: " + this.violation + " (" + this.violationReason + ")\n";
        }
    }
}

