/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.metrics.impl.CycloMetric;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.properties.EnumeratedMultiProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class CyclomaticComplexityRule
extends AbstractJavaMetricsRule {
    private static final Logger LOG = Logger.getLogger(CyclomaticComplexityRule.class.getName());
    @Deprecated
    private static final IntegerProperty REPORT_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"reportLevel").desc("Deprecated! Cyclomatic Complexity reporting threshold")).range((Object)1, (Object)30)).defaultValue((Object)10)).uiOrder(1.0f)).build();
    private static final IntegerProperty CLASS_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"classReportLevel").desc("Total class complexity reporting threshold")).range((Object)1, (Object)600)).defaultValue((Object)80)).uiOrder(1.0f)).build();
    private static final IntegerProperty METHOD_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"methodReportLevel").desc("Cyclomatic complexity reporting threshold")).range((Object)1, (Object)50)).defaultValue((Object)10)).uiOrder(1.0f)).build();
    private static final Map<String, CycloMetric.CycloOption> OPTION_MAP = new HashMap<String, CycloMetric.CycloOption>();
    private static final EnumeratedMultiProperty<CycloMetric.CycloOption> CYCLO_OPTIONS_DESCRIPTOR;
    private int methodReportLevel;
    private int classReportLevel;
    private MetricOptions cycloOptions;

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)METHOD_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CYCLO_OPTIONS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
    }

    private void assignReportLevelsCompat() {
        int methodLevel = (Integer)this.getProperty((PropertyDescriptor)METHOD_LEVEL_DESCRIPTOR);
        int classLevel = (Integer)this.getProperty((PropertyDescriptor)CLASS_LEVEL_DESCRIPTOR);
        int commonLevel = (Integer)this.getProperty((PropertyDescriptor)REPORT_LEVEL_DESCRIPTOR);
        if (methodLevel == (Integer)METHOD_LEVEL_DESCRIPTOR.defaultValue() && classLevel == (Integer)CLASS_LEVEL_DESCRIPTOR.defaultValue() && commonLevel != (Integer)REPORT_LEVEL_DESCRIPTOR.defaultValue()) {
            LOG.warning("Rule CyclomaticComplexity uses deprecated property 'reportLevel'. Future versions of PMD will remove support for this property. Please use 'methodReportLevel' and 'classReportLevel' instead!");
            methodLevel = commonLevel;
            classLevel = commonLevel * 8;
        }
        this.methodReportLevel = methodLevel;
        this.classReportLevel = classLevel;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.assignReportLevelsCompat();
        this.cycloOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty((PropertyDescriptor)CYCLO_OPTIONS_DESCRIPTOR)));
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        int classWmc;
        super.visit(node, data);
        if (JavaClassMetricKey.WMC.supports(node) && (classWmc = (int)JavaMetrics.get(JavaClassMetricKey.WMC, node, this.cycloOptions)) >= this.classReportLevel) {
            int classHighest = (int)JavaMetrics.get(JavaOperationMetricKey.CYCLO, node, this.cycloOptions, ResultOption.HIGHEST);
            Object[] messageParams = new String[]{node.getTypeKind().name().toLowerCase(), node.getImage(), " total", classWmc + " (highest " + classHighest + ")"};
            this.addViolation(data, node, messageParams);
        }
        return data;
    }

    @Override
    public final Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        int cyclo = (int)JavaMetrics.get((MetricKey<ASTMethodOrConstructorDeclaration>)JavaOperationMetricKey.CYCLO, node, this.cycloOptions);
        if (cyclo >= this.methodReportLevel) {
            this.addViolation(data, node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", node.getQualifiedName().getOperation(), "", "" + cyclo});
        }
        return data;
    }

    static {
        OPTION_MAP.put(CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS.valueName(), CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS);
        OPTION_MAP.put(CycloMetric.CycloOption.CONSIDER_ASSERT.valueName(), CycloMetric.CycloOption.CONSIDER_ASSERT);
        CYCLO_OPTIONS_DESCRIPTOR = ((EnumeratedMultiProperty.EnumMultiPBuilder)((EnumeratedMultiProperty.EnumMultiPBuilder)((EnumeratedMultiProperty.EnumMultiPBuilder)EnumeratedMultiProperty.named((String)"cycloOptions").type(CycloMetric.CycloOption.class).desc("Choose options for the computation of Cyclo")).mappings(OPTION_MAP).defaultValues(Collections.emptyList())).uiOrder(3.0f)).build();
    }
}

