/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;

public class UnnecessaryFullyQualifiedNameRule
extends AbstractJavaRule {
    private List<ASTImportDeclaration> imports = new ArrayList<ASTImportDeclaration>();
    private List<ASTImportDeclaration> matches = new ArrayList<ASTImportDeclaration>();

    public UnnecessaryFullyQualifiedNameRule() {
        super.addRuleChainVisit(ASTCompilationUnit.class);
        super.addRuleChainVisit(ASTImportDeclaration.class);
        super.addRuleChainVisit(ASTClassOrInterfaceType.class);
        super.addRuleChainVisit(ASTName.class);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        return data;
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        this.imports.add(node);
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.checkImports(node, data);
        return data;
    }

    @Override
    public Object visit(ASTName node, Object data) {
        if (!(node.jjtGetParent() instanceof ASTImportDeclaration) && !(node.jjtGetParent() instanceof ASTPackageDeclaration)) {
            this.checkImports(node, data);
        }
        return data;
    }

    private void checkImports(JavaNode node, Object data) {
        ASTImportDeclaration firstMatch;
        String name = node.getImage();
        this.matches.clear();
        for (ASTImportDeclaration importDeclaration : this.imports) {
            if (importDeclaration.isImportOnDemand()) {
                if (!name.startsWith(importDeclaration.getImportedName()) || name.lastIndexOf(46) != importDeclaration.getImportedName().length()) continue;
                this.matches.add(importDeclaration);
                continue;
            }
            if (name.equals(importDeclaration.getImportedName())) {
                this.matches.add(importDeclaration);
                continue;
            }
            if (!name.startsWith(importDeclaration.getImportedName()) || name.lastIndexOf(46) != importDeclaration.getImportedName().length()) continue;
            this.matches.add(importDeclaration);
        }
        if (this.matches.isEmpty() && name.indexOf(46) >= 0) {
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (!importDeclaration.isStatic()) continue;
                String[] importParts = importDeclaration.getImportedName().split("\\.");
                String[] nameParts = name.split("\\.");
                if (importDeclaration.isImportOnDemand()) {
                    if (!nameParts[nameParts.length - 2].equals(importParts[importParts.length - 1])) continue;
                    this.matches.add(importDeclaration);
                    continue;
                }
                if (!nameParts[nameParts.length - 1].equals(importParts[importParts.length - 1]) || !nameParts[nameParts.length - 2].equals(importParts[importParts.length - 2])) continue;
                this.matches.add(importDeclaration);
            }
        }
        if (!this.matches.isEmpty() && !this.isAvoidingConflict(node, name, firstMatch = this.matches.get(0))) {
            String importStr = firstMatch.getImportedName() + (firstMatch.isImportOnDemand() ? ".*" : "");
            String type = firstMatch.isStatic() ? "static " : "";
            this.addViolation(data, (Node)node, new Object[]{node.getImage(), importStr, type});
        }
        this.matches.clear();
    }

    private boolean isAvoidingConflict(JavaNode node, String name, ASTImportDeclaration firstMatch) {
        if (firstMatch.isImportOnDemand() && firstMatch.isStatic() && name.indexOf(46) != -1) {
            String methodCalled = name.substring(name.indexOf(46) + 1);
            for (ASTImportDeclaration importDeclaration : this.imports) {
                if (importDeclaration == firstMatch || !importDeclaration.isStatic() || importDeclaration.getImportedName().startsWith(firstMatch.getImportedName()) && importDeclaration.getImportedName().lastIndexOf(46) == firstMatch.getImportedName().length()) continue;
                if (importDeclaration.isImportOnDemand()) {
                    if (importDeclaration.getType() == null) continue;
                    for (Method m : importDeclaration.getType().getMethods()) {
                        if (!m.getName().equals(methodCalled)) continue;
                        return true;
                    }
                    continue;
                }
                if (!importDeclaration.getImportedName().endsWith(methodCalled)) continue;
                return true;
            }
        }
        String unqualifiedName = name.substring(name.lastIndexOf(46) + 1);
        int unqualifiedNameLength = unqualifiedName.length();
        Set<String> qualifiedTypes = ((SourceFileScope)node.getScope().getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().keySet();
        for (String qualified : qualifiedTypes) {
            int fullLength = qualified.length();
            if (!qualified.endsWith(unqualifiedName) || fullLength != unqualifiedNameLength && qualified.charAt(fullLength - unqualifiedNameLength - 1) != '.') continue;
            return true;
        }
        return false;
    }
}

