/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNormalAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTSingleMemberAnnotation;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTAnnotation
extends AbstractJavaNode {
    private static List<String> unusedRules = Arrays.asList("UnusedPrivateField", "UnusedLocalVariable", "UnusedPrivateMethod", "UnusedFormalParameter");
    private static List<String> serialRules = Arrays.asList("BeanMembersShouldSerialize", "MissingSerialVersionUID");

    public ASTAnnotation(int id) {
        super(id);
    }

    public ASTAnnotation(JavaParser p, int id) {
        super(p, id);
    }

    public boolean suppresses(Rule rule) {
        String ruleAnno = "\"PMD." + rule.getName() + "\"";
        if (this.jjtGetChild(0) instanceof ASTSingleMemberAnnotation) {
            ASTSingleMemberAnnotation n = (ASTSingleMemberAnnotation)this.jjtGetChild(0);
            return this.checkAnnototation(n, ruleAnno, rule);
        }
        if (this.jjtGetChild(0) instanceof ASTNormalAnnotation) {
            ASTNormalAnnotation n = (ASTNormalAnnotation)this.jjtGetChild(0);
            return this.checkAnnototation(n, ruleAnno, rule);
        }
        return false;
    }

    private boolean checkAnnototation(Node n, String ruleAnno, Rule rule) {
        ASTName annName;
        if (n.jjtGetChild(0) instanceof ASTName && ("SuppressWarnings".equals((annName = (ASTName)n.jjtGetChild(0)).getImage()) || "java.lang.SuppressWarnings".equals(annName.getImage()))) {
            List nodes = n.findDescendantsOfType(ASTLiteral.class);
            for (ASTLiteral element : nodes) {
                if (!element.hasImageEqualTo("\"PMD\"") && !element.hasImageEqualTo(ruleAnno) && !element.hasImageEqualTo("\"all\"") && (!element.hasImageEqualTo("\"serial\"") || !serialRules.contains(rule.getName())) && (!element.hasImageEqualTo("\"unused\"") || !unusedRules.contains(rule.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }
}

