/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties.modules;

import java.util.Map;
import net.sourceforge.pmd.properties.PropertyDescriptorField;

public class NumericPropertyModule<T extends Number> {
    private final T lowerLimit;
    private final T upperLimit;

    public NumericPropertyModule(T lowerLimit, T upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.checkNumber(lowerLimit);
        this.checkNumber(upperLimit);
        if (((Number)lowerLimit).doubleValue() > ((Number)upperLimit).doubleValue()) {
            throw new IllegalArgumentException("Lower limit cannot be greater than the upper limit");
        }
    }

    public void checkNumber(T number) {
        String error = this.valueErrorFor(number);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public String valueErrorFor(T value) {
        if (value == null) {
            return "Missing value";
        }
        double number = ((Number)value).doubleValue();
        if (number > ((Number)this.upperLimit).doubleValue() || number < ((Number)this.lowerLimit).doubleValue()) {
            return value + " is out of range " + NumericPropertyModule.rangeString(this.lowerLimit, this.upperLimit);
        }
        return null;
    }

    public T getLowerLimit() {
        return this.lowerLimit;
    }

    public T getUpperLimit() {
        return this.upperLimit;
    }

    public void addAttributesTo(Map<PropertyDescriptorField, String> attributes) {
        attributes.put(PropertyDescriptorField.MIN, this.lowerLimit.toString());
        attributes.put(PropertyDescriptorField.MAX, this.upperLimit.toString());
    }

    private static String rangeString(Number low, Number up) {
        return "(" + low + " -> " + up + ")";
    }
}

