/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.regex.Pattern;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.StringUtil;

public class ParametricRuleViolation<T extends Node>
implements RuleViolation {
    protected final Rule rule;
    protected final String description;
    protected boolean suppressed;
    protected String filename;
    protected int beginLine;
    protected int beginColumn;
    protected int endLine;
    protected int endColumn;
    protected String packageName = "";
    protected String className = "";
    protected String methodName = "";
    protected String variableName = "";

    public ParametricRuleViolation(Rule theRule, RuleContext ctx, T node, String message) {
        this.rule = theRule;
        this.description = message;
        this.filename = ctx.getSourceCodeFilename();
        if (this.filename == null) {
            this.filename = "";
        }
        if (node != null) {
            this.beginLine = node.getBeginLine();
            this.beginColumn = node.getBeginColumn();
            this.endLine = node.getEndLine();
            this.endColumn = node.getEndColumn();
        }
        if (node != null && this.rule != null) {
            this.setSuppression(this.rule, node);
        }
    }

    private void setSuppression(Rule rule, T node) {
        String xpath;
        String regex = rule.getProperty(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
        if (regex != null && this.description != null && Pattern.matches(regex, this.description)) {
            this.suppressed = true;
        }
        if (!this.suppressed && (xpath = rule.getProperty(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR)) != null) {
            this.suppressed = node.hasDescendantMatchingXPath(xpath);
        }
    }

    protected String expandVariables(String message) {
        if (message.indexOf("${") < 0) {
            return message;
        }
        StringBuilder buf = new StringBuilder(message);
        int startIndex = -1;
        while ((startIndex = buf.indexOf("${", startIndex + 1)) >= 0) {
            String name;
            int endIndex = buf.indexOf("}", startIndex);
            if (endIndex < 0 || !this.isVariable(name = buf.substring(startIndex + 2, endIndex))) continue;
            buf.replace(startIndex, endIndex + 1, this.getVariableValue(name));
        }
        return buf.toString();
    }

    protected boolean isVariable(String name) {
        return StringUtil.isAnyOf(name, "variableName", "methodName", "className", "packageName") || this.rule.getPropertyDescriptor(name) != null;
    }

    protected String getVariableValue(String name) {
        if ("variableName".equals(name)) {
            return this.variableName;
        }
        if ("methodName".equals(name)) {
            return this.methodName;
        }
        if ("className".equals(name)) {
            return this.className;
        }
        if ("packageName".equals(name)) {
            return this.packageName;
        }
        PropertyDescriptor<?> propertyDescriptor = this.rule.getPropertyDescriptor(name);
        return String.valueOf(this.rule.getProperty(propertyDescriptor));
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public String getDescription() {
        return this.expandVariables(this.description);
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }

    public void setLines(int theBeginLine, int theEndLine) {
        this.beginLine = theBeginLine;
        this.endLine = theEndLine;
    }

    public String toString() {
        return this.getFilename() + ':' + this.getRule() + ':' + this.getDescription() + ':' + this.beginLine;
    }
}

