/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.VisitorStarter;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.xpath.Initializer;

public class SourceCodeProcessor {
    private final PMDConfiguration configuration;

    public SourceCodeProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void processSourceCode(InputStream sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try (InputStreamReader streamReader = new InputStreamReader(sourceCode, this.configuration.getSourceEncoding());){
            this.processSourceCode(streamReader, ruleSets, ctx);
        }
        catch (IOException e) {
            throw new PMDException("IO exception: " + e.getMessage(), e);
        }
    }

    public void processSourceCode(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        this.determineLanguage(ctx);
        Initializer.initialize();
        if (ruleSets.applies(ctx.getSourceCodeFile())) {
            if (this.configuration.getAnalysisCache().isUpToDate(ctx.getSourceCodeFile())) {
                for (RuleViolation rv : this.configuration.getAnalysisCache().getCachedViolations(ctx.getSourceCodeFile())) {
                    ctx.getReport().addRuleViolation(rv);
                }
                return;
            }
            try {
                ruleSets.start(ctx);
                this.processSource(sourceCode, ruleSets, ctx);
            }
            catch (ParseException pe) {
                this.configuration.getAnalysisCache().analysisFailed(ctx.getSourceCodeFile());
                throw new PMDException("Error while parsing " + ctx.getSourceCodeFilename(), pe);
            }
            catch (Exception e) {
                this.configuration.getAnalysisCache().analysisFailed(ctx.getSourceCodeFile());
                throw new PMDException("Error while processing " + ctx.getSourceCodeFilename(), e);
            }
            finally {
                ruleSets.end(ctx);
            }
        }
    }

    private Node parse(RuleContext ctx, Reader sourceCode, Parser parser) {
        long start = System.nanoTime();
        Node rootNode = parser.parse(ctx.getSourceCodeFilename(), sourceCode);
        ctx.getReport().suppress(parser.getSuppressMap());
        long end = System.nanoTime();
        Benchmarker.mark(Benchmark.Parser, end - start, 0L);
        return rootNode;
    }

    private void symbolFacade(Node rootNode, LanguageVersionHandler languageVersionHandler) {
        long start = System.nanoTime();
        languageVersionHandler.getSymbolFacade(this.configuration.getClassLoader()).start(rootNode);
        long end = System.nanoTime();
        Benchmarker.mark(Benchmark.SymbolTable, end - start, 0L);
    }

    private void usesDFA(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesDFA(language)) {
            long start = System.nanoTime();
            VisitorStarter dataFlowFacade = languageVersion.getLanguageVersionHandler().getDataFlowFacade();
            dataFlowFacade.start(rootNode);
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.DFA, end - start, 0L);
        }
    }

    private void usesTypeResolution(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesTypeResolution(language)) {
            long start = System.nanoTime();
            languageVersion.getLanguageVersionHandler().getTypeResolutionFacade(this.configuration.getClassLoader()).start(rootNode);
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.TypeResolution, end - start, 0L);
        }
    }

    private void usesMultifile(Node rootNode, LanguageVersionHandler languageVersionHandler, RuleSets ruleSets, Language language) {
        if (ruleSets.usesMultifile(language)) {
            long start = System.nanoTime();
            languageVersionHandler.getMultifileFacade().start(rootNode);
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.Multifile, end - start, 0L);
        }
    }

    private void processSource(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) {
        LanguageVersion languageVersion = ctx.getLanguageVersion();
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        Parser parser = PMD.parserFor(languageVersion, this.configuration);
        Node rootNode = this.parse(ctx, sourceCode, parser);
        this.symbolFacade(rootNode, languageVersionHandler);
        Language language = languageVersion.getLanguage();
        this.usesDFA(languageVersion, rootNode, ruleSets, language);
        this.usesTypeResolution(languageVersion, rootNode, ruleSets, language);
        this.usesMultifile(rootNode, languageVersionHandler, ruleSets, language);
        List<Node> acus = Collections.singletonList(rootNode);
        ruleSets.apply(acus, ctx, language);
    }

    private void determineLanguage(RuleContext ctx) {
        if (ctx.getLanguageVersion() == null) {
            LanguageVersion languageVersion = this.configuration.getLanguageVersionOfFile(ctx.getSourceCodeFilename());
            ctx.setLanguageVersion(languageVersion);
        }
    }
}

