/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleChain;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.ast.Node;

public class RuleSets {
    private List<RuleSet> ruleSets = new ArrayList<RuleSet>();
    private RuleChain ruleChain = new RuleChain();

    public RuleSets() {
    }

    public RuleSets(RuleSets ruleSets) {
        for (RuleSet rs : ruleSets.ruleSets) {
            this.addRuleSet(new RuleSet(rs));
        }
    }

    public RuleSets(RuleSet ruleSet) {
        this();
        this.addRuleSet(ruleSet);
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.ruleSets.add(ruleSet);
        this.ruleChain.add(ruleSet);
    }

    public RuleSet[] getAllRuleSets() {
        return this.ruleSets.toArray(new RuleSet[this.ruleSets.size()]);
    }

    public Iterator<RuleSet> getRuleSetsIterator() {
        return this.ruleSets.iterator();
    }

    public Set<Rule> getAllRules() {
        HashSet<Rule> result = new HashSet<Rule>();
        for (RuleSet r : this.ruleSets) {
            result.addAll(r.getRules());
        }
        return result;
    }

    public boolean applies(File file) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!ruleSet.applies(file)) continue;
            return true;
        }
        return false;
    }

    public void start(RuleContext ctx) {
        for (RuleSet ruleSet : this.ruleSets) {
            ruleSet.start(ctx);
        }
    }

    public void apply(List<Node> acuList, RuleContext ctx, Language language) {
        this.ruleChain.apply(acuList, ctx, language);
        for (RuleSet ruleSet : this.ruleSets) {
            if (!ruleSet.applies(ctx.getSourceCodeFile())) continue;
            ruleSet.apply(acuList, ctx);
        }
    }

    public void end(RuleContext ctx) {
        for (RuleSet ruleSet : this.ruleSets) {
            ruleSet.end(ctx);
        }
    }

    public boolean usesDFA(Language language) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!ruleSet.usesDFA(language)) continue;
            return true;
        }
        return false;
    }

    public Rule getRuleByName(String ruleName) {
        Rule rule = null;
        Iterator<RuleSet> i = this.ruleSets.iterator();
        while (i.hasNext() && rule == null) {
            RuleSet ruleSet = i.next();
            rule = ruleSet.getRuleByName(ruleName);
        }
        return rule;
    }

    public int ruleCount() {
        int count = 0;
        for (RuleSet r : this.ruleSets) {
            count += r.getRules().size();
        }
        return count;
    }

    public boolean usesTypeResolution(Language language) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!ruleSet.usesTypeResolution(language)) continue;
            return true;
        }
        return false;
    }

    public boolean usesMultifile(Language language) {
        for (RuleSet ruleSet : this.ruleSets) {
            if (!ruleSet.usesMultifile(language)) continue;
            return true;
        }
        return false;
    }

    public void removeDysfunctionalRules(Collection<Rule> collector) {
        for (RuleSet ruleSet : this.ruleSets) {
            ruleSet.removeDysfunctionalRules(collector);
        }
    }

    public long getChecksum() {
        long checksum = 1L;
        for (RuleSet ruleSet : this.ruleSets) {
            checksum = checksum * 31L + ruleSet.getChecksum();
        }
        return checksum;
    }
}

