/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.properties.BooleanMultiProperty;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.CharacterMultiProperty;
import net.sourceforge.pmd.properties.CharacterProperty;
import net.sourceforge.pmd.properties.DoubleMultiProperty;
import net.sourceforge.pmd.properties.DoubleProperty;
import net.sourceforge.pmd.properties.FloatMultiProperty;
import net.sourceforge.pmd.properties.FloatProperty;
import net.sourceforge.pmd.properties.IntegerMultiProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.LongMultiProperty;
import net.sourceforge.pmd.properties.LongProperty;
import net.sourceforge.pmd.properties.StringMultiProperty;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.properties.TypeMultiProperty;
import net.sourceforge.pmd.properties.TypeProperty;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorExternalBuilder;

public enum PropertyTypeId {
    BOOLEAN("Boolean", BooleanProperty.extractor(), ValueParserConstants.BOOLEAN_PARSER),
    BOOLEAN_LIST("List[Boolean]", BooleanMultiProperty.extractor(), ValueParserConstants.BOOLEAN_PARSER),
    STRING("String", StringProperty.extractor(), ValueParserConstants.STRING_PARSER),
    STRING_LIST("List[String]", StringMultiProperty.extractor(), ValueParserConstants.STRING_PARSER),
    CHARACTER("Character", CharacterProperty.extractor(), ValueParserConstants.CHARACTER_PARSER),
    CHARACTER_LIST("List[Character]", CharacterMultiProperty.extractor(), ValueParserConstants.CHARACTER_PARSER),
    INTEGER("Integer", IntegerProperty.extractor(), ValueParserConstants.INTEGER_PARSER),
    INTEGER_LIST("List[Integer]", IntegerMultiProperty.extractor(), ValueParserConstants.INTEGER_PARSER),
    LONG("Long", LongProperty.extractor(), ValueParserConstants.LONG_PARSER),
    LONG_LIST("List[Long]", LongMultiProperty.extractor(), ValueParserConstants.LONG_PARSER),
    FLOAT("Float", FloatProperty.extractor(), ValueParserConstants.FLOAT_PARSER),
    FLOAT_LIST("List[Float]", FloatMultiProperty.extractor(), ValueParserConstants.FLOAT_PARSER),
    DOUBLE("Double", DoubleProperty.extractor(), ValueParserConstants.DOUBLE_PARSER),
    DOUBLE_LIST("List[Double]", DoubleMultiProperty.extractor(), ValueParserConstants.DOUBLE_PARSER),
    CLASS("Class", TypeProperty.extractor(), ValueParserConstants.CLASS_PARSER),
    CLASS_LIST("List[Class]", TypeMultiProperty.extractor(), ValueParserConstants.CLASS_PARSER);

    private static final Map<String, PropertyTypeId> CONSTANTS_BY_MNEMONIC;
    private final String stringId;
    private final PropertyDescriptorExternalBuilder<?> factory;
    private final ValueParser<?> valueParser;

    private PropertyTypeId(String id, PropertyDescriptorExternalBuilder<?> factory, ValueParser<?> valueParser) {
        this.stringId = id;
        this.factory = factory;
        this.valueParser = valueParser;
    }

    public String getStringId() {
        return this.stringId;
    }

    public PropertyDescriptorExternalBuilder<?> getFactory() {
        return this.factory;
    }

    public boolean isPropertyNumeric() {
        return this.factory instanceof PropertyDescriptorBuilderConversionWrapper.SingleValue.Numeric || this.factory instanceof PropertyDescriptorBuilderConversionWrapper.MultiValue.Numeric;
    }

    public boolean isPropertyPackaged() {
        return this.factory instanceof PropertyDescriptorBuilderConversionWrapper.SingleValue.Packaged || this.factory instanceof PropertyDescriptorBuilderConversionWrapper.MultiValue.Packaged;
    }

    public boolean isPropertyMultivalue() {
        return this.factory.isMultiValue();
    }

    public Class<?> propertyValueType() {
        return this.factory.valueType();
    }

    public ValueParser<?> getValueParser() {
        return this.valueParser;
    }

    public static Map<String, PropertyTypeId> typeIdsToConstants() {
        return CONSTANTS_BY_MNEMONIC;
    }

    public static PropertyDescriptorExternalBuilder<?> factoryFor(String stringId) {
        PropertyTypeId cons = CONSTANTS_BY_MNEMONIC.get(stringId);
        return cons == null ? null : cons.factory;
    }

    public static PropertyTypeId lookupMnemonic(String stringId) {
        return CONSTANTS_BY_MNEMONIC.get(stringId);
    }

    public static String typeIdFor(Class<?> valueType, boolean multiValue) {
        for (Map.Entry<String, PropertyTypeId> entry : CONSTANTS_BY_MNEMONIC.entrySet()) {
            if (entry.getValue().propertyValueType() != valueType || entry.getValue().isPropertyMultivalue() != multiValue) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        HashMap<String, PropertyTypeId> temp = new HashMap<String, PropertyTypeId>();
        for (PropertyTypeId id : PropertyTypeId.values()) {
            temp.put(id.stringId, id);
        }
        CONSTANTS_BY_MNEMONIC = Collections.unmodifiableMap(temp);
    }
}

