/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.lang.reflect.Method;
import java.util.Collections;
import net.sourceforge.pmd.properties.AbstractPackagedProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import net.sourceforge.pmd.properties.builders.SinglePackagedPropertyBuilder;
import net.sourceforge.pmd.properties.modules.MethodPropertyModule;

public final class MethodProperty
extends AbstractPackagedProperty<Method> {
    public MethodProperty(String theName, String theDescription, Method theDefault, String[] legalPackageNames, float theUIOrder) {
        this(theName, theDescription, theDefault, legalPackageNames, theUIOrder, false);
    }

    private MethodProperty(String theName, String theDescription, Method theDefault, String[] legalPackageNames, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, theDefault, theUIOrder, isDefinedExternally, new MethodPropertyModule(legalPackageNames, Collections.singletonList(theDefault)));
    }

    public MethodProperty(String theName, String theDescription, String defaultMethodStr, String[] legalPackageNames, float theUIOrder) {
        this(theName, theDescription, ValueParserConstants.METHOD_PARSER.valueOf(defaultMethodStr), legalPackageNames, theUIOrder, false);
    }

    @Override
    protected String asString(Method value) {
        return MethodPropertyModule.asString(value);
    }

    @Override
    public Class<Method> type() {
        return Method.class;
    }

    @Override
    public Method createFrom(String valueString) throws IllegalArgumentException {
        return ValueParserConstants.METHOD_PARSER.valueOf(valueString);
    }

    static PropertyDescriptorBuilderConversionWrapper.SingleValue.Packaged<Method, MethodPBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.SingleValue.Packaged<Method, MethodPBuilder>(Method.class, ValueParserConstants.METHOD_PARSER){

            @Override
            protected MethodPBuilder newBuilder(String name) {
                return new MethodPBuilder(name);
            }
        };
    }

    public static MethodPBuilder named(String name) {
        return new MethodPBuilder(name);
    }

    public static final class MethodPBuilder
    extends SinglePackagedPropertyBuilder<Method, MethodPBuilder> {
        private MethodPBuilder(String name) {
            super(name);
        }

        public MethodProperty build() {
            return new MethodProperty(this.name, this.description, (Method)this.defaultValue, this.legalPackageNames, this.uiOrder, this.isDefinedInXML);
        }
    }
}

