/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.AbstractNumericProperty;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.builders.PropertyDescriptorBuilderConversionWrapper;
import net.sourceforge.pmd.properties.builders.SingleNumericPropertyBuilder;

public final class IntegerProperty
extends AbstractNumericProperty<Integer> {
    public IntegerProperty(String theName, String theDescription, Integer min, Integer max, Integer theDefault, float theUIOrder) {
        this(theName, theDescription, min, max, theDefault, theUIOrder, false);
    }

    private IntegerProperty(String theName, String theDescription, Integer min, Integer max, Integer theDefault, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, min, max, theDefault, theUIOrder, isDefinedExternally);
    }

    @Override
    public Class<Integer> type() {
        return Integer.class;
    }

    @Override
    protected Integer createFrom(String value) {
        return ValueParserConstants.INTEGER_PARSER.valueOf(value);
    }

    static PropertyDescriptorBuilderConversionWrapper.SingleValue.Numeric<Integer, IntegerPBuilder> extractor() {
        return new PropertyDescriptorBuilderConversionWrapper.SingleValue.Numeric<Integer, IntegerPBuilder>(Integer.class, ValueParserConstants.INTEGER_PARSER){

            @Override
            protected IntegerPBuilder newBuilder(String name) {
                return new IntegerPBuilder(name);
            }
        };
    }

    public static IntegerPBuilder named(String name) {
        return new IntegerPBuilder(name);
    }

    public static final class IntegerPBuilder
    extends SingleNumericPropertyBuilder<Integer, IntegerPBuilder> {
        private IntegerPBuilder(String name) {
            super(name);
        }

        public IntegerProperty build() {
            return new IntegerProperty(this.name, this.description, (Integer)this.lowerLimit, (Integer)this.upperLimit, (Integer)this.defaultValue, this.uiOrder, this.isDefinedInXML);
        }
    }
}

