/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.properties.AbstractMultiValueProperty;
import net.sourceforge.pmd.properties.EnumeratedPropertyDescriptor;
import net.sourceforge.pmd.properties.builders.MultiValuePropertyBuilder;
import net.sourceforge.pmd.properties.modules.EnumeratedPropertyModule;
import net.sourceforge.pmd.util.CollectionUtil;

public final class EnumeratedMultiProperty<E>
extends AbstractMultiValueProperty<E>
implements EnumeratedPropertyDescriptor<E, List<E>> {
    private final EnumeratedPropertyModule<E> module;

    @Deprecated
    public EnumeratedMultiProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int[] choiceIndices, Class<E> valueType, float theUIOrder) {
        this(theName, theDescription, CollectionUtil.mapFrom(theLabels, theChoices), EnumeratedMultiProperty.selection(choiceIndices, theChoices), valueType, theUIOrder, false);
    }

    @Deprecated
    public EnumeratedMultiProperty(String theName, String theDescription, String[] theLabels, E[] theChoices, int[] choiceIndices, float theUIOrder) {
        this(theName, theDescription, CollectionUtil.mapFrom(theLabels, theChoices), EnumeratedMultiProperty.selection(choiceIndices, theChoices), null, theUIOrder, false);
    }

    public EnumeratedMultiProperty(String theName, String theDescription, Map<String, E> choices, List<E> defaultValues, Class<E> valueType, float theUIOrder) {
        this(theName, theDescription, choices, defaultValues, valueType, theUIOrder, false);
    }

    private EnumeratedMultiProperty(String theName, String theDescription, Map<String, E> choices, List<E> defaultValues, Class<E> valueType, float theUIOrder, boolean isDefinedExternally) {
        super(theName, theDescription, defaultValues, theUIOrder, isDefinedExternally);
        this.module = new EnumeratedPropertyModule<E>(choices, valueType);
        this.checkDefaults(defaultValues);
    }

    @Override
    public Map<String, E> mappings() {
        return this.module.getChoicesByLabel();
    }

    @Override
    public Class<E> type() {
        return this.module.getValueType();
    }

    @Override
    public String errorFor(List<E> values) {
        for (E value : values) {
            String error = this.module.errorFor(value);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    @Override
    protected E createFrom(String toParse) {
        return this.module.choiceFrom(toParse);
    }

    @Override
    public String asString(E item) {
        return this.module.getLabelsByChoice().get(item);
    }

    private void checkDefaults(List<E> defaults) {
        for (E elt : defaults) {
            this.module.checkValue(elt);
        }
    }

    private static <E> List<E> selection(int[] choiceIndices, E[] theChoices) {
        ArrayList<E> selected = new ArrayList<E>();
        for (int i : choiceIndices) {
            if (i < 0 || i > theChoices.length) {
                throw new IllegalArgumentException("Default value index is out of bounds: " + i);
            }
            selected.add(theChoices[i]);
        }
        return selected;
    }

    public static <E> EnumMultiPBuilder<E> named(String name) {
        return new EnumMultiPBuilder(name);
    }

    public static final class EnumMultiPBuilder<E>
    extends MultiValuePropertyBuilder<E, EnumMultiPBuilder<E>> {
        private Class<E> valueType;
        private Map<String, E> mappings;

        private EnumMultiPBuilder(String name) {
            super(name);
        }

        public EnumMultiPBuilder<E> type(Class<E> type) {
            this.valueType = type;
            return this;
        }

        public EnumMultiPBuilder<E> mappings(Map<String, E> map) {
            this.mappings = map;
            return this;
        }

        @Override
        public EnumeratedMultiProperty<E> build() {
            return new EnumeratedMultiProperty(this.name, this.description, this.mappings, this.defaultValues, this.valueType, this.uiOrder, this.isDefinedInXML);
        }
    }
}

