/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptorField;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractProperty<T>
implements PropertyDescriptor<T> {
    private final String name;
    private final String description;
    private final float uiOrder;
    private final boolean isDefinedExternally;

    protected AbstractProperty(String theName, String theDescription, float theUIOrder, boolean isDefinedExternally) {
        if (theUIOrder < 0.0f) {
            throw new IllegalArgumentException("Property attribute 'UI order' cannot be null or blank");
        }
        this.name = AbstractProperty.checkNotEmpty(theName, PropertyDescriptorField.NAME);
        this.description = AbstractProperty.checkNotEmpty(theDescription, PropertyDescriptorField.DESCRIPTION);
        this.uiOrder = theUIOrder;
        this.isDefinedExternally = isDefinedExternally;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public float uiOrder() {
        return this.uiOrder;
    }

    @Override
    public final int compareTo(PropertyDescriptor<?> otherProperty) {
        float otherOrder = otherProperty.uiOrder();
        return (int)(otherOrder - this.uiOrder);
    }

    @Override
    public int preferredRowCount() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PropertyDescriptor) {
            return this.name.equals(((PropertyDescriptor)obj).name());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "[PropertyDescriptor: name=" + this.name() + ", type=" + (this.isMultiValue() ? "List<" + this.type() + ">" : this.type()) + ", value=" + this.defaultValue() + "]";
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final Map<PropertyDescriptorField, String> attributeValuesById() {
        HashMap<PropertyDescriptorField, String> values = new HashMap<PropertyDescriptorField, String>();
        this.addAttributesTo(values);
        return values;
    }

    protected void addAttributesTo(Map<PropertyDescriptorField, String> attributes) {
        attributes.put(PropertyDescriptorField.NAME, this.name);
        attributes.put(PropertyDescriptorField.DESCRIPTION, this.description);
        attributes.put(PropertyDescriptorField.DEFAULT_VALUE, this.defaultAsString());
    }

    protected abstract String defaultAsString();

    @Override
    public boolean isDefinedExternally() {
        return this.isDefinedExternally;
    }

    private static String checkNotEmpty(String arg, PropertyDescriptorField argId) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)arg)) {
            throw new IllegalArgumentException("Property attribute '" + (Object)((Object)argId) + "' cannot be null or blank");
        }
        return arg;
    }
}

