/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.processor;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.processor.PmdRunnable;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.datasource.DataSource;

public abstract class AbstractPMDProcessor {
    private static final Logger LOG = Logger.getLogger(AbstractPMDProcessor.class.getName());
    protected final PMDConfiguration configuration;

    public AbstractPMDProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void renderReports(List<Renderer> renderers, Report report) {
        long start = System.nanoTime();
        try {
            for (Renderer r : renderers) {
                r.renderFileReport(report);
            }
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.Reporting, end - start, 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String filenameFrom(DataSource dataSource) {
        return dataSource.getNiceFileName(this.configuration.isReportShortNames(), this.configuration.getInputPaths());
    }

    protected RuleSets createRuleSets(RuleSetFactory factory, Report report) {
        RuleSets rs = RulesetsFactoryUtils.getRuleSets(this.configuration.getRuleSets(), factory);
        Set<Rule> brokenRules = this.removeBrokenRules(rs);
        for (Rule rule : brokenRules) {
            report.addConfigError(new Report.ConfigurationError(rule, rule.dysfunctionReason()));
        }
        return rs;
    }

    private Set<Rule> removeBrokenRules(RuleSets ruleSets) {
        HashSet<Rule> brokenRules = new HashSet<Rule>();
        ruleSets.removeDysfunctionalRules(brokenRules);
        for (Rule rule : brokenRules) {
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.log(Level.WARNING, "Removed misconfigured rule: " + rule.getName() + "  cause: " + rule.dysfunctionReason());
        }
        return brokenRules;
    }

    public void processFiles(RuleSetFactory ruleSetFactory, List<DataSource> files, RuleContext ctx, List<Renderer> renderers) {
        RuleSets rs = this.createRuleSets(ruleSetFactory, ctx.getReport());
        this.configuration.getAnalysisCache().checkValidity(rs, this.configuration.getClassLoader());
        SourceCodeProcessor processor = new SourceCodeProcessor(this.configuration);
        for (DataSource dataSource : files) {
            String niceFileName = this.filenameFrom(dataSource);
            this.runAnalysis(new PmdRunnable(dataSource, niceFileName, renderers, ctx, rs, processor));
        }
        this.renderReports(renderers, ctx.getReport());
        this.collectReports(renderers);
    }

    protected abstract void runAnalysis(PmdRunnable var1);

    protected abstract void collectReports(List<Renderer> var1);
}

