/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sxpath.AbstractStaticContext;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.saxon.DocumentNode;
import net.sourceforge.pmd.lang.ast.xpath.saxon.ElementNode;
import net.sourceforge.pmd.lang.rule.xpath.AbstractXPathRuleQuery;
import net.sourceforge.pmd.lang.xpath.Initializer;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class SaxonXPathRuleQuery
extends AbstractXPathRuleQuery {
    private static final int MAX_CACHE_SIZE = 20;
    private static final Map<Node, DocumentNode> CACHE = new LinkedHashMap<Node, DocumentNode>(20){
        private static final long serialVersionUID = -7653916493967142443L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Node, DocumentNode> eldest) {
            return this.size() > 20;
        }
    };
    private XPathExpression xpathExpression;
    private List<XPathVariable> xpathVariables;

    @Override
    public boolean isSupportedVersion(String version) {
        return "1.0 compatibility".equals(version) || "2.0".equals(version);
    }

    @Override
    public List<Node> evaluate(Node node, RuleContext data) {
        this.initializeXPathExpression();
        ArrayList<Node> results = new ArrayList<Node>();
        try {
            DocumentNode documentNode = this.getDocumentNode(node);
            ElementNode rootElementNode = documentNode.nodeToElementNode.get(node);
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)rootElementNode);
            for (XPathVariable xpathVariable : this.xpathVariables) {
                String name = xpathVariable.getVariableQName().getLocalName();
                for (Map.Entry<PropertyDescriptor<?>, Object> entry : this.properties.entrySet()) {
                    if (!name.equals(entry.getKey().name())) continue;
                    ValueRepresentation valueRepresentation = this.getRepresentation(entry.getKey(), entry.getValue());
                    xpathDynamicContext.setVariable(xpathVariable, valueRepresentation);
                }
            }
            List nodes = this.xpathExpression.evaluate(xpathDynamicContext);
            for (ElementNode elementNode : nodes) {
                results.add((Node)elementNode.getUnderlyingNode());
            }
        }
        catch (XPathException e) {
            throw new RuntimeException(this.xpath + " had problem: " + e.getMessage(), e);
        }
        return results;
    }

    private ValueRepresentation getRepresentation(PropertyDescriptor<?> descriptor, Object value) {
        if (descriptor.isMultiValue()) {
            List val = (List)value;
            if (val.isEmpty()) {
                return EmptySequence.getInstance();
            }
            Item[] converted = new Item[val.size()];
            for (int i = 0; i < val.size(); ++i) {
                converted[i] = SaxonXPathRuleQuery.getAtomicRepresentation(val.get(i));
            }
            return new SequenceExtent(converted);
        }
        return SaxonXPathRuleQuery.getAtomicRepresentation(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNode getDocumentNode(Node node) {
        DocumentNode documentNode;
        Node root = node;
        while (root.jjtGetParent() != null) {
            root = root.jjtGetParent();
        }
        Map<Node, DocumentNode> map = CACHE;
        synchronized (map) {
            documentNode = CACHE.get(root);
            if (documentNode == null) {
                documentNode = new DocumentNode(root);
                CACHE.put(root, documentNode);
            }
        }
        return documentNode;
    }

    private void initializeXPathExpression() {
        if (this.xpathExpression != null) {
            return;
        }
        try {
            XPathEvaluator xpathEvaluator = new XPathEvaluator();
            XPathStaticContext xpathStaticContext = xpathEvaluator.getStaticContext();
            if ("1.0 compatibility".equals(this.version)) {
                ((AbstractStaticContext)xpathStaticContext).setBackwardsCompatibilityMode(true);
            }
            Initializer.initialize((IndependentContext)xpathStaticContext);
            this.xpathVariables = new ArrayList<XPathVariable>();
            for (PropertyDescriptor<?> propertyDescriptor : this.properties.keySet()) {
                String name = propertyDescriptor.name();
                if ("xpath".equals(name)) continue;
                XPathVariable xpathVariable = xpathStaticContext.declareVariable(null, name);
                this.xpathVariables.add(xpathVariable);
            }
            this.xpathExpression = xpathEvaluator.createExpression(this.xpath);
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    public static AtomicValue getAtomicRepresentation(Object value) {
        if (value == null) {
            return UntypedAtomicValue.ZERO_LENGTH_UNTYPED;
        }
        if (value instanceof String) {
            return new StringValue((CharSequence)((String)value));
        }
        if (value instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)value));
        }
        if (value instanceof Integer) {
            return Int64Value.makeIntegerValue((long)((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new BigIntegerValue(((Long)value).longValue());
        }
        if (value instanceof Double) {
            return new DoubleValue(((Double)value).doubleValue());
        }
        if (value instanceof Character) {
            return new StringValue((CharSequence)value.toString());
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        throw new RuntimeException("Unable to create ValueRepresentation for value of type: " + value.getClass());
    }
}

