/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.RuleChainVisitor;
import net.sourceforge.pmd.lang.rule.RuleReference;

public abstract class AbstractRuleChainVisitor
implements RuleChainVisitor {
    protected Map<RuleSet, List<Rule>> ruleSetRules = new LinkedHashMap<RuleSet, List<Rule>>();
    protected Map<String, List<Node>> nodeNameToNodes;

    @Override
    public void add(RuleSet ruleSet, Rule rule) {
        if (!this.ruleSetRules.containsKey(ruleSet)) {
            this.ruleSetRules.put(ruleSet, new ArrayList());
        }
        this.ruleSetRules.get(ruleSet).add(rule);
    }

    @Override
    public void visitAll(List<Node> nodes, RuleContext ctx) {
        this.initialize();
        this.clear();
        long start = System.nanoTime();
        this.indexNodes(nodes, ctx);
        long end = System.nanoTime();
        Benchmarker.mark(Benchmark.RuleChainVisit, end - start, 1L);
        for (Map.Entry<RuleSet, List<Rule>> entry : this.ruleSetRules.entrySet()) {
            RuleSet ruleSet = entry.getKey();
            if (!ruleSet.applies(ctx.getSourceCodeFile())) continue;
            start = System.nanoTime();
            for (Rule rule : entry.getValue()) {
                int visits = 0;
                if (!RuleSet.applies(rule, ctx.getLanguageVersion())) continue;
                List<String> nodeNames = rule.getRuleChainVisits();
                for (int j = 0; j < nodeNames.size(); ++j) {
                    List<Node> ns = this.nodeNameToNodes.get(nodeNames.get(j));
                    for (Node node : ns) {
                        Rule actualRule = rule;
                        while (actualRule instanceof RuleReference) {
                            actualRule = ((RuleReference)actualRule).getRule();
                        }
                        this.visit(actualRule, node, ctx);
                    }
                    visits += ns.size();
                }
                end = System.nanoTime();
                Benchmarker.mark(Benchmark.RuleChainRule, rule.getName(), end - start, visits);
                start = end;
            }
        }
    }

    protected abstract void visit(Rule var1, Node var2, RuleContext var3);

    protected abstract void indexNodes(List<Node> var1, RuleContext var2);

    protected void indexNode(Node node) {
        List<Node> nodes = this.nodeNameToNodes.get(node.toString());
        if (nodes != null) {
            nodes.add(node);
        }
    }

    protected void initialize() {
        if (this.nodeNameToNodes != null) {
            return;
        }
        HashSet<String> visitedNodes = new HashSet<String>();
        Iterator<Map.Entry<RuleSet, List<Rule>>> entryIterator = this.ruleSetRules.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<RuleSet, List<Rule>> entry = entryIterator.next();
            Iterator<Rule> ruleIterator = entry.getValue().iterator();
            while (ruleIterator.hasNext()) {
                Rule rule = ruleIterator.next();
                if (rule.isRuleChain()) {
                    visitedNodes.addAll(rule.getRuleChainVisits());
                    continue;
                }
                ruleIterator.remove();
            }
            if (!entry.getValue().isEmpty()) continue;
            entryIterator.remove();
        }
        this.nodeNameToNodes = new HashMap<String, List<Node>>();
        for (String s : visitedNodes) {
            ArrayList nodes = new ArrayList(100);
            this.nodeNameToNodes.put(s, nodes);
        }
    }

    protected void clear() {
        for (List<Node> l : this.nodeNameToNodes.values()) {
            l.clear();
        }
    }
}

