/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.Map;
import java.util.WeakHashMap;
import net.sourceforge.pmd.lang.ast.QualifiableNode;
import net.sourceforge.pmd.lang.ast.QualifiedName;
import net.sourceforge.pmd.lang.metrics.BasicMetricMemoizer;
import net.sourceforge.pmd.lang.metrics.MetricMemoizer;
import net.sourceforge.pmd.lang.metrics.ProjectMemoizer;

public abstract class BasicProjectMemoizer<T extends QualifiableNode, O extends QualifiableNode>
implements ProjectMemoizer<T, O> {
    private Map<QualifiedName, MetricMemoizer<T>> classes = new WeakHashMap<QualifiedName, MetricMemoizer<T>>();
    private Map<QualifiedName, MetricMemoizer<O>> operations = new WeakHashMap<QualifiedName, MetricMemoizer<O>>();

    public void reset() {
        this.classes.clear();
        this.operations.clear();
    }

    @Override
    public MetricMemoizer<O> getOperationMemoizer(QualifiedName qname) {
        if (!this.operations.containsKey(qname)) {
            this.operations.put(qname, new BasicMetricMemoizer());
        }
        return this.operations.get(qname);
    }

    @Override
    public MetricMemoizer<T> getClassMemoizer(QualifiedName qname) {
        if (!this.classes.containsKey(qname)) {
            this.classes.put(qname, new BasicMetricMemoizer());
        }
        return this.classes.get(qname);
    }
}

