/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution;

import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static boolean isA(TypeNode n, String clazzName) {
        if (n.getType() != null) {
            try {
                Class<?> clazz;
                ClassLoader classLoader = n.getType().getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                if ((clazz = classLoader.loadClass(clazzName)) != null) {
                    return TypeHelper.isA(n, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazzName.equals(n.getImage()) || clazzName.endsWith("." + n.getImage());
    }

    public static boolean isA(TypeNode n, Class<?> clazz) {
        return TypeHelper.subclasses(n, clazz);
    }

    public static boolean isEither(TypeNode n, Class<?> class1, Class<?> class2) {
        return TypeHelper.subclasses(n, class1) || TypeHelper.subclasses(n, class2);
    }

    public static boolean isA(TypedNameDeclaration vnd, Class<?> clazz) {
        Class<?> type = vnd.getType();
        return type != null && type.equals(clazz) || type == null && (clazz.getSimpleName().equals(vnd.getTypeImage()) || clazz.getName().equals(vnd.getTypeImage()));
    }

    public static boolean isEither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return TypeHelper.isA(vnd, class1) || TypeHelper.isA(vnd, class2);
    }

    public static boolean isNeither(TypedNameDeclaration vnd, Class<?> class1, Class<?> class2) {
        return !TypeHelper.isA(vnd, class1) && !TypeHelper.isA(vnd, class2);
    }

    public static boolean subclasses(TypeNode n, Class<?> clazz) {
        Class<?> type = n.getType();
        if (type == null) {
            return clazz.getSimpleName().equals(n.getImage()) || clazz.getName().equals(n.getImage());
        }
        return clazz.isAssignableFrom(type);
    }
}

