/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class MethodNamingConventionsRule
extends AbstractJavaRule {
    private boolean checkNativeMethods;
    private static final BooleanProperty CHECK_NATIVE_METHODS_DESCRIPTOR = new BooleanProperty("checkNativeMethods", "Check native methods", true, 1.0f);

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.checkNativeMethods = (Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!this.checkNativeMethods && ((ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class)).isNative()) {
            return data;
        }
        if (this.isOverriddenMethod(node)) {
            return data;
        }
        String methodName = node.getImage();
        if (Character.isUpperCase(methodName.charAt(0))) {
            this.addViolationWithMessage(data, (Node)node, "Method names should not start with capital letters");
        }
        if (methodName.indexOf(95) >= 0) {
            this.addViolationWithMessage(data, (Node)node, "Method names should not contain underscores");
        }
        return data;
    }

    private boolean isOverriddenMethod(ASTMethodDeclarator node) {
        ASTClassOrInterfaceBodyDeclaration declaration = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        List annotations = declaration.findDescendantsOfType(ASTMarkerAnnotation.class);
        for (ASTMarkerAnnotation ann : annotations) {
            ASTName name = (ASTName)ann.getFirstChildOfType(ASTName.class);
            if (name == null || !name.hasImageEqualTo("Override")) continue;
            return true;
        }
        return false;
    }
}

