/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ConfusingTernaryRule
extends AbstractJavaRule {
    private static BooleanProperty ignoreElseIfProperty = new BooleanProperty("ignoreElseIf", "Ignore conditions with an else-if case", Boolean.FALSE.booleanValue(), 0.0f);

    public ConfusingTernaryRule() {
        this.definePropertyDescriptor((PropertyDescriptor)ignoreElseIfProperty);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        Node jnode;
        Node inode;
        if (node.jjtGetNumChildren() == 3 && (inode = node.jjtGetChild(0)) instanceof ASTExpression && inode.jjtGetNumChildren() == 1 && ConfusingTernaryRule.isMatch(jnode = inode.jjtGetChild(0)) && (!((Boolean)this.getProperty((PropertyDescriptor)ignoreElseIfProperty)).booleanValue() || !(node.jjtGetChild(2).jjtGetChild(0) instanceof ASTIfStatement) && !(node.jjtGetParent().jjtGetParent() instanceof ASTIfStatement))) {
            this.addViolation(data, (Node)node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        Node inode;
        if (node.jjtGetNumChildren() > 0 && ConfusingTernaryRule.isMatch(inode = node.jjtGetChild(0))) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    private static boolean isMatch(Node node) {
        return ConfusingTernaryRule.isUnaryNot(node) || ConfusingTernaryRule.isNotEquals(node) || ConfusingTernaryRule.isConditionalWithAllMatches(node) || ConfusingTernaryRule.isParenthesisAroundMatch(node);
    }

    private static boolean isUnaryNot(Node node) {
        return node instanceof ASTUnaryExpressionNotPlusMinus && "!".equals(node.getImage());
    }

    private static boolean isNotEquals(Node node) {
        return node instanceof ASTEqualityExpression && "!=".equals(node.getImage());
    }

    private static boolean isConditionalWithAllMatches(Node node) {
        if (!(node instanceof ASTConditionalAndExpression) && !(node instanceof ASTConditionalOrExpression)) {
            return false;
        }
        int n = node.jjtGetNumChildren();
        if (n <= 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Node inode = node.jjtGetChild(i);
            if (ConfusingTernaryRule.isMatch(inode)) continue;
            return false;
        }
        return true;
    }

    private static boolean isParenthesisAroundMatch(Node node) {
        if (!(node instanceof ASTPrimaryExpression) || node.jjtGetNumChildren() != 1) {
            return false;
        }
        Node inode = node.jjtGetChild(0);
        if (!(inode instanceof ASTPrimaryPrefix) || inode.jjtGetNumChildren() != 1) {
            return false;
        }
        Node jnode = inode.jjtGetChild(0);
        if (!(jnode instanceof ASTExpression) || jnode.jjtGetNumChildren() != 1) {
            return false;
        }
        Node knode = jnode.jjtGetChild(0);
        return ConfusingTernaryRule.isMatch(knode);
    }
}

