/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile.signature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaSignature;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public final class JavaOperationSignature
extends JavaSignature<ASTMethodOrConstructorDeclaration> {
    private static final Map<Integer, JavaOperationSignature> POOL = new HashMap<Integer, JavaOperationSignature>();
    public final Role role;
    public final boolean isAbstract;

    private JavaOperationSignature(JavaSignature.Visibility visibility, Role role, boolean isAbstract) {
        super(visibility);
        this.role = role;
        this.isAbstract = isAbstract;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return JavaOperationSignature.code(this.visibility, this.role, this.isAbstract);
    }

    public String toString() {
        return "JavaOperationSignature{role=" + (Object)((Object)this.role) + ", isAbstract=" + this.isAbstract + ", visibility=" + (Object)((Object)this.visibility) + '}';
    }

    private static int code(JavaSignature.Visibility visibility, Role role, boolean isAbstract) {
        return visibility.hashCode() * 31 + role.hashCode() * 2 + (isAbstract ? 1 : 0);
    }

    public static JavaOperationSignature buildFor(ASTMethodOrConstructorDeclaration node) {
        int code = JavaOperationSignature.code(JavaSignature.Visibility.get(node), Role.get(node), node.isAbstract());
        if (!POOL.containsKey(code)) {
            POOL.put(code, new JavaOperationSignature(JavaSignature.Visibility.get(node), Role.get(node), node.isAbstract()));
        }
        return POOL.get(code);
    }

    public static enum Role {
        GETTER_OR_SETTER,
        CONSTRUCTOR,
        METHOD,
        STATIC;

        private static final Pattern FIELD_NAME_PATTERN;

        public static Role get(ASTMethodOrConstructorDeclaration node) {
            return node instanceof ASTConstructorDeclaration ? CONSTRUCTOR : Role.get((ASTMethodDeclaration)node);
        }

        private static Role get(ASTMethodDeclaration node) {
            if (node.isStatic()) {
                return STATIC;
            }
            if (Role.isGetterOrSetter(node)) {
                return GETTER_OR_SETTER;
            }
            return METHOD;
        }

        private static boolean isGetterOrSetter(ASTMethodDeclaration node) {
            ClassScope scope = (ClassScope)node.getScope().getEnclosingScope(ClassScope.class);
            HashMap<String, String> fieldNames = new HashMap<String, String>();
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> decl : scope.getVariableDeclarations().entrySet()) {
                ASTFieldDeclaration field = (ASTFieldDeclaration)decl.getKey().getNode().getFirstParentOfType(ASTFieldDeclaration.class);
                Matcher matcher = FIELD_NAME_PATTERN.matcher(field.getVariableName());
                String varName = matcher.find() ? matcher.group(1) : field.getVariableName();
                fieldNames.put(varName, ((ASTType)field.getFirstChildOfType(ASTType.class)).getTypeImage());
            }
            return Role.isGetter(node, fieldNames) || Role.isSetter(node, fieldNames);
        }

        private static boolean isGetter(ASTMethodDeclaration node, Map<String, String> fieldNames) {
            if (((ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class)).getParameterCount() != 0 || ((ASTResultType)node.getFirstDescendantOfType(ASTResultType.class)).isVoid()) {
                return false;
            }
            if (node.getName().startsWith("get")) {
                return Role.containsIgnoreCase(fieldNames.keySet(), node.getName().substring(3));
            }
            if (node.getName().startsWith("is")) {
                return Role.containsIgnoreCase(fieldNames.keySet(), node.getName().substring(2));
            }
            return fieldNames.containsKey(node.getName());
        }

        private static boolean isSetter(ASTMethodDeclaration node, Map<String, String> fieldNames) {
            if (((ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class)).getParameterCount() != 1 || !((ASTResultType)node.getFirstDescendantOfType(ASTResultType.class)).isVoid()) {
                return false;
            }
            if (node.getName().startsWith("set")) {
                return Role.containsIgnoreCase(fieldNames.keySet(), node.getName().substring(3));
            }
            return fieldNames.containsKey(node.getName());
        }

        private static boolean containsIgnoreCase(Set<String> set, String str) {
            for (String s : set) {
                if (!str.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        static {
            FIELD_NAME_PATTERN = Pattern.compile("(?:m_|_)?(\\w+)");
        }
    }
}

