/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.multifile;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.JavaQualifiedName;
import net.sourceforge.pmd.lang.java.multifile.ClassMirror;
import net.sourceforge.pmd.lang.java.multifile.ClassStats;
import net.sourceforge.pmd.lang.java.multifile.ProjectMirror;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaFieldSigMask;
import net.sourceforge.pmd.lang.java.multifile.signature.JavaOperationSigMask;

final class PackageStats
implements ProjectMirror {
    static final PackageStats INSTANCE = new PackageStats();
    private final Map<String, PackageStats> subPackages = new HashMap<String, PackageStats>();
    private final Map<String, ClassStats> classes = new HashMap<String, ClassStats>();

    PackageStats() {
    }

    void reset() {
        this.subPackages.clear();
        this.classes.clear();
    }

    ClassStats getClassStats(JavaQualifiedName qname, boolean createIfNotFound) {
        ClassStats next;
        PackageStats container = this.getSubPackage(qname, createIfNotFound);
        if (container == null) {
            return null;
        }
        String topClassName = qname.getClasses()[0];
        if (createIfNotFound && container.classes.get(topClassName) == null) {
            container.classes.put(topClassName, new ClassStats());
        }
        if ((next = container.classes.get(topClassName)) == null) {
            return null;
        }
        String[] nameClasses = qname.getClasses();
        for (int i = 1; i < nameClasses.length && next != null; next = next.getNestedClassStats(nameClasses[i], createIfNotFound), ++i) {
        }
        return next;
    }

    private PackageStats getSubPackage(JavaQualifiedName qname, boolean createIfNotFound) {
        if (qname.getPackages() == null) {
            return this;
        }
        String[] packagePath = qname.getPackages();
        PackageStats next = this;
        for (int i = 0; i < packagePath.length && next != null; ++i) {
            if (createIfNotFound && next.subPackages.get(packagePath[i]) == null) {
                next.subPackages.put(packagePath[i], new PackageStats());
            }
            next = next.subPackages.get(packagePath[i]);
        }
        return next;
    }

    @Override
    public boolean hasMatchingSig(JavaQualifiedName qname, JavaOperationSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname, false);
        return clazz != null && clazz.hasMatchingOpSig(qname.getOperation(), sigMask);
    }

    @Override
    public boolean hasMatchingSig(JavaQualifiedName qname, String fieldName, JavaFieldSigMask sigMask) {
        ClassStats clazz = this.getClassStats(qname, false);
        return clazz != null && clazz.hasMatchingFieldSig(fieldName, sigMask);
    }

    @Override
    public ClassMirror getClassMirror(JavaQualifiedName className) {
        return this.getClassStats(className, false);
    }
}

