/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaClassMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.TccMethodPairVisitor;
import net.sourceforge.pmd.lang.metrics.MetricOptions;

public class TccMetric
extends AbstractJavaClassMetric {
    public double computeFor(ASTAnyTypeDeclaration node, MetricOptions options) {
        Map usagesByMethod = (Map)node.jjtAccept(new TccMethodPairVisitor(), null);
        int numPairs = this.numMethodsRelatedByAttributeAccess(usagesByMethod);
        int maxPairs = this.maxMethodPairs(usagesByMethod.size());
        return (double)numPairs / (double)maxPairs;
    }

    private int numMethodsRelatedByAttributeAccess(Map<String, Set<String>> usagesByMethod) {
        ArrayList<String> methods = new ArrayList<String>(usagesByMethod.keySet());
        int methodCount = methods.size();
        int pairs = 0;
        if (methodCount > 1) {
            for (int i = 0; i < methodCount - 1; ++i) {
                for (int j = i + 1; j < methodCount; ++j) {
                    String firstMethodName = (String)methods.get(i);
                    String secondMethodName = (String)methods.get(j);
                    if (Collections.disjoint((Collection)usagesByMethod.get(firstMethodName), (Collection)usagesByMethod.get(secondMethodName))) continue;
                    ++pairs;
                }
            }
        }
        return pairs;
    }

    private int maxMethodPairs(int methods) {
        return methods * (methods - 1) / 2;
    }
}

