/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class CommentUtil {
    private static final String CR = "\n";
    private static final Pattern JAVADOC_TAG = Pattern.compile("@[A-Za-z0-9]+");
    private static final Map<String, String> JAVADOC_CACHE = new HashMap<String, String>();

    private CommentUtil() {
    }

    public static String wordAfter(String text, int position) {
        int newposition;
        if (position >= text.length()) {
            return null;
        }
        int end = newposition = position + 1;
        char ch = text.charAt(end);
        while (Character.isLetterOrDigit(ch) && end < text.length()) {
            ch = text.charAt(++end);
        }
        return text.substring(newposition, end);
    }

    public static String javadocContentAfter(String text, int position) {
        int endPos = text.indexOf(10, position);
        if (endPos < 0) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)text.substring(position, endPos))) {
            return text.substring(position, endPos).trim();
        }
        if (text.indexOf(64, endPos) >= 0) {
            return null;
        }
        int nextEndPos = text.indexOf(10, endPos + 1);
        if (StringUtils.isNotBlank((CharSequence)text.substring(endPos, nextEndPos))) {
            return text.substring(endPos, nextEndPos).trim();
        }
        return null;
    }

    public static Map<String, Integer> javadocTagsIn(String comment) {
        Matcher m = JAVADOC_TAG.matcher(comment);
        HashMap<String, Integer> tags = null;
        while (m.find()) {
            String match;
            String tag;
            if (tags == null) {
                tags = new HashMap<String, Integer>();
            }
            if ((tag = JAVADOC_CACHE.get(match = comment.substring(m.start() + 1, m.end()))) == null) {
                JAVADOC_CACHE.put(match, match);
            }
            tags.put(tag, m.start());
        }
        if (tags == null) {
            return Collections.emptyMap();
        }
        return tags;
    }

    public static List<String> multiLinesIn(String comment) {
        String[] lines = comment.split(CR);
        ArrayList<String> filteredLines = new ArrayList<String>(lines.length);
        for (String rawLine : lines) {
            String line = rawLine.trim();
            if (line.startsWith("//")) {
                filteredLines.add(line.substring(2));
                continue;
            }
            if (line.endsWith("*/")) {
                int end = line.length() - 2;
                int start = line.startsWith("/**") ? 3 : (line.startsWith("/*") ? 2 : 0);
                filteredLines.add(line.substring(start, end));
                continue;
            }
            if (line.charAt(0) == '*') {
                filteredLines.add(line.substring(1));
                continue;
            }
            if (line.startsWith("/**")) {
                filteredLines.add(line.substring(3));
                continue;
            }
            if (line.startsWith("/*")) {
                filteredLines.add(line.substring(2));
                continue;
            }
            filteredLines.add(line);
        }
        return filteredLines;
    }

    public static List<String> trim(List<String> lines) {
        int lastNonEmpty;
        int firstNonEmpty;
        for (firstNonEmpty = 0; firstNonEmpty < lines.size() && !StringUtils.isNotBlank((CharSequence)lines.get(firstNonEmpty)); ++firstNonEmpty) {
        }
        if (firstNonEmpty == lines.size()) {
            return Collections.emptyList();
        }
        for (lastNonEmpty = lines.size() - 1; lastNonEmpty > 0 && !StringUtils.isNotBlank((CharSequence)lines.get(lastNonEmpty)); --lastNonEmpty) {
        }
        ArrayList<String> filtered = new ArrayList<String>();
        for (int i = firstNonEmpty; i < lastNonEmpty; ++i) {
            filtered.add(lines.get(i));
        }
        return filtered;
    }

    public static void main(String[] args) {
        Set<String> tags = CommentUtil.javadocTagsIn(args[0]).keySet();
        for (String tag : tags) {
            System.out.println(tag);
        }
    }
}

