/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaAccessNode;
import net.sourceforge.pmd.lang.java.ast.CanSuppressWarnings;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTFormalParameter
extends AbstractJavaAccessNode
implements Dimensionable,
CanSuppressWarnings {
    private boolean isVarargs;

    public ASTFormalParameter(int id) {
        super(id);
    }

    public ASTFormalParameter(JavaParser p, int id) {
        super(p, id);
    }

    public void setVarargs() {
        this.isVarargs = true;
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }

    public boolean isExplicitReceiverParameter() {
        return this.getDecl().isExplicitReceiverParameter();
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean hasSuppressWarningsAnnotationFor(Rule rule) {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTAnnotation a;
            if (!(this.jjtGetChild(i) instanceof ASTAnnotation) || !(a = (ASTAnnotation)this.jjtGetChild(i)).suppresses(rule)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isArray() {
        return this.checkType() + this.checkDecl() > 0;
    }

    @Override
    public int getArrayDepth() {
        if (!this.isArray()) {
            return 0;
        }
        return this.checkType() + this.checkDecl();
    }

    public ASTType getTypeNode() {
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (!(this.jjtGetChild(i) instanceof ASTType)) continue;
            return (ASTType)this.jjtGetChild(i);
        }
        throw new IllegalStateException("ASTType not found");
    }

    private int checkType() {
        return this.getTypeNode().getArrayDepth();
    }

    protected ASTVariableDeclaratorId getDecl() {
        try {
            return (ASTVariableDeclaratorId)this.jjtGetChild(this.jjtGetNumChildren() - 1);
        }
        catch (ClassCastException c) {
            System.out.println("CLASS CAST: " + this.getBeginLine() + ":" + this.getBeginColumn() + " " + this.toString());
            return null;
        }
    }

    private int checkDecl() {
        return this.getDecl().getArrayDepth();
    }
}

