/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.constraint;

import org.awaitility.Duration;
import org.awaitility.constraint.IntervalWaitConstraint;
import org.awaitility.constraint.WaitConstraint;

public class AtMostWaitConstraint
implements WaitConstraint {
    private final Duration atMostDuration;
    public static final AtMostWaitConstraint FOREVER = new AtMostWaitConstraint(Duration.FOREVER);
    public static final AtMostWaitConstraint TEN_SECONDS = new AtMostWaitConstraint(Duration.TEN_SECONDS);

    AtMostWaitConstraint(Duration atMostDuration) {
        this.atMostDuration = atMostDuration;
    }

    @Override
    public Duration getMaxWaitTime() {
        return this.atMostDuration;
    }

    @Override
    public Duration getMinWaitTime() {
        return Duration.ZERO;
    }

    @Override
    public WaitConstraint withMinWaitTime(Duration minWaitTime) {
        return new IntervalWaitConstraint(minWaitTime, this.atMostDuration);
    }

    @Override
    public WaitConstraint withMaxWaitTime(Duration maxWaitTime) {
        return new AtMostWaitConstraint(maxWaitTime);
    }
}

