/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ProgramPoint;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.ba.generic.GenericObjectType;
import edu.umd.cs.findbugs.ba.generic.GenericUtilities;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.UnreadFieldsData;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.Bag;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.Externalizable;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.bcel.Const;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class UnreadFields
extends OpcodeStackDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean("unreadfields.debug");
    boolean hasNativeMethods;
    boolean isSerializable;
    boolean sawSelfCallInConstructor;
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    boolean publicOrProtectedConstructor;
    private final Map<String, List<BugAnnotation>> anonymousClassAnnotation = new HashMap<String, List<BugAnnotation>>();
    static final int DO_NOT_CONSIDER = 5;
    final ClassDescriptor externalizable = DescriptorFactory.createClassDescriptor(Externalizable.class);
    final ClassDescriptor serializable = DescriptorFactory.createClassDescriptor(Serializable.class);
    final ClassDescriptor remote = DescriptorFactory.createClassDescriptor(Remote.class);
    int count_aload_1;
    private int previousOpcode;
    private int previousPreviousOpcode;
    boolean seenInvokeStatic;
    boolean seenMonitorEnter;
    XField pendingGetField;
    UnreadFieldsData data = new UnreadFieldsData();
    int saState;
    static Pattern dontComplainAbout = Pattern.compile("class[$]");
    static Pattern withinAnonymousClass = Pattern.compile("[$][0-9].*[$]");

    @Deprecated
    public boolean isContainerField(XField f) {
        return this.data.isContainerField(f);
    }

    @Deprecated
    public Set<? extends XField> getReadFields() {
        return this.data.getReadFields();
    }

    @Deprecated
    public Set<? extends XField> getWrittenFields() {
        return this.data.getWrittenFields();
    }

    @Deprecated
    public boolean isWrittenOutsideOfInitialization(XField f) {
        return this.data.isWrittenOutsideOfInitialization(f);
    }

    @Deprecated
    public boolean isWrittenDuringInitialization(XField f) {
        return this.data.isWrittenDuringInitialization(f);
    }

    @Deprecated
    public boolean isWrittenInConstructor(XField f) {
        return this.data.isWrittenInConstructor(f);
    }

    public UnreadFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
        AnalysisContext context = AnalysisContext.currentAnalysisContext();
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "in", "Ljava/io/InputStream;", true));
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "out", "Ljava/io/PrintStream;", true));
        this.data.reflectiveFields.add(XFactory.createXField("java.lang.System", "err", "Ljava/io/PrintStream;", true));
        this.data = context.getUnreadFieldsData();
        context.setUnreadFields(this);
    }

    @Deprecated
    public void strongEvidenceForIntendedSerialization(ClassDescriptor c) {
        this.data.strongEvidenceForIntendedSerialization(c);
    }

    @Deprecated
    public boolean existsStrongEvidenceForIntendedSerialization(ClassDescriptor c) {
        return this.data.existsStrongEvidenceForIntendedSerialization(c);
    }

    @Override
    public void visit(JavaClass obj) {
        String[] interface_names;
        this.data.calledFromConstructors.clear();
        this.hasNativeMethods = false;
        this.sawSelfCallInConstructor = false;
        this.publicOrProtectedConstructor = false;
        this.isSerializable = false;
        if (obj.isAbstract()) {
            this.data.abstractClasses.add(this.getDottedClassName());
        } else {
            String superClass = obj.getSuperclassName();
            if (superClass != null) {
                this.data.hasNonAbstractSubClass.add(superClass);
            }
        }
        this.data.classesScanned.add(this.getDottedClassName());
        boolean superClassIsObject = "java.lang.Object".equals(obj.getSuperclassName());
        if (this.getSuperclassName().indexOf(36) >= 0 || this.getSuperclassName().indexOf(43) >= 0 || withinAnonymousClass.matcher(this.getDottedClassName()).find()) {
            this.data.innerClassCannotBeStatic.add(this.getDottedClassName());
            this.data.innerClassCannotBeStatic.add(this.getDottedSuperclassName());
        }
        for (String interface_name : interface_names = obj.getInterfaceNames()) {
            if ("java.io.Externalizable".equals(interface_name)) {
                this.isSerializable = true;
                continue;
            }
            if (!"java.io.Serializable".equals(interface_name)) continue;
            this.isSerializable = true;
            break;
        }
        if (!(superClassIsObject && interface_names.length <= 0 || this.isSerializable)) {
            try {
                Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
                ClassDescriptor desc = DescriptorFactory.createClassDescriptor(obj);
                if (subtypes2.getSubtypes(this.serializable).contains(desc) || subtypes2.getSubtypes(this.externalizable).contains(desc) || subtypes2.getSubtypes(this.remote).contains(desc)) {
                    this.isSerializable = true;
                }
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
        super.visit(obj);
    }

    public static boolean classHasParameter(JavaClass obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Signature)) continue;
            String sig = ((Signature)a).getSignature();
            return sig.charAt(0) == '<';
        }
        return false;
    }

    @Override
    public void visitAfter(JavaClass obj) {
        if (this.hasNativeMethods) {
            this.data.fieldsOfSerializableOrNativeClassed.addAll(this.data.myFields);
            this.data.fieldsOfNativeClasses.addAll(this.data.myFields);
        }
        if (this.isSerializable) {
            this.data.fieldsOfSerializableOrNativeClassed.addAll(this.data.myFields);
        }
        if (this.sawSelfCallInConstructor) {
            this.data.myFields.removeAll(this.data.writtenInConstructorFields);
            this.data.writtenInInitializationFields.addAll(this.data.myFields);
        }
        this.data.myFields.clear();
        this.data.allMyFields.clear();
        this.data.calledFromConstructors.clear();
    }

    @Override
    public void visit(Field obj) {
        super.visit(obj);
        XField f = XFactory.createXField(this);
        this.data.allMyFields.add(f);
        String signature = obj.getSignature();
        if (!"serialVersionUID".equals(this.getFieldName())) {
            this.data.myFields.add(f);
            if ("_jspx_dependants".equals(obj.getName())) {
                this.data.containerFields.add(f);
            }
        }
        if (UnreadFields.isSeleniumWebElement(signature)) {
            this.data.containerFields.add(f);
        }
    }

    public static boolean isSeleniumWebElement(String signature) {
        return "Lorg/openqa/selenium/RenderedWebElement;".equals(signature) || "Lorg/openqa/selenium/WebElement;".equals(signature);
    }

    @Override
    public void visitAnnotation(String annotationClass, Map<String, ElementValue> map, boolean runtimeVisible) {
        if (!this.visitingField()) {
            return;
        }
        if (UnreadFields.isInjectionAttribute(annotationClass)) {
            this.data.containerFields.add(XFactory.createXField(this));
        }
        if (!annotationClass.startsWith("edu.umd.cs.findbugs") && !annotationClass.startsWith("javax.lang")) {
            this.data.unknownAnnotation.add(XFactory.createXField(this), annotationClass);
        }
    }

    public static boolean isInjectionAttribute(@DottedClassName String annotationClass) {
        if (annotationClass.startsWith("javax.annotation.") || annotationClass.startsWith("javax.ejb") || "org.apache.tapestry5.annotations.Persist".equals(annotationClass) || "org.jboss.seam.annotations.In".equals(annotationClass) || annotationClass.startsWith("javax.persistence") || annotationClass.endsWith("SpringBean") || "com.google.inject.Inject".equals(annotationClass) || annotationClass.startsWith("com.google.") && annotationClass.endsWith(".Bind") && annotationClass.hashCode() == -243168318 || annotationClass.startsWith("org.nuxeo.common.xmap.annotation") || annotationClass.startsWith("com.google.gwt.uibinder.client") || annotationClass.startsWith("org.springframework.beans.factory.annotation") || "javax.ws.rs.core.Context".equals(annotationClass)) {
            return true;
        }
        int lastDot = annotationClass.lastIndexOf(46);
        String lastPart = annotationClass.substring(lastDot + 1);
        return lastPart.startsWith("Inject");
    }

    @Override
    public void visit(ConstantValue obj) {
        XField f = XFactory.createXField(this);
        this.data.constantFields.add(f);
        this.data.writtenFields.add(f);
    }

    @Override
    public void visit(Code obj) {
        this.count_aload_1 = 0;
        this.previousOpcode = -1;
        this.previousPreviousOpcode = -1;
        this.data.nullTested.clear();
        this.seenInvokeStatic = false;
        this.seenMonitorEnter = this.getMethod().isSynchronized();
        this.data.staticFieldsReadInThisMethod.clear();
        super.visit(obj);
        if ("<init>".equals(this.getMethodName()) && this.count_aload_1 > 1 && (this.getClassName().indexOf(36) >= 0 || this.getClassName().indexOf(43) >= 0)) {
            this.data.needsOuterObjectInConstructor.add(this.getDottedClassName());
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("Checking " + this.getClassName() + "." + obj.getName());
        }
        if ("<init>".equals(this.getMethodName()) && (obj.isPublic() || obj.isProtected())) {
            this.publicOrProtectedConstructor = true;
        }
        this.pendingGetField = null;
        this.saState = 0;
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x100) != 0) {
            this.hasNativeMethods = true;
        }
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        boolean selfAssignment;
        block103: {
            XField f;
            OpcodeStack.Item item2;
            XMethod xMethod;
            block101: {
                XField f2;
                XField f3;
                String fieldClass;
                String fieldName;
                if (DEBUG) {
                    System.out.println(this.getPC() + ": " + Const.getOpcodeName((int)seen) + " " + this.saState);
                }
                if (seen == 194) {
                    this.seenMonitorEnter = true;
                }
                switch (this.saState) {
                    case 0: {
                        if (seen != 42) break;
                        this.saState = 1;
                        break;
                    }
                    case 1: {
                        if (seen == 42) {
                            this.saState = 2;
                            break;
                        }
                        this.saState = 0;
                        break;
                    }
                    case 2: {
                        if (seen == 180) {
                            this.saState = 3;
                            break;
                        }
                        this.saState = 0;
                        break;
                    }
                    case 3: {
                        if (seen == 181) {
                            this.saState = 4;
                            break;
                        }
                        this.saState = 0;
                        break;
                    }
                }
                selfAssignment = false;
                if (this.pendingGetField != null) {
                    if (seen != 181 && seen != 179) {
                        this.data.readFields.add(this.pendingGetField);
                    } else if (XFactory.createReferencedXField(this).equals(this.pendingGetField) && (this.saState == 4 || seen == 179)) {
                        selfAssignment = true;
                    } else {
                        this.data.readFields.add(this.pendingGetField);
                    }
                    this.pendingGetField = null;
                }
                if (this.saState == 4) {
                    this.saState = 0;
                }
                if (seen == 184 && "java/util/concurrent/atomic/AtomicReferenceFieldUpdater".equals(this.getClassConstantOperand()) && "newUpdater".equals(this.getNameConstantOperand())) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    String fieldSignature = (String)this.stack.getStackItem(1).getConstant();
                    String fieldClass2 = (String)this.stack.getStackItem(2).getConstant();
                    if (fieldName != null && fieldSignature != null && fieldClass2 != null) {
                        XField f4 = XFactory.createXField(fieldClass2.replace('/', '.'), fieldName, ClassName.toSignature(fieldSignature), false);
                        this.data.reflectiveFields.add(f4);
                    }
                }
                if (seen == 184 && "java/util/concurrent/atomic/AtomicIntegerFieldUpdater".equals(this.getClassConstantOperand()) && "newUpdater".equals(this.getNameConstantOperand())) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    fieldClass = (String)this.stack.getStackItem(1).getConstant();
                    if (fieldName != null && fieldClass != null) {
                        f3 = XFactory.createXField(fieldClass.replace('/', '.'), fieldName, "I", false);
                        this.data.reflectiveFields.add(f3);
                    }
                }
                if (seen == 184 && "java/util/concurrent/atomic/AtomicLongFieldUpdater".equals(this.getClassConstantOperand()) && "newUpdater".equals(this.getNameConstantOperand())) {
                    fieldName = (String)this.stack.getStackItem(0).getConstant();
                    fieldClass = (String)this.stack.getStackItem(1).getConstant();
                    if (fieldName != null && fieldClass != null) {
                        f3 = XFactory.createXField(fieldClass.replace('/', '.'), fieldName, "J", false);
                        this.data.reflectiveFields.add(f3);
                    }
                }
                if (seen == 178) {
                    f2 = XFactory.createReferencedXField(this);
                    this.data.staticFieldsReadInThisMethod.add(f2);
                } else if (seen == 184) {
                    this.seenInvokeStatic = true;
                } else if (seen == 179 && !this.getMethod().isStatic()) {
                    f2 = XFactory.createReferencedXField(this);
                    OpcodeStack.Item valuePut = this.getStack().getStackItem(0);
                    if (f2.getName().indexOf("class$") != 0) {
                        int priority;
                        block100: {
                            priority = 3;
                            if (f2.isReferenceType()) {
                                try {
                                    ValueNumberDataflow vnaDataflow = this.getClassContext().getValueNumberDataflow(this.getMethod());
                                    IsNullValueDataflow invDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                                    ValueNumberFrame vFrame = (ValueNumberFrame)((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getFactAtPC(vnaDataflow.getCFG(), this.getPC());
                                    IsNullValueFrame iFrame = (IsNullValueFrame)((IsNullValueAnalysis)invDataflow.getAnalysis()).getFactAtPC(invDataflow.getCFG(), this.getPC());
                                    AvailableLoad l = new AvailableLoad(f2);
                                    ValueNumber[] availableLoads = vFrame.getAvailableLoad(l);
                                    if (availableLoads == null || !iFrame.isTrackValueNumbers()) break block100;
                                    for (ValueNumber v : availableLoads) {
                                        IsNullValue knownValue = iFrame.getKnownValue(v);
                                        if (knownValue == null) continue;
                                        if (knownValue.isDefinitelyNotNull()) {
                                            priority = valuePut.isNull() ? ++priority : --priority;
                                            break;
                                        }
                                        if (!knownValue.isDefinitelyNull()) {
                                            continue;
                                        }
                                        break block101;
                                    }
                                }
                                catch (CheckedAnalysisException e) {
                                    AnalysisContext.logError("foo", e);
                                }
                            }
                        }
                        if (!this.publicOrProtectedConstructor) {
                            --priority;
                        }
                        if (this.seenMonitorEnter) {
                            ++priority;
                        }
                        if (!this.seenInvokeStatic && this.data.staticFieldsReadInThisMethod.isEmpty()) {
                            --priority;
                        }
                        if (this.getThisClass().isPublic() && this.getMethod().isPublic()) {
                            --priority;
                        }
                        if (this.getThisClass().isPrivate() || this.getMethod().isPrivate()) {
                            ++priority;
                        }
                        if (this.getClassName().indexOf(36) != -1 || BCELUtil.isSynthetic((FieldOrMethod)this.getMethod()) || f2.isSynthetic() || f2.getName().indexOf(36) >= 0) {
                            ++priority;
                        }
                        if (f2.getName().indexOf("DEBUG") >= 0 || f2.getName().indexOf("VERBOSE") >= 0 && "Z".equals(f2.getSignature())) {
                            ++priority;
                            ++priority;
                        }
                        if (("start".equals(this.getMethodName()) || "stop".equals(this.getMethodName())) && "(Lorg/osgi/framework/BundleContext;)V".equals(this.getMethodSig())) {
                            try {
                                FieldDescriptor fieldInfo;
                                String dottedClass;
                                JavaClass fieldClass3;
                                JavaClass bundleClass = Repository.lookupClass((String)"org.osgi.framework.BundleActivator");
                                if (this.getThisClass().instanceOf(bundleClass)) {
                                    ++priority;
                                }
                                if (f2.isReferenceType() && (fieldClass3 = Repository.lookupClass((String)(dottedClass = DeepSubtypeAnalysis.getComponentClass((fieldInfo = f2.getFieldDescriptor()).getSignature())))) != null && fieldClass3.instanceOf(bundleClass)) {
                                    priority = 5;
                                }
                            }
                            catch (ClassNotFoundException e) {
                                this.bugReporter.reportMissingClass(e);
                            }
                        }
                        this.bugAccumulator.accumulateBug(new BugInstance(this, "ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", priority).addClassAndMethod(this).addField(f2), this);
                    }
                }
            }
            if (seen == 183 && this.getMethodDescriptorOperand().getName().equals("<init>") && ClassName.isAnonymous(this.getClassConstantOperand())) {
                ArrayList<BugAnnotation> annotation = new ArrayList<BugAnnotation>();
                annotation.add(ClassAnnotation.fromClassDescriptor(this.getClassDescriptor()));
                annotation.add(MethodAnnotation.fromVisitedMethod(this));
                annotation.add(SourceLineAnnotation.fromVisitedInstruction(this));
                this.anonymousClassAnnotation.put(this.getClassDescriptorOperand().getDottedClassName(), annotation);
            }
            if ((seen == 181 || seen == 58 || seen == 75 || seen == 76 || seen == 77 || seen == 78) && (xMethod = (item2 = this.stack.getStackItem(0)).getReturnValueOf()) != null && xMethod.getName().equals("<init>") && ClassName.isAnonymous(xMethod.getClassName())) {
                List<BugAnnotation> annotations = this.anonymousClassAnnotation.get(xMethod.getClassName());
                if (annotations == null) {
                    annotations = new ArrayList<BugAnnotation>();
                }
                if (seen == 181) {
                    annotations.add(FieldAnnotation.fromReferencedField(this));
                } else {
                    annotations.add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.getRegisterOperand(), this.getPC(), this.getNextPC()));
                }
                this.anonymousClassAnnotation.put(xMethod.getClassName(), annotations);
            }
            if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
                String sig = this.getSigConstantOperand();
                String invokedClassName = this.getClassConstantOperand();
                if (invokedClassName.equals(this.getClassName()) && ("<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName()))) {
                    this.data.calledFromConstructors.add(this.getNameConstantOperand() + ":" + sig);
                }
                int pos = PreorderVisitor.getNumberArguments(sig);
                if (this.stack.getStackDepth() > pos) {
                    boolean selfCall;
                    boolean superCall;
                    OpcodeStack.Item item3 = this.stack.getStackItem(pos);
                    boolean bl = superCall = seen == 183 && !invokedClassName.equals(this.getClassName());
                    if (DEBUG) {
                        System.out.println("In " + this.getFullyQualifiedMethodName() + " saw call on " + item3);
                    }
                    boolean bl2 = selfCall = item3.getRegisterNumber() == 0 && !superCall;
                    if (selfCall && "<init>".equals(this.getMethodName())) {
                        this.sawSelfCallInConstructor = true;
                        if (DEBUG) {
                            System.out.println("Saw self call in " + this.getFullyQualifiedMethodName() + " to " + invokedClassName + "." + this.getNameConstantOperand());
                        }
                    }
                }
            }
            if ((seen == 198 || seen == 199) && this.stack.getStackDepth() > 0 && (f = (item2 = this.stack.getStackItem(0)).getXField()) != null) {
                this.data.nullTested.add(f);
                if (DEBUG) {
                    System.out.println(f + " null checked in " + this.getFullyQualifiedMethodName());
                }
            }
            if ((seen == 165 || seen == 166) && this.stack.getStackDepth() >= 2) {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                XField field1 = item1.getXField();
                if (item0.isNull() && field1 != null) {
                    this.data.nullTested.add(field1);
                } else {
                    XField field0 = item0.getXField();
                    if (item1.isNull() && field0 != null) {
                        this.data.nullTested.add(field0);
                    }
                }
            }
            if (seen == 180 || seen == 182 || seen == 185 || seen == 183 || seen == 181 || seen == 46 || seen == 50 || seen == 51 || seen == 52 || seen == 53 || seen == 79 || seen == 83 || seen == 84 || seen == 85 || seen == 86 || seen == 190) {
                XField f5;
                int pos = 0;
                switch (seen) {
                    case 180: 
                    case 190: {
                        pos = 0;
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 185: {
                        String sig = this.getSigConstantOperand();
                        pos = PreorderVisitor.getNumberArguments(sig);
                        break;
                    }
                    case 46: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 181: {
                        pos = 1;
                        break;
                    }
                    case 79: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        pos = 2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Impossible");
                    }
                }
                if (!(this.stack.getStackDepth() < pos || (f5 = (item = this.stack.getStackItem(pos)).getXField()) == null || f5.isStatic() || this.data.nullTested.contains(f5) || (this.data.writtenInConstructorFields.contains(f5) || this.data.writtenInInitializationFields.contains(f5)) && this.data.writtenNonNullFields.contains(f5))) {
                    block102: {
                        try {
                            IsNullValueDataflow invDataflow = this.getClassContext().getIsNullValueDataflow(this.getMethod());
                            IsNullValueFrame iFrame = (IsNullValueFrame)((IsNullValueAnalysis)invDataflow.getAnalysis()).getFactBeforeExceptionCheck(invDataflow.getCFG(), this.getPC());
                            if (iFrame.isValid() && !((IsNullValue)iFrame.getStackValue(pos)).isDefinitelyNotNull()) break block102;
                            break block103;
                        }
                        catch (CheckedAnalysisException e) {
                            AnalysisContext.logError("INV dataflow error when analyzing " + this.getMethodDescriptor(), e);
                        }
                    }
                    if (DEBUG) {
                        System.out.println("RRR: " + f5 + " " + this.data.nullTested.contains(f5) + " " + this.data.writtenInConstructorFields.contains(f5) + " " + this.data.writtenNonNullFields.contains(f5));
                    }
                    ProgramPoint p = new ProgramPoint(this);
                    Set<ProgramPoint> s = this.data.assumedNonNull.get(f5);
                    s = s == null ? Collections.singleton(p) : Util.addTo(s, p);
                    this.data.assumedNonNull.put(f5, s);
                    if (DEBUG) {
                        System.out.println(f5 + " assumed non-null in " + this.getFullyQualifiedMethodName());
                    }
                }
            }
        }
        if (seen == 43) {
            ++this.count_aload_1;
        } else if (seen == 180 || seen == 178) {
            XField f;
            this.pendingGetField = f = XFactory.createReferencedXField(this);
            if ("readResolve".equals(this.getMethodName()) && seen == 180) {
                this.data.writtenFields.add(f);
                this.data.writtenNonNullFields.add(f);
            }
            if (DEBUG) {
                System.out.println("get: " + f);
            }
            if (this.data.writtenFields.contains(f)) {
                this.data.fieldAccess.remove(f);
            } else if (!this.data.fieldAccess.containsKey(f)) {
                this.data.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction(this));
            }
        } else if (!(seen != 181 && seen != 179 || selfAssignment)) {
            boolean isConstructor;
            boolean writtingNonNull;
            XField f = XFactory.createReferencedXField(this);
            item = null;
            if (this.stack.getStackDepth() > 0 && !(item = this.stack.getStackItem(0)).isNull()) {
                this.data.nullTested.add(f);
            }
            this.data.writtenFields.add(f);
            boolean bl = writtingNonNull = this.previousOpcode != 1 || this.previousPreviousOpcode == 167;
            if (writtingNonNull) {
                this.data.writtenNonNullFields.add(f);
                if (DEBUG) {
                    System.out.println("put nn: " + f);
                }
            } else if (DEBUG) {
                System.out.println("put: " + f);
            }
            if (writtingNonNull && this.data.readFields.contains(f)) {
                this.data.fieldAccess.remove(f);
            } else if (!this.data.fieldAccess.containsKey(f)) {
                this.data.fieldAccess.put(f, SourceLineAnnotation.fromVisitedInstruction(this));
            }
            boolean bl3 = isConstructor = "<init>".equals(this.getMethodName()) || "<clinit>".equals(this.getMethodName());
            if (this.getMethod().isStatic() == f.isStatic() && (isConstructor || this.data.calledFromConstructors.contains(this.getMethodName() + ":" + this.getMethodSig()) || "init".equals(this.getMethodName()) || "initialize".equals(this.getMethodName()) || this.getMethod().isPrivate())) {
                if (isConstructor) {
                    this.data.writtenInConstructorFields.add(f);
                    if ("Ljava/lang/ThreadLocal;".equals(f.getSignature()) && item != null && item.isNewlyAllocated()) {
                        this.data.threadLocalAssignedInConstructor.put(f, new ProgramPoint(this));
                    }
                } else {
                    this.data.writtenInInitializationFields.add(f);
                }
                if (writtingNonNull) {
                    this.data.assumedNonNull.remove(f);
                }
            } else {
                this.data.writtenOutsideOfInitializationFields.add(f);
            }
        }
        this.previousPreviousOpcode = this.previousOpcode;
        this.previousOpcode = seen;
    }

    @Deprecated
    public boolean isReflexive(XField f) {
        return this.data.isReflexive(f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void report() {
        HashSet<String> fieldNamesSet = new HashSet<String>();
        for (XField f : this.data.writtenNonNullFields) {
            fieldNamesSet.add(f.getName());
        }
        if (DEBUG) {
            System.out.println("read fields:");
            for (XField f : this.data.readFields) {
                System.out.println("  " + f);
            }
            if (!this.data.containerFields.isEmpty()) {
                System.out.println("ejb3 fields:");
                for (XField f : this.data.containerFields) {
                    System.out.println("  " + f);
                }
            }
            if (!this.data.reflectiveFields.isEmpty()) {
                System.out.println("reflective fields:");
                for (XField f : this.data.reflectiveFields) {
                    System.out.println("  " + f);
                }
            }
            System.out.println("written fields:");
            for (XField f : this.data.writtenFields) {
                System.out.println("  " + f);
            }
            System.out.println("written nonnull fields:");
            for (XField f : this.data.writtenNonNullFields) {
                System.out.println("  " + f);
            }
            System.out.println("assumed nonnull fields:");
            for (XField f : this.data.assumedNonNull.keySet()) {
                System.out.println("  " + f);
            }
        }
        HashSet<XField> declaredFields = new HashSet<XField>();
        AnalysisContext currentAnalysisContext = AnalysisContext.currentAnalysisContext();
        XFactory xFactory = AnalysisContext.currentXFactory();
        for (XField f : AnalysisContext.currentXFactory().allFields()) {
            ClassDescriptor classDescriptor = f.getClassDescriptor();
            if (!currentAnalysisContext.isApplicationClass(classDescriptor) || currentAnalysisContext.isTooBig(classDescriptor) || xFactory.isReflectiveClass(classDescriptor)) continue;
            declaredFields.add(f);
        }
        HashSet<XField> unknownAnotationAndUnwritten = new HashSet<XField>(this.data.unknownAnnotation.keySet());
        unknownAnotationAndUnwritten.removeAll(this.data.writtenFields);
        declaredFields.removeAll(unknownAnotationAndUnwritten);
        declaredFields.removeAll(this.data.containerFields);
        declaredFields.removeAll(this.data.reflectiveFields);
        Iterator i = declaredFields.iterator();
        while (i.hasNext()) {
            XField f = (XField)i.next();
            if ((!f.isSynthetic() || f.getName().startsWith("this$")) && !f.getName().startsWith("_")) continue;
            i.remove();
        }
        TreeSet notInitializedInConstructors = new TreeSet(declaredFields);
        notInitializedInConstructors.retainAll(this.data.readFields);
        notInitializedInConstructors.retainAll(this.data.writtenNonNullFields);
        notInitializedInConstructors.retainAll(this.data.assumedNonNull.keySet());
        notInitializedInConstructors.removeAll(this.data.writtenInConstructorFields);
        notInitializedInConstructors.removeAll(this.data.writtenInInitializationFields);
        Iterator i2 = notInitializedInConstructors.iterator();
        while (i2.hasNext()) {
            if (!((XField)i2.next()).isStatic()) continue;
            i2.remove();
        }
        TreeSet readOnlyFields = new TreeSet(declaredFields);
        readOnlyFields.removeAll(this.data.writtenFields);
        readOnlyFields.retainAll(this.data.readFields);
        TreeSet nullOnlyFields = new TreeSet(declaredFields);
        nullOnlyFields.removeAll(this.data.writtenNonNullFields);
        nullOnlyFields.retainAll(this.data.readFields);
        HashSet<XField> writeOnlyFields = declaredFields;
        writeOnlyFields.removeAll(this.data.readFields);
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        Bag<String> nullOnlyFieldNames = new Bag<String>();
        Bag<ClassDescriptor> classContainingNullOnlyFields = new Bag<ClassDescriptor>();
        for (XField f : nullOnlyFields) {
            nullOnlyFieldNames.add(f.getName());
            classContainingNullOnlyFields.add(f.getClassDescriptor());
            int increment = 3;
            Collection assumedNonNullAt = this.data.assumedNonNull.get(f);
            if (assumedNonNullAt != null) {
                increment += assumedNonNullAt.size();
            }
            for (String string : this.data.unknownAnnotation.get(f)) {
                Integer value = (Integer)count.get(string);
                if (value == null) {
                    count.put(string, increment);
                    continue;
                }
                count.put(string, value + increment);
            }
        }
        HashMap<XField, Integer> maxCount = new HashMap<XField, Integer>();
        LinkedList<XField> assumeReflective = new LinkedList<XField>();
        for (XField f : nullOnlyFields) {
            int myMaxCount = 0;
            for (String s : this.data.unknownAnnotation.get(f)) {
                Integer value = (Integer)count.get(s);
                if (value == null || myMaxCount >= value) continue;
                myMaxCount = value;
            }
            if (myMaxCount > 0) {
                maxCount.put(f, myMaxCount);
            }
            if (myMaxCount > 15) {
                assumeReflective.add(f);
                continue;
            }
            if (nullOnlyFieldNames.getCount(f.getName()) > 8) {
                assumeReflective.add(f);
                continue;
            }
            if (classContainingNullOnlyFields.getCount(f.getClassDescriptor()) > 4) {
                assumeReflective.add(f);
                continue;
            }
            if (classContainingNullOnlyFields.getCount(f.getClassDescriptor()) <= 2 || f.getName().length() != 1) continue;
            assumeReflective.add(f);
        }
        readOnlyFields.removeAll(assumeReflective);
        nullOnlyFields.removeAll(assumeReflective);
        notInitializedInConstructors.removeAll(assumeReflective);
        Bag<String> notInitializedUses = new Bag<String>();
        for (XField f : notInitializedInConstructors) {
            String string = f.getClassName();
            Set<ProgramPoint> assumedNonnullAt = this.data.assumedNonNull.get(f);
            notInitializedUses.add(string, assumedNonnullAt.size());
        }
        for (XField f : notInitializedInConstructors) {
            String string = f.getClassName();
            if (notInitializedUses.getCount(string) >= 8) continue;
            String fieldSignature = f.getSignature();
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f) || fieldSignature.charAt(0) != 'L' && fieldSignature.charAt(0) != '[') continue;
            int priority = 3;
            Set<ProgramPoint> assumedNonnullAt = this.data.assumedNonNull.get(f);
            if (assumedNonnullAt.size() >= 4) continue;
            for (ProgramPoint p : assumedNonnullAt) {
                BugInstance bug = new BugInstance(this, "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR", priority).addClass(string).addField(f).addMethod(p.getMethodAnnotation());
                this.bugAccumulator.accumulateBug(bug, p.getSourceLineAnnotation());
            }
        }
        for (XField f : readOnlyFields) {
            String string = f.getSignature();
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f)) continue;
            int priority = 2;
            if (string.charAt(0) != 'L' && string.charAt(0) != '[') {
                ++priority;
            }
            if (maxCount.containsKey(f)) {
                ++priority;
            }
            String pattern = "UWF_UNWRITTEN_FIELD";
            if (f.isProtected() || f.isPublic()) {
                pattern = "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD";
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, pattern, priority), f));
        }
        for (XField f : nullOnlyFields) {
            if (DEBUG) {
                System.out.println("Null only: " + f);
                System.out.println("   : " + this.data.assumedNonNull.containsKey(f));
                System.out.println("   : " + this.data.fieldsOfSerializableOrNativeClassed.contains(f));
                System.out.println("   : " + fieldNamesSet.contains(f.getName()));
                System.out.println("   : " + this.data.abstractClasses.contains(f.getClassName()));
                System.out.println("   : " + this.data.hasNonAbstractSubClass.contains(f.getClassName()));
                System.out.println("   : " + f.isResolved());
            }
            if (!f.isResolved() || this.data.fieldsOfNativeClasses.contains(f)) continue;
            if (DEBUG) {
                System.out.println("Ready to report");
            }
            int n = 2;
            if (maxCount.containsKey(f)) {
                ++n;
            }
            if (this.data.abstractClasses.contains(f.getClassName())) {
                ++n;
                if (!this.data.hasNonAbstractSubClass.contains(f.getClassName())) {
                    ++n;
                }
            }
            if (this.data.assumedNonNull.containsKey(f)) {
                int npPriority = n--;
                Set<ProgramPoint> assumedNonNullAt = this.data.assumedNonNull.get(f);
                if (assumedNonNullAt.size() > 14) {
                    npPriority += 2;
                } else if (assumedNonNullAt.size() > 6) {
                    ++npPriority;
                }
                String pattern = f.isPublic() || f.isProtected() ? "NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD" : "NP_UNWRITTEN_FIELD";
                for (ProgramPoint p : assumedNonNullAt) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, pattern, npPriority).addClassAndMethod(p.method).addField(f), p.getSourceLineAnnotation());
                }
            } else {
                if (f.isStatic()) {
                    ++n;
                }
                if (f.isFinal()) {
                    ++n;
                }
                if (this.data.fieldsOfSerializableOrNativeClassed.contains(f)) {
                    ++n;
                }
            }
            if (readOnlyFields.contains(f)) continue;
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, "UWF_NULL_FIELD", n), f).lowerPriorityIfDeprecated());
        }
        block23: for (XField f : writeOnlyFields) {
            boolean isAnonymousInnerClass;
            String string = f.getName();
            String className2 = f.getClassName();
            int lastDollar = Math.max(className2.lastIndexOf(36), className2.lastIndexOf(43));
            boolean bl = isAnonymousInnerClass = lastDollar > 0 && lastDollar < className2.length() - 1 && Character.isDigit(className2.charAt(lastDollar + 1));
            if (DEBUG) {
                System.out.println("Checking write only field " + className2 + "." + string + "\t" + this.data.constantFields.contains(f) + "\t" + f.isStatic());
            }
            if (!f.isResolved() || dontComplainAbout.matcher(string).find()) continue;
            if (lastDollar >= 0 && (string.startsWith("this$") || string.startsWith("this+"))) {
                void var25_65;
                boolean easyChange;
                String outerClassName = className2.substring(0, lastDollar);
                try {
                    JavaClass outerClass;
                    XClass thisClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, f.getClassDescriptor());
                    if (isAnonymousInnerClass) {
                        for (XField xField : thisClass.getXFields()) {
                            if (xField == f || !xField.isPrivate() || !xField.isSynthetic() || xField.getName().startsWith("this$") || !xField.getName().contains("$")) continue;
                            continue block23;
                        }
                    }
                    if (UnreadFields.classHasParameter(outerClass = Repository.lookupClass((String)outerClassName))) continue;
                    ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(outerClassName);
                    XClass outerXClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, classDescriptor);
                    AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
                    Subtypes2 subtypes2 = analysisContext.getSubtypes2();
                    for (XField xField : outerXClass.getXFields()) {
                        Type ofType;
                        String sourceSignature;
                        if (xField.isStatic() || (sourceSignature = xField.getSourceSignature()) == null || !"Ljava/lang/ThreadLocal;".equals(xField.getSignature()) || !((ofType = GenericUtilities.getType(sourceSignature)) instanceof GenericObjectType)) continue;
                        GenericObjectType gType = (GenericObjectType)ofType;
                        for (ReferenceType referenceType : gType.getParameters()) {
                            if (!(referenceType instanceof ObjectType)) continue;
                            ClassDescriptor c = DescriptorFactory.getClassDescriptor((ObjectType)referenceType);
                            if (!subtypes2.isSubtype(f.getClassDescriptor(), c)) continue;
                            ProgramPoint p = this.data.threadLocalAssignedInConstructor.get(xField);
                            int priority = p == null ? 2 : 1;
                            BugInstance bug = new BugInstance(this, "SIC_THREADLOCAL_DEADLY_EMBRACE", priority).addClass(className2).addField(xField);
                            if (p != null) {
                                bug.addMethod(p.method).add(p.getSourceLineAnnotation());
                            }
                            this.bugReporter.reportBug(bug);
                        }
                    }
                    boolean outerClassIsInnerClass = false;
                    for (Field field : outerClass.getFields()) {
                        if (!"this$0".equals(field.getName())) continue;
                        outerClassIsInnerClass = true;
                    }
                    if (outerClassIsInnerClass) {
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
                catch (CheckedAnalysisException e) {
                    this.bugReporter.logError("Error getting outer XClass for " + outerClassName, e);
                }
                if (this.data.innerClassCannotBeStatic.contains(className2)) continue;
                boolean bl2 = easyChange = !this.data.needsOuterObjectInConstructor.contains(className2);
                if (!easyChange && isAnonymousInnerClass) continue;
                int priority = 3;
                if (easyChange && !isAnonymousInnerClass) {
                    priority = 2;
                }
                if (isAnonymousInnerClass) {
                    BugInstance bugInstance = new BugInstance(this, "SIC_INNER_SHOULD_BE_STATIC_ANON", priority);
                    List<BugAnnotation> annotations = this.anonymousClassAnnotation.remove(f.getClassDescriptor().getDottedClassName());
                    if (annotations != null) {
                        bugInstance.addClass(className2).describe("CLASS_ANONYMOUS");
                        bugInstance.addAnnotations(annotations);
                    } else {
                        bugInstance.addClass(className2);
                    }
                } else if (!easyChange) {
                    BugInstance bugInstance = new BugInstance(this, "SIC_INNER_SHOULD_BE_STATIC_NEEDS_THIS", priority).addClass(className2);
                } else {
                    BugInstance bugInstance = new BugInstance(this, "SIC_INNER_SHOULD_BE_STATIC", priority).addClass(className2);
                }
                this.bugReporter.reportBug((BugInstance)var25_65);
                continue;
            }
            if (!f.isResolved()) continue;
            if (this.data.constantFields.contains(f)) {
                if (f.isStatic()) continue;
                this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, "SS_SHOULD_BE_STATIC", 2), f));
                continue;
            }
            if (this.data.fieldsOfSerializableOrNativeClassed.contains(f)) continue;
            if (!this.data.writtenFields.contains(f)) {
                this.bugReporter.reportBug(new BugInstance(this, f.isPublic() || f.isProtected() ? "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD" : "UUF_UNUSED_FIELD", 2).addClass(className2).addField(f).lowerPriorityIfDeprecated());
                continue;
            }
            if (f.getName().toLowerCase().indexOf("guardian") >= 0) continue;
            int priority = 2;
            if (f.isStatic()) {
                ++priority;
            }
            if (f.isFinal()) {
                ++priority;
            }
            this.bugReporter.reportBug(this.addClassFieldAndAccess(new BugInstance(this, f.isPublic() || f.isProtected() ? "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD" : "URF_UNREAD_FIELD", priority), f));
        }
        this.bugAccumulator.reportAccumulatedBugs();
    }

    private BugInstance addClassFieldAndAccess(BugInstance instance, XField f) {
        if (this.data.writtenNonNullFields.contains(f) && this.data.readFields.contains(f)) {
            throw new IllegalArgumentException("No information for fields that are both read and written nonnull");
        }
        instance.addClass(f.getClassName()).addField(f);
        if (this.data.fieldAccess.containsKey(f)) {
            instance.add(this.data.fieldAccess.get(f));
        }
        return instance;
    }
}

