/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.Analysis;
import edu.umd.cs.findbugs.ba.jsr305.DirectlyRelevantTypeQualifiersDatabase;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

public class NoteDirectlyRelevantTypeQualifiers
extends DismantleBytecode
implements Detector,
NonReportingDetector {
    private DirectlyRelevantTypeQualifiersDatabase qualifiers;
    HashSet<TypeQualifierValue<?>> applicableApplications;

    public NoteDirectlyRelevantTypeQualifiers(BugReporter bugReporter) {
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass;
        if (this.qualifiers == null) {
            this.qualifiers = AnalysisContext.currentAnalysisContext().getDirectlyRelevantTypeQualifiersDatabase();
        }
        if (!BCELUtil.preTiger(javaClass = classContext.getJavaClass())) {
            javaClass.accept((Visitor)this);
        }
    }

    @Override
    public void visit(Code m) {
        this.applicableApplications = new HashSet();
        XMethod xMethod = this.getXMethod();
        this.updateApplicableAnnotations(xMethod);
        super.visit(m);
        if (this.applicableApplications.size() > 0) {
            this.qualifiers.setDirectlyRelevantTypeQualifiers(this.getMethodDescriptor(), new ArrayList(this.applicableApplications));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                XField f = this.getXFieldOperand();
                if (f == null) break;
                Collection<TypeQualifierAnnotation> annotations = TypeQualifierApplications.getApplicableApplications(f);
                Analysis.addKnownTypeQualifiers(this.applicableApplications, annotations);
                break;
            }
        }
    }

    private void updateApplicableAnnotations(XMethod m) {
        Collection<TypeQualifierAnnotation> annotations = TypeQualifierApplications.getApplicableApplications(m);
        Analysis.addKnownTypeQualifiers(this.applicableApplications, annotations);
        Analysis.addKnownTypeQualifiersForParameters(this.applicableApplications, m);
    }

    @Override
    public void report() {
    }
}

