/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginDescription;
import at.dallermassl.josm.plugin.pluginmanager.PluginHelper;
import at.dallermassl.josm.plugin.pluginmanager.SiteDescriptionParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteDescription {
    public static final String SITE_FILE_NAME = "josm-site.xml";
    private String name;
    private URL url;
    List<PluginDescription> plugins = new ArrayList<PluginDescription>();

    public SiteDescription() {
    }

    public SiteDescription(String url) throws MalformedURLException {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.url = new URL(url);
    }

    public SiteDescription(String name, String url) throws MalformedURLException {
        this(url);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromUrl() throws IOException {
        this.plugins.clear();
        URL xmlUrl = new URL(this.url, SITE_FILE_NAME);
        System.out.println("loading from url " + xmlUrl);
        URLConnection connection = xmlUrl.openConnection();
        InputStreamReader in = new InputStreamReader(connection.getInputStream());
        SiteDescriptionParser parser = new SiteDescriptionParser(this);
        try {
            parser.setVariableHelper(PluginHelper.getInstance().getVariableHelper());
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(in), (DefaultHandler)parser);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        finally {
            ((Reader)in).close();
        }
        PluginHelper helper = PluginHelper.getInstance();
        for (PluginDescription plugin : this.plugins) {
            PluginInformation info = helper.getPluginInfo(plugin.getId());
            if (info == null) continue;
            if (info.version == null) {
                plugin.setInstalledVersion("?");
                continue;
            }
            plugin.setInstalledVersion(info.version);
        }
    }

    public List<PluginDescription> getPlugins() {
        return this.plugins;
    }

    public void addPlugin(PluginDescription pluginDescription) {
        this.plugins.add(pluginDescription);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getLabelName() {
        if (this.name == null) {
            return this.url.toString();
        }
        return this.name;
    }

    public String toString() {
        return this.getLabelName();
    }

    public static void main(String[] args) {
        try {
            new SiteDescription("file:site/").loadFromUrl();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

