/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.plugins.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlippyMapChooserPlugin
extends Plugin
implements Preferences.PreferenceChangedListener {
    static String iPluginFolder = "";
    private static final String KEY_MAX_TILES_IN_MEMORY = "slippy_map_chooser.max_tiles";
    private static final String KEY_ENABLE_FILE_CACHE = "slippy_map_chooser.file_cache";
    static int MAX_TILES_IN_MEMORY = 200;
    static boolean ENABLE_FILE_CACHE = true;

    public SlippyMapChooserPlugin() {
        Main.pref.listener.add(this);
        String maxTiles = Main.pref.get(KEY_MAX_TILES_IN_MEMORY);
        if (!maxTiles.equals("")) {
            this.preferenceChanged(KEY_MAX_TILES_IN_MEMORY, maxTiles);
        } else {
            Main.pref.put(KEY_MAX_TILES_IN_MEMORY, Integer.toString(MAX_TILES_IN_MEMORY));
        }
        String enableFileCache = Main.pref.get(KEY_ENABLE_FILE_CACHE);
        if (!enableFileCache.equals("")) {
            this.preferenceChanged(KEY_ENABLE_FILE_CACHE, enableFileCache);
        } else {
            Main.pref.put(KEY_ENABLE_FILE_CACHE, Boolean.toString(ENABLE_FILE_CACHE));
        }
    }

    public void addDownloadSelection(List<DownloadSelection> list) {
        list.add(new SlippyMapChooser());
    }

    public void preferenceChanged(String key, String newValue) {
        if (KEY_MAX_TILES_IN_MEMORY.equals(key)) {
            try {
                MAX_TILES_IN_MEMORY = Integer.parseInt(newValue);
            }
            catch (Exception e) {
                MAX_TILES_IN_MEMORY = 1000;
            }
        } else if (KEY_ENABLE_FILE_CACHE.equals(key)) {
            try {
                ENABLE_FILE_CACHE = Boolean.parseBoolean(newValue);
            }
            catch (Exception e) {
                MAX_TILES_IN_MEMORY = 1000;
            }
        }
    }
}

