/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.api.NewAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.tools.I18n;

public class NewIssueAction
extends OsbAction
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private NewAction newAction = new NewAction();
    private JToggleButton button;
    private OsbPlugin plugin;

    public NewIssueAction(JToggleButton button, OsbPlugin plugin) {
        super(I18n.tr((String)"New issue"));
        this.button = button;
        this.plugin = plugin;
    }

    protected void doActionPerformed(ActionEvent e) throws IOException {
        if (this.button.isSelected()) {
            Main.map.mapView.setCursor(new Cursor(1));
            Main.map.mapView.addMouseListener((MouseListener)this);
        } else {
            this.reset();
        }
    }

    private void reset() {
        Main.map.mapView.setCursor(new Cursor(0));
        Main.map.mapView.removeMouseListener((MouseListener)this);
        this.button.setSelected(false);
    }

    public void mouseClicked(MouseEvent e) {
        this.addNewIssue(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.addNewIssue(e);
    }

    private void addNewIssue(MouseEvent e) {
        String result;
        String nickname = Main.pref.get("osb.nickname");
        if (nickname == null || nickname.length() == 0) {
            nickname = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Please enter a user name"));
            if (nickname == null) {
                nickname = "NoName";
            } else {
                Main.pref.put("osb.nickname", nickname);
            }
        }
        if ((result = JOptionPane.showInputDialog(Main.parent, I18n.tr((String)"Describe the problem precisely"), I18n.tr((String)"Create issue"), 3)) != null && result.length() > 0) {
            try {
                result = result.concat(" [").concat(nickname).concat("]");
                Node n = this.newAction.execute(e.getPoint(), result);
                this.plugin.getDataSet().addPrimitive((OsmPrimitive)n);
                if (Main.pref.getBoolean("osb.api.disabled")) {
                    this.plugin.updateGui();
                } else {
                    this.plugin.updateData();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"An error occurred: {0}", (Object[])new Object[]{result}), I18n.tr((String)"Error"), 0);
            }
        }
        this.reset();
    }

    public void mouseReleased(MouseEvent e) {
    }
}

