/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.openstreetmap.josm.tools.ImageProvider;

public class ScrollViewport
extends JPanel {
    private static final int NO_SCROLL = 0;
    public static final int UP_DIRECTION = 1;
    public static final int DOWN_DIRECTION = 2;
    public static final int LEFT_DIRECTION = 4;
    public static final int RIGHT_DIRECTION = 8;
    public static final int VERTICAL_DIRECTION = 3;
    public static final int HORIZONTAL_DIRECTION = 12;
    public static final int ALL_DIRECTION = 15;
    private JViewport vp = new JViewport();
    private JComponent component = null;
    private Timer timer = new Timer(200, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ScrollViewport.this.scroll();
        }
    });
    private int scrollDirection = 0;

    public ScrollViewport(JComponent jComponent, int n) {
        this(n);
        this.add(jComponent);
    }

    public ScrollViewport(int n) {
        JButton jButton;
        this.setLayout(new BorderLayout());
        if ((n & 1) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(1));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get((String)"svpUp"));
            this.add((Component)jButton, "North");
        }
        if ((n & 2) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(2));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get((String)"svpDown"));
            this.add((Component)jButton, "South");
        }
        if ((n & 4) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(4));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get((String)"svpLeft"));
            this.add((Component)jButton, "West");
        }
        if ((n & 8) > 0) {
            jButton = new JButton();
            jButton.addMouseListener(new ScrollViewPortMouseListener(8));
            jButton.setPreferredSize(new Dimension(10, 10));
            jButton.setIcon(ImageProvider.get((String)"svpRight"));
            this.add((Component)jButton, "East");
        }
        this.add((Component)this.vp, "Center");
        this.timer.setRepeats(true);
        this.timer.setInitialDelay(400);
    }

    public synchronized void scroll() {
        int n;
        int n2 = this.scrollDirection;
        if (this.component == null || n2 == 0) {
            return;
        }
        Dimension dimension = this.component.getSize();
        Rectangle rectangle = this.vp.getViewRect();
        int n3 = 0;
        int n4 = 0;
        if (n2 < 4) {
            n4 = rectangle.x;
            n = rectangle.height * 4 / 5;
        } else {
            n3 = rectangle.y;
            n = rectangle.width * 4 / 5;
        }
        switch (n2) {
            case 1: {
                n3 = rectangle.y - n;
                if (n3 >= 0) break;
                n3 = 0;
                break;
            }
            case 2: {
                n3 = rectangle.y + n;
                if (n3 <= dimension.height - rectangle.height) break;
                n3 = dimension.height - rectangle.height;
                break;
            }
            case 4: {
                n4 = rectangle.x - n;
                if (n4 >= 0) break;
                n4 = 0;
                break;
            }
            case 8: {
                n4 = rectangle.x + n;
                if (n4 <= dimension.width - rectangle.width) break;
                n4 = dimension.width - rectangle.width;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown direction : " + n2);
            }
        }
        this.vp.setViewPosition(new Point(n4, n3));
    }

    public Rectangle getViewRect() {
        return this.vp.getViewRect();
    }

    public Dimension getViewSize() {
        return this.vp.getViewSize();
    }

    public Point getViewPosition() {
        return this.vp.getViewPosition();
    }

    public void add(JComponent jComponent) {
        this.vp.removeAll();
        this.component = jComponent;
        this.vp.add(jComponent);
    }

    private class ScrollViewPortMouseListener
    extends MouseAdapter {
        private int direction;

        public ScrollViewPortMouseListener(int n) {
            this.direction = n;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = 0;
            ScrollViewport.this.timer.stop();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ScrollViewport.this.scrollDirection = this.direction;
            ScrollViewport.this.scroll();
            ScrollViewport.this.timer.restart();
        }
    }
}

