/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginDescription;
import at.dallermassl.josm.plugin.pluginmanager.SiteDescription;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginTableModel
extends AbstractTableModel {
    private List<SiteDescription> sites;
    private List<PluginDescription> plugins;

    public PluginTableModel(List<SiteDescription> descriptions) {
        this.sites = descriptions;
        this.update();
    }

    private void update() {
        this.plugins = new ArrayList<PluginDescription>();
        for (SiteDescription site : this.sites) {
            this.plugins.addAll(site.getPlugins());
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.plugins.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PluginDescription plugin = this.plugins.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return plugin.isInstall();
            }
            case 1: {
                return plugin.getName();
            }
            case 2: {
                if (plugin.getInstalledVersion() != null) {
                    return plugin.getInstalledVersion() + " -> " + plugin.getVersion();
                }
                return plugin.getVersion();
            }
        }
        throw new IllegalArgumentException("Illegal Column Index " + columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        PluginDescription plugin = this.plugins.get(rowIndex);
        plugin.setInstall(Boolean.TRUE.equals(value));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 2: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException("Illegal Column Index " + columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "";
            }
            case 1: {
                return I18n.tr((String)"Name");
            }
            case 2: {
                return I18n.tr((String)"Version");
            }
        }
        throw new IllegalArgumentException("Illegal Column Index " + column);
    }

    public void install() {
        for (PluginDescription plugin : this.plugins) {
            if (!plugin.isInstall()) continue;
            System.out.println("Installing plugin " + plugin.getName());
            plugin.install();
        }
    }

    public List<SiteDescription> getSites() {
        return this.sites;
    }

    public void setSites(List<SiteDescription> sites) {
        this.sites = sites;
    }

    public List<PluginDescription> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<PluginDescription> plugins) {
        this.plugins = plugins;
    }
}

