/*
 * Decompiled with CFR 0.152.
 */
package at.dallermassl.josm.plugin.pluginmanager;

import at.dallermassl.josm.plugin.pluginmanager.PluginUpdateFrame;
import at.dallermassl.josm.plugin.pluginmanager.SiteDescription;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PluginManagerPreference
implements PreferenceSetting {
    private String PREF_KEY_REMOTE_SITE_PREFIX = "pluginmanager.site.";
    private String PREF_KEY_SITE_NAME_SUFFIX = ".name";
    private String PREF_KEY_SITE_URL_SUFFIX = ".url";
    private JList siteList;
    private DefaultListModel siteListModel;
    private boolean requiresRestart = false;

    protected DefaultListModel createListModel() {
        String url;
        Map sites = Main.pref.getAllPrefix(this.PREF_KEY_REMOTE_SITE_PREFIX);
        if (sites.keySet().size() == 0) {
            sites.put(this.PREF_KEY_REMOTE_SITE_PREFIX + "0" + this.PREF_KEY_SITE_URL_SUFFIX, "http://www.tegmento.org/~cdaller/josm/");
        }
        int siteCount = 0;
        DefaultListModel<SiteDescription> listModel = new DefaultListModel<SiteDescription>();
        while ((url = (String)sites.get(this.PREF_KEY_REMOTE_SITE_PREFIX + siteCount + this.PREF_KEY_SITE_URL_SUFFIX)) != null) {
            String name = (String)sites.get(this.PREF_KEY_REMOTE_SITE_PREFIX + siteCount + this.PREF_KEY_SITE_NAME_SUFFIX);
            try {
                SiteDescription description = new SiteDescription(name, url);
                listModel.addElement(description);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            ++siteCount;
        }
        return listModel;
    }

    public void addGui(PreferenceDialog gui) {
        this.siteListModel = this.createListModel();
        this.siteList = new JList(this.siteListModel);
        this.siteList.setSelectionMode(2);
        JButton addSite = new JButton(I18n.tr((String)"Add Site"));
        addSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String siteUrl = JOptionPane.showInputDialog(Main.parent, (Object)I18n.tr((String)"Update Site URL"));
                if (siteUrl == null) {
                    return;
                }
                try {
                    if (!siteUrl.endsWith("/")) {
                        siteUrl = siteUrl + "/";
                    }
                    SiteDescription site = new SiteDescription(siteUrl);
                    PluginManagerPreference.this.siteListModel.addElement(site);
                }
                catch (MalformedURLException mue) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Invalid URL"), I18n.tr((String)"Error"), 0);
                    return;
                }
            }
        });
        JButton deleteSite = new JButton(I18n.tr((String)"Delete Site(s)"));
        deleteSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPreference.this.siteList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the site to delete."));
                } else {
                    int[] selected = PluginManagerPreference.this.siteList.getSelectedIndices();
                    for (int i = selected.length - 1; i >= 0; --i) {
                        PluginManagerPreference.this.siteListModel.removeElementAt(selected[i]);
                    }
                }
            }
        });
        JButton checkSite = new JButton(I18n.tr((String)"Check Site(s)"));
        checkSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PluginManagerPreference.this.siteList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select the site(s) to check for updates."));
                } else {
                    int[] selected = PluginManagerPreference.this.siteList.getSelectedIndices();
                    ArrayList<SiteDescription> descriptions = new ArrayList<SiteDescription>();
                    for (int selectedIndex : selected) {
                        SiteDescription description = (SiteDescription)PluginManagerPreference.this.siteListModel.get(selectedIndex);
                        descriptions.add(description);
                        try {
                            description.loadFromUrl();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    PluginUpdateFrame frame = new PluginUpdateFrame(I18n.tr((String)"Plugins"), descriptions);
                    frame.setVisible(true);
                    PluginManagerPreference.this.requiresRestart = true;
                }
            }
        });
        this.siteList.setVisibleRowCount(3);
        addSite.setToolTipText(I18n.tr((String)"Add a new plugin site."));
        deleteSite.setToolTipText(I18n.tr((String)"Delete the selected site(s) from the list."));
        checkSite.setToolTipText(I18n.tr((String)"Check the selected site(s) for new plugins or updates."));
        gui.map.add((Component)new JLabel(I18n.tr((String)"Update Sites")), GBC.eol().insets(0, 5, 0, 0));
        gui.map.add((Component)new JScrollPane(this.siteList), GBC.eol().fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gui.map.add((Component)buttonPanel, GBC.eol().fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)addSite, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)deleteSite, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)checkSite, GBC.std().insets(0, 5, 5, 0));
    }

    public boolean ok() {
        Map keys = Main.pref.getAllPrefix(this.PREF_KEY_REMOTE_SITE_PREFIX);
        for (String key : keys.keySet()) {
            Main.pref.put(key, null);
        }
        for (int index = 0; index < this.siteListModel.getSize(); ++index) {
            String key;
            SiteDescription desc = (SiteDescription)this.siteListModel.elementAt(index);
            if (desc.getName() != null) {
                key = this.PREF_KEY_REMOTE_SITE_PREFIX + index + this.PREF_KEY_SITE_NAME_SUFFIX;
                Main.pref.put(key, desc.getName());
            }
            key = this.PREF_KEY_REMOTE_SITE_PREFIX + index + this.PREF_KEY_SITE_URL_SUFFIX;
            try {
                Main.pref.put(key, desc.getUrl().toURI().toASCIIString());
                continue;
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        return this.requiresRestart;
    }
}

