/*
 * Decompiled with CFR 0.152.
 */
package usertools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class UserToolsPlugin
extends Plugin {
    static JMenu userJMenu;

    public UserToolsPlugin() {
        UserToolsPlugin.refreshMenu();
    }

    private static String urlEncodeWithNoPluses(String input) {
        if (input == null) {
            return null;
        }
        String inputEnc = "";
        try {
            inputEnc = URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuffer retu = new StringBuffer();
        for (int i = 0; i < inputEnc.length(); ++i) {
            if (inputEnc.charAt(i) == '+') {
                retu.append("%20");
                continue;
            }
            retu.append(inputEnc.charAt(i));
        }
        return retu.toString();
    }

    public static void refreshMenu() {
        MainMenu menu = Main.main.menu;
        if (userJMenu == null) {
            userJMenu = new JMenu(I18n.tr((String)"User"));
            menu.add(userJMenu, 85, "user");
            menu.add((Component)userJMenu, 5);
        } else {
            userJMenu.removeAll();
        }
        userJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Show Author Panel"), "dialogs/userlist", I18n.tr((String)"Show Author Panel"), null, false){

            public void actionPerformed(ActionEvent ev) {
                int dialogIndex = 100;
                for (int i = 0; i < Main.map.toggleDialogs.getComponentCount(); ++i) {
                    if (!Main.map.toggleDialogs.getComponent(i).getClass().getSimpleName().equals("UserListDialog")) continue;
                    dialogIndex = i;
                }
                UserListDialog uld = (UserListDialog)Main.map.toggleDialogs.getComponent(dialogIndex);
                uld.setVisible(true);
            }
        }));
        userJMenu.addSeparator();
        userJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Open User Page"), "presets/letter", I18n.tr((String)"Open User Page in browser"), null, false){

            public void actionPerformed(ActionEvent ev) {
                String name = UserToolsPlugin.getSelectedUser();
                if (!name.equals("0")) {
                    String userUrl = "http://www.openstreetmap.org/user/" + name;
                    OpenBrowser.displayUrl((String)userUrl);
                }
            }
        }));
        userJMenu.add(new JMenuItem((Action)new JosmAction(I18n.tr((String)"Select User's Data"), "dialogs/search", I18n.tr((String)"Replaces Selection with Users data"), null, false){

            public void actionPerformed(ActionEvent ev) {
                String name = UserToolsPlugin.getSelectedUser();
                if (!name.equals("0")) {
                    SearchAction.SearchMode mode = SearchAction.SearchMode.replace;
                    SearchAction.search((String)name, (SearchAction.SearchMode)mode, (boolean)false);
                }
            }
        }));
        UserToolsPlugin.setEnabledAll(false);
    }

    public static String getSelectedUser() {
        int dialogIndex = 100;
        for (int i = 0; i < Main.map.toggleDialogs.getComponentCount(); ++i) {
            if (!Main.map.toggleDialogs.getComponent(i).getClass().getSimpleName().equals("UserListDialog")) continue;
            dialogIndex = i;
        }
        UserListDialog uld = (UserListDialog)Main.map.toggleDialogs.getComponent(dialogIndex);
        JScrollPane jsp = (JScrollPane)uld.getComponent(1);
        JViewport view = (JViewport)jsp.getComponent(0);
        JTable tab = (JTable)view.getComponent(0);
        if (tab.getRowCount() == 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select some data"));
            return "0";
        }
        if (tab.getSelectedRow() == -1 && tab.getRowCount() > 0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please choose a user using the author panel"));
            return "0";
        }
        String name = "(anonymous users)";
        if (tab.getSelectedRow() > -1) {
            name = (String)tab.getValueAt(tab.getSelectedRow(), 0);
        }
        if (name.equals("(anonymous users)")) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Sorry, doesn't work with anonymous users"));
            return "0";
        }
        name = UserToolsPlugin.urlEncodeWithNoPluses(name);
        return name;
    }

    private static void setEnabledAll(boolean isEnabled) {
        for (int i = 0; i < userJMenu.getItemCount(); ++i) {
            JMenuItem item = userJMenu.getItem(i);
            if (item == null) continue;
            item.setEnabled(isEnabled);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame == null && newFrame != null) {
            UserToolsPlugin.setEnabledAll(true);
        } else if (oldFrame != null && newFrame == null) {
            UserToolsPlugin.setEnabledAll(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace,
        add,
        remove;

    }
}

