/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.lakewalker;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

public class LakewalkerReader {
    protected Collection<Command> commands = new LinkedList<Command>();
    protected Collection<Way> ways = new ArrayList<Way>();
    protected boolean cancel;

    public void read(BufferedReader input) {
        Way way = new Way();
        this.setStatus("Initializing");
        double eastOffset = Main.pref.getDouble("lakewalker.east_offset", 0.0);
        double northOffset = Main.pref.getDouble("lakewalker.north_offset", 0.0);
        int option = 32;
        try {
            String line;
            Node n = null;
            Node tn = null;
            Node fn = null;
            while ((line = input.readLine()) != null) {
                if (this.cancel) {
                    return;
                }
                System.out.println(line);
                option = line.charAt(0);
                switch (option) {
                    case 110: {
                        String[] tokens = line.split(" ");
                        if (tn == null) {
                            try {
                                LatLon ll = new LatLon(Double.parseDouble(tokens[1]) + northOffset, Double.parseDouble(tokens[2]) + eastOffset);
                                n = new Node(ll);
                                if (fn == null) {
                                    fn = n;
                                }
                                this.commands.add((Command)new AddCommand((OsmPrimitive)n));
                            }
                            catch (Exception ex) {}
                        } else {
                            n = tn;
                            tn = null;
                        }
                        way.nodes.add(n);
                        break;
                    }
                    case 115: {
                        this.setStatus(line.substring(2));
                        break;
                    }
                    case 120: {
                        String waytype = Main.pref.get("lakewalker.waytype", "water");
                        if (!waytype.equals("none")) {
                            way.put("natural", waytype);
                        }
                        way.put("source", Main.pref.get("lakewalker.source", "water"));
                        this.commands.add((Command)new AddCommand((OsmPrimitive)way));
                        break;
                    }
                    case 116: {
                        way = new Way();
                        tn = n;
                        break;
                    }
                    case 101: {
                        String error = line.substring(2);
                        this.cancel = true;
                    }
                }
            }
            input.close();
            way.nodes.add(fn);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!this.commands.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Lakewalker trace"), this.commands));
            Main.ds.setSelected(this.ways);
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    protected void setStatus(String s) {
        Main.pleaseWaitDlg.currentAction.setText(s);
        Main.pleaseWaitDlg.repaint();
    }
}

