/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.SloppyBugComparator;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.VersionInsensitiveBugComparator;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.model.MovedClassMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.DocumentException;

public class Update {
    static final boolean doMatchFixedBugs = SystemProperties.getBoolean("findbugs.matchFixedBugs", true);
    static final int maxResurrection = SystemProperties.getInt("findbugs.maxResurrection", 90);
    private static final String USAGE = "Usage: " + Update.class.getName() + " [options]  data1File data2File data3File ... ";
    private final Map<BugInstance, BugInstance> mapFromNewToOldBug = new IdentityHashMap<BugInstance, BugInstance>();
    private final Set<String> resurrected = new HashSet<String>();
    private final Map<BugInstance, Void> matchedOldBugs = new IdentityHashMap<BugInstance, Void>();
    boolean noPackageMoves = false;
    boolean useAnalysisTimes = false;
    boolean noResurrections = false;
    boolean preciseMatch = false;
    boolean sloppyMatch = false;
    boolean precisePriorityMatch = false;
    int mostRecent = -1;
    int maxRank = 20;
    VersionInsensitiveBugComparator versionInsensitiveBugComparator = new VersionInsensitiveBugComparator();
    VersionInsensitiveBugComparator fuzzyBugPatternMatcher = new VersionInsensitiveBugComparator();
    boolean verbose;

    public Update() {
        this.fuzzyBugPatternMatcher.setExactBugPatternMatch(false);
        this.verbose = true;
    }

    HashSet<String> sourceFilesInCollection(BugCollection collection) {
        HashSet<String> result = new HashSet<String>();
        for (PackageStats pStats : collection.getProjectStats().getPackageStats()) {
            for (PackageStats.ClassStats cStats : pStats.getClassStats()) {
                result.add(cStats.getSourceFile());
            }
        }
        return result;
    }

    public void removeBaselineBugs(BugCollection baselineCollection, BugCollection bugCollection) {
        this.matchBugs(baselineCollection, bugCollection);
        this.matchBugs(SortedBugCollection.BugInstanceComparator.instance, baselineCollection, bugCollection);
        this.matchBugs(this.versionInsensitiveBugComparator, baselineCollection, bugCollection);
        Iterator<BugInstance> i = bugCollection.getCollection().iterator();
        while (i.hasNext()) {
            BugInstance bug = i.next();
            if (!this.matchedOldBugs.containsKey(bug)) continue;
            i.remove();
        }
    }

    public BugCollection mergeCollections(BugCollection origCollection, BugCollection newCollection, boolean copyDeadBugs, boolean incrementalAnalysis) {
        BugInstance newBug;
        for (BugInstance b : newCollection) {
            if (!b.isDead()) continue;
            throw new IllegalArgumentException("Can't merge bug collections if the newer collection contains dead bugs: " + b);
        }
        this.mapFromNewToOldBug.clear();
        this.matchedOldBugs.clear();
        BugCollection resultCollection = newCollection.createEmptyCollectionWithMetadata();
        long lastSequence = origCollection.getSequenceNumber();
        resultCollection.clearAppVersions();
        Iterator<AppVersion> i = origCollection.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = i.next();
            resultCollection.addAppVersion((AppVersion)appVersion.clone());
        }
        AppVersion origCollectionVersion = origCollection.getCurrentAppVersion();
        AppVersion origCollectionVersionClone = new AppVersion(lastSequence);
        origCollectionVersionClone.setTimestamp(origCollectionVersion.getTimestamp());
        origCollectionVersionClone.setReleaseName(origCollectionVersion.getReleaseName());
        origCollectionVersionClone.setNumClasses(origCollection.getProjectStats().getNumClasses());
        origCollectionVersionClone.setCodeSize(origCollection.getProjectStats().getCodeSize());
        resultCollection.addAppVersion(origCollectionVersionClone);
        long currentSequence = origCollection.getSequenceNumber() + 1L;
        resultCollection.setSequenceNumber(currentSequence);
        this.matchBugs(origCollection, newCollection);
        if (this.sloppyMatch) {
            this.matchBugs(new SloppyBugComparator(), origCollection, newCollection);
        }
        HashSet<String> analyzedSourceFiles = this.sourceFilesInCollection(newCollection);
        if (copyDeadBugs || incrementalAnalysis) {
            for (BugInstance bug : origCollection.getCollection()) {
                boolean fixed;
                if (this.matchedOldBugs.containsKey(bug)) continue;
                if (bug.isDead()) {
                    newBug = (BugInstance)bug.clone();
                    resultCollection.add(newBug, false);
                    continue;
                }
                newBug = (BugInstance)bug.clone();
                ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                String className = classBugFoundIn.getClassName();
                String sourceFile = classBugFoundIn.getSourceFileName();
                boolean bl = fixed = sourceFile != null && analyzedSourceFiles.contains(sourceFile) || newCollection.getProjectStats().getClassStats(className) != null;
                if (fixed) {
                    if (!copyDeadBugs) continue;
                    newBug.setRemovedByChangeOfPersistingClass(true);
                    newBug.setLastVersion(lastSequence);
                } else if (!incrementalAnalysis) {
                    newBug.setLastVersion(lastSequence);
                }
                if (newBug.isDead() && newBug.getFirstVersion() > newBug.getLastVersion()) {
                    throw new IllegalStateException("Illegal Version range: " + newBug.getFirstVersion() + ".." + newBug.getLastVersion());
                }
                resultCollection.add(newBug, false);
            }
        }
        for (BugInstance bug : newCollection.getCollection()) {
            newBug = (BugInstance)bug.clone();
            if (this.mapFromNewToOldBug.containsKey(bug)) {
                BugInstance origWarning = this.mapFromNewToOldBug.get(bug);
                Update.mergeBugHistory(origWarning, newBug);
            } else {
                newBug.setFirstVersion(lastSequence + 1L);
                ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                String className = classBugFoundIn.getClassName();
                if (origCollection.getProjectStats().getClassStats(className) != null) {
                    newBug.setIntroducedByChangeOfExistingClass(true);
                }
            }
            if (newBug.isDead()) {
                throw new IllegalStateException("Illegal Version range: " + newBug.getFirstVersion() + ".." + newBug.getLastVersion());
            }
            int oldSize = resultCollection.getCollection().size();
            resultCollection.add(newBug, false);
            int newSize = resultCollection.getCollection().size();
            if (newSize == oldSize + 1) continue;
            System.out.println("Failed to add bug" + newBug.getMessage());
        }
        return resultCollection;
    }

    private void discardUnwantedBugs(BugCollection newCollection) {
        BugRanker.trimToMaxRank(newCollection, this.maxRank);
        if (this.sloppyMatch) {
            TreeSet<BugInstance> sloppyUnique = new TreeSet<BugInstance>(new SloppyBugComparator());
            Iterator<BugInstance> i = newCollection.iterator();
            while (i.hasNext()) {
                if (sloppyUnique.add(i.next())) continue;
                i.remove();
            }
        }
    }

    private void matchBugs(BugCollection origCollection, BugCollection newCollection) {
        this.matchBugs(SortedBugCollection.BugInstanceComparator.instance, origCollection, newCollection);
        this.mapFromNewToOldBug.clear();
        this.matchedOldBugs.clear();
        this.matchBugs(this.versionInsensitiveBugComparator, origCollection, newCollection);
        this.matchBugs(this.versionInsensitiveBugComparator, origCollection, newCollection, MatchOldBugs.IF_CLASS_NOT_SEEN_UNTIL_NOW);
        if (doMatchFixedBugs) {
            this.matchBugs(this.versionInsensitiveBugComparator, origCollection, newCollection, MatchOldBugs.ALWAYS);
        }
        if (!this.preciseMatch) {
            this.matchBugs(this.fuzzyBugPatternMatcher, origCollection, newCollection);
        }
        if (!this.noPackageMoves) {
            VersionInsensitiveBugComparator movedBugComparator = new VersionInsensitiveBugComparator();
            MovedClassMap movedClassMap = new MovedClassMap(origCollection, newCollection).execute();
            if (!movedClassMap.isEmpty()) {
                movedBugComparator.setClassNameRewriter(movedClassMap);
                movedBugComparator.setComparePriorities(this.precisePriorityMatch);
                this.matchBugs(movedBugComparator, origCollection, newCollection);
                if (!this.preciseMatch) {
                    movedBugComparator.setExactBugPatternMatch(false);
                    this.matchBugs(movedBugComparator, origCollection, newCollection);
                }
            }
        }
    }

    public static String[] getFilePathParts(String filePath) {
        String regex = File.separatorChar == '\\' ? "\\\\" : File.separator;
        return filePath.split(regex);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        FindBugs.setNoAnalysis();
        new Update().doit(args);
    }

    public void doit(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        UpdateCommandLine commandLine = new UpdateCommandLine();
        int argCount = commandLine.parse(args, 1, Integer.MAX_VALUE, USAGE);
        if (commandLine.outputFilename == null) {
            this.verbose = false;
        }
        if (this.mostRecent > 0) {
            argCount = Math.max(argCount, args.length - this.mostRecent);
        }
        String[] firstPathParts = Update.getFilePathParts(args[argCount]);
        int commonPrefix = firstPathParts.length;
        for (int i = argCount + 1; i <= args.length - 1; ++i) {
            commonPrefix = Math.min(commonPrefix, Update.lengthCommonPrefix(firstPathParts, Update.getFilePathParts(args[i])));
        }
        String origFilename = args[argCount++];
        BugCollection origCollection = new SortedBugCollection();
        if (this.verbose) {
            System.out.println("Starting with " + origFilename);
        }
        while (true) {
            try {
                File f;
                while ((f = new File(origFilename)).length() <= 0L) {
                    if (this.verbose) {
                        System.out.println("Empty input file: " + f);
                    }
                    origFilename = args[argCount++];
                }
                origCollection.readXML(origFilename);
            }
            catch (Exception e) {
                if (this.verbose) {
                    System.out.println("Error reading " + origFilename);
                    e.printStackTrace(System.out);
                }
                origFilename = args[argCount++];
                continue;
            }
            break;
        }
        if (commandLine.overrideRevisionNames || origCollection.getReleaseName() == null || origCollection.getReleaseName().length() == 0) {
            if (commonPrefix >= firstPathParts.length) {
                commonPrefix = firstPathParts.length - 1;
            }
            origCollection.setReleaseName(firstPathParts[commonPrefix]);
            if (this.useAnalysisTimes) {
                origCollection.setTimestamp(origCollection.getAnalysisTimestamp());
            }
        }
        for (BugInstance bug : origCollection.getCollection()) {
            if (bug.getLastVersion() < 0L || bug.getFirstVersion() <= bug.getLastVersion()) continue;
            throw new IllegalStateException("Illegal Version range: " + bug.getFirstVersion() + ".." + bug.getLastVersion());
        }
        this.discardUnwantedBugs(origCollection);
        while (argCount <= args.length - 1) {
            SortedBugCollection newCollection = new SortedBugCollection();
            String newFilename = args[argCount++];
            if (this.verbose) {
                System.out.println("Merging " + newFilename);
            }
            try {
                File f = new File(newFilename);
                if (f.length() == 0L) {
                    if (!this.verbose) continue;
                    System.out.println("Empty input file: " + f);
                    continue;
                }
                newCollection.readXML(newFilename);
                if (commandLine.overrideRevisionNames || newCollection.getReleaseName() == null || newCollection.getReleaseName().length() == 0) {
                    newCollection.setReleaseName(Update.getFilePathParts(newFilename)[commonPrefix]);
                }
                if (this.useAnalysisTimes) {
                    newCollection.setTimestamp(newCollection.getAnalysisTimestamp());
                }
                this.discardUnwantedBugs(newCollection);
                origCollection = this.mergeCollections(origCollection, newCollection, true, false);
            }
            catch (IOException e) {
                IOException e2 = new IOException("Error parsing " + newFilename);
                e2.initCause(e);
                if (this.verbose) {
                    e2.printStackTrace();
                }
                throw e2;
            }
            catch (DocumentException e) {
                DocumentException e2 = new DocumentException("Error parsing " + newFilename);
                e2.initCause(e);
                if (this.verbose) {
                    e2.printStackTrace();
                }
                throw e2;
            }
        }
        origCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFilename != null) {
            if (this.verbose) {
                System.out.println("Writing " + commandLine.outputFilename);
            }
            origCollection.writeXML(commandLine.outputFilename);
        } else {
            origCollection.writeXML(System.out);
        }
    }

    private static int lengthCommonPrefix(String[] string, String[] string2) {
        int maxLength = Math.min(string.length, string2.length);
        for (int result = 0; result < maxLength; ++result) {
            if (string[result].equals(string2[result])) continue;
            return result;
        }
        return maxLength;
    }

    private static void mergeBugHistory(BugInstance older, BugInstance newer) {
        newer.setFirstVersion(older.getFirstVersion());
        newer.setIntroducedByChangeOfExistingClass(older.isIntroducedByChangeOfExistingClass());
    }

    private void matchBugs(Comparator<BugInstance> bugInstanceComparator, BugCollection origCollection, BugCollection newCollection) {
        this.matchBugs(bugInstanceComparator, origCollection, newCollection, MatchOldBugs.IF_LIVE);
    }

    private void matchBugs(Comparator<BugInstance> bugInstanceComparator, BugCollection origCollection, BugCollection newCollection, MatchOldBugs matchOld) {
        TreeMap<BugInstance, LinkedList<BugInstance>> set = new TreeMap<BugInstance, LinkedList<BugInstance>>(bugInstanceComparator);
        for (BugInstance bug : origCollection.getCollection()) {
            if (this.matchedOldBugs.containsKey(bug) || !matchOld.match(bug)) continue;
            LinkedList<BugInstance> q = (LinkedList<BugInstance>)set.get(bug);
            if (q == null) {
                q = new LinkedList<BugInstance>();
                set.put(bug, q);
            }
            q.add(bug);
        }
        long newVersion = origCollection.getCurrentAppVersion().getSequenceNumber() + 1L;
        block1: for (BugInstance bug : newCollection.getCollection()) {
            LinkedList q;
            if (this.mapFromNewToOldBug.containsKey(bug) || (q = (LinkedList)set.get(bug)) == null) continue;
            Iterator i = q.iterator();
            while (i.hasNext()) {
                BugInstance matchedBug = (BugInstance)i.next();
                if (matchedBug.isDead()) {
                    if (this.noResurrections || matchedBug.isRemovedByChangeOfPersistingClass() && newVersion - matchedBug.getLastVersion() > (long)maxResurrection) continue;
                    this.resurrected.add(bug.getInstanceKey());
                }
                this.mapFromNewToOldBug.put(bug, matchedBug);
                this.matchedOldBugs.put(matchedBug, null);
                i.remove();
                if (!q.isEmpty()) continue block1;
                set.remove(bug);
                continue block1;
            }
        }
    }

    static enum MatchOldBugs {
        IF_LIVE,
        IF_CLASS_NOT_SEEN_UNTIL_NOW,
        ALWAYS;


        boolean match(BugInstance b) {
            switch (this) {
                case ALWAYS: {
                    return true;
                }
                case IF_CLASS_NOT_SEEN_UNTIL_NOW: {
                    return !b.isDead() || b.isRemovedByChangeOfPersistingClass();
                }
                case IF_LIVE: {
                    return !b.isDead();
                }
            }
            throw new IllegalStateException();
        }
    }

    class UpdateCommandLine
    extends CommandLine {
        boolean overrideRevisionNames = false;
        String outputFilename;
        boolean withMessages = false;

        UpdateCommandLine() {
            this.addSwitch("-overrideRevisionNames", "override revision names for each version with names computed filenames");
            this.addSwitch("-noPackageMoves", "if a class seems to have moved from one package to another, treat warnings in that class as two separate warnings");
            this.addSwitch("-noResurrections", "if an issue had been detected in two versions but not in an intermediate version, record as two separate issues");
            this.addSwitch("-preciseMatch", "require bug patterns to match precisely");
            this.addSwitch("-precisePriorityMatch", "only consider two warnings to be the same if their priorities match exactly");
            this.addSwitch("-sloppyMatch", "very relaxed matching of bugs");
            this.addOption("-output", "output file", "explicit filename for merged results (standard out used if not specified)");
            this.addOption("-maxRank", "max rank", "maximum rank for issues to store");
            this.addSwitch("-quiet", "don't generate any outout to standard out unless there is an error");
            this.addSwitch("-useAnalysisTimes", "use analysis timestamp rather than code timestamp in history");
            this.addSwitch("-withMessages", "Add bug description");
            this.addOption("-onlyMostRecent", "number", "only use the last # input files");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if ("-overrideRevisionNames".equals(option)) {
                this.overrideRevisionNames = optionExtraPart.length() == 0 ? true : Boolean.parseBoolean(optionExtraPart);
            } else if ("-noPackageMoves".equals(option)) {
                Update.this.noPackageMoves = optionExtraPart.length() == 0 ? true : Boolean.parseBoolean(optionExtraPart);
            } else if ("-noResurrections".equals(option)) {
                Update.this.noResurrections = optionExtraPart.length() == 0 ? true : Boolean.parseBoolean(optionExtraPart);
            } else if ("-preciseMatch".equals(option)) {
                Update.this.preciseMatch = true;
            } else if ("-sloppyMatch".equals(option)) {
                Update.this.sloppyMatch = true;
            } else if ("-precisePriorityMatch".equals(option)) {
                Update.this.versionInsensitiveBugComparator.setComparePriorities(true);
                Update.this.fuzzyBugPatternMatcher.setComparePriorities(true);
                Update.this.precisePriorityMatch = true;
            } else if ("-quiet".equals(option)) {
                Update.this.verbose = false;
            } else if ("-useAnalysisTimes".equals(option)) {
                Update.this.useAnalysisTimes = true;
            } else if ("-withMessages".equals(option)) {
                this.withMessages = true;
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-output".equals(option)) {
                this.outputFilename = argument;
            } else if ("-maxRank".equals(option)) {
                Update.this.maxRank = Integer.parseInt(argument);
            } else if ("-onlyMostRecent".equals(option)) {
                Update.this.mostRecent = Integer.parseInt(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

