/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ExcludingHashesBugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SloppyBugComparator;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.util.Util;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;

public class Filter {
    static SourceSearcher sourceSearcher;

    public static int parsePriority(String argument) {
        int i = " HMLE".indexOf(argument);
        if (i == -1) {
            i = " 1234".indexOf(argument);
        }
        if (i == -1) {
            throw new IllegalArgumentException("Bad priority: " + argument);
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        Iterator<Cloneable> i;
        FindBugs.setNoAnalysis();
        DetectorFactoryCollection.instance();
        FilterCommandLine commandLine = new FilterCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + Filter.class.getName() + " [options] [<orig results> [<new results]] ");
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount == args.length) {
            origCollection.readXML(System.in);
        } else {
            origCollection.readXML(args[argCount++]);
        }
        boolean verbose = argCount < args.length;
        SortedBugCollection resultCollection = origCollection.createEmptyCollectionWithMetadata();
        Project project = resultCollection.getProject();
        int passed = 0;
        int dropped = 0;
        resultCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.hashChangedSpecified) {
            origCollection.computeBugHashes();
        }
        commandLine.adjustFilter(project, resultCollection);
        ProjectStats projectStats = resultCollection.getProjectStats();
        projectStats.clearBugCounts();
        if (commandLine.classPattern != null) {
            projectStats.purgeClassesThatDontMatch(commandLine.classPattern);
        }
        sourceSearcher = new SourceSearcher(project);
        long trimToVersion = -1L;
        if (commandLine.trimToVersionAsString != null) {
            HashMap<String, AppVersion> versions = new HashMap<String, AppVersion>();
            TreeMap<Long, AppVersion> timeStamps = new TreeMap<Long, AppVersion>();
            i = origCollection.appVersionIterator();
            while (i.hasNext()) {
                AppVersion v = i.next();
                versions.put(v.getReleaseName(), v);
                timeStamps.put(v.getTimestamp(), v);
            }
            AppVersion v = resultCollection.getCurrentAppVersion();
            versions.put(v.getReleaseName(), v);
            timeStamps.put(v.getTimestamp(), v);
            trimToVersion = FilterCommandLine.getVersionNum(versions, timeStamps, commandLine.trimToVersionAsString, true, v.getSequenceNumber());
            if (trimToVersion < origCollection.getSequenceNumber()) {
                String name = resultCollection.getAppVersionFromSequenceNumber(trimToVersion).getReleaseName();
                long timestamp = resultCollection.getAppVersionFromSequenceNumber(trimToVersion).getTimestamp();
                resultCollection.setReleaseName(name);
                resultCollection.setTimestamp(timestamp);
                resultCollection.trimAppVersions(trimToVersion);
            }
        }
        commandLine.getReady(origCollection);
        for (BugInstance bug : origCollection.getCollection()) {
            if (commandLine.accept(origCollection, bug)) {
                if (trimToVersion >= 0L) {
                    if (bug.getFirstVersion() > trimToVersion) {
                        ++dropped;
                        continue;
                    }
                    if (bug.getLastVersion() >= trimToVersion) {
                        bug.setLastVersion(-1L);
                        bug.setRemovedByChangeOfPersistingClass(false);
                    }
                }
                resultCollection.add(bug, false);
                ++passed;
                continue;
            }
            ++dropped;
        }
        if (commandLine.purgeHistorySpecified && commandLine.purgeHistory) {
            resultCollection.clearAppVersions();
            for (BugInstance bug : resultCollection.getCollection()) {
                bug.clearHistory();
            }
        }
        if (verbose) {
            System.out.println(passed + " warnings passed through, " + dropped + " warnings dropped");
        }
        if (commandLine.withSourceSpecified && commandLine.withSource && !commandLine.dontUpdateStats && projectStats.hasClassStats()) {
            for (PackageStats stats : projectStats.getPackageStats()) {
                i = stats.getClassStats().iterator();
                while (i.hasNext()) {
                    String className = ((PackageStats.ClassStats)i.next()).getName();
                    if (!Filter.sourceSearcher.sourceNotFound.contains(className) && (Filter.sourceSearcher.sourceFound.contains(className) || sourceSearcher.findSource(SourceLineAnnotation.createReallyUnknown(className)))) continue;
                    i.remove();
                }
            }
        }
        projectStats.recomputeFromComponents();
        if (argCount == args.length) {
            assert (!verbose);
            resultCollection.writeXML(System.out);
        } else {
            resultCollection.writeXML(args[argCount++]);
        }
    }

    static class FilterCommandLine
    extends CommandLine {
        public static final long MILLISECONDS_PER_DAY = 86400000L;
        Pattern classPattern;
        Pattern bugPattern;
        Pattern callsPattern;
        public boolean notSpecified = false;
        public boolean not = false;
        int duration;
        long first;
        String firstAsString;
        long after;
        String afterAsString;
        long before;
        String beforeAsString;
        int maxRank = Integer.MAX_VALUE;
        long maybeMutated;
        String maybeMutatedAsString;
        long last;
        String lastAsString;
        String trimToVersionAsString;
        String fixedAsString;
        long present;
        String presentAsString;
        long absent;
        String absentAsString;
        String annotation;
        HashSet<String> hashesFromFile;
        public boolean sloppyUniqueSpecified = false;
        public boolean sloppyUnique = false;
        public boolean purgeHistorySpecified = false;
        public boolean purgeHistory = false;
        public boolean activeSpecified = false;
        public boolean active = false;
        public boolean notAProblem = false;
        public boolean notAProblemSpecified = false;
        public boolean shouldFix = false;
        public boolean shouldFixSpecified = false;
        public boolean hasField = false;
        public boolean hasFieldSpecified = false;
        public boolean hasLocal = false;
        public boolean hasLocalSpecified = false;
        public boolean applySuppression = false;
        public boolean applySuppressionSpecified = false;
        public boolean withSource = false;
        public boolean withSourceSpecified = false;
        public boolean knownSource = false;
        public boolean knownSourceSpecified = false;
        public boolean introducedByChange = false;
        public boolean introducedByChangeSpecified = false;
        public boolean removedByChange = false;
        public boolean removedByChangeSpecified = false;
        public boolean newCode = false;
        public boolean newCodeSpecified = false;
        public boolean hashChanged = false;
        public boolean hashChangedSpecified = false;
        public boolean removedCode = false;
        public boolean removedCodeSpecified = false;
        public boolean dontUpdateStats = false;
        public boolean dontUpdateStatsSpecified = false;
        public boolean withMessagesSpecified = false;
        public boolean withMessages = false;
        private final List<Matcher> includeFilter = new LinkedList<Matcher>();
        private final List<Matcher> excludeFilter = new LinkedList<Matcher>();
        HashSet<String> excludedInstanceHashes = new HashSet();
        Set<String> designationKey = new HashSet<String>();
        Set<String> categoryKey = new HashSet<String>();
        SortedSet<BugInstance> uniqueSloppy;
        int priority = 3;
        edu.umd.cs.findbugs.filter.Filter suppressionFilter;
        HashSet<String> mutationPoints;

        FilterCommandLine() {
            this.addSwitch("-not", "reverse (all) switches for the filter");
            this.addSwitchWithOptionalExtraPart("-knownSource", "trurh", "Only issues that have known source locations");
            this.addSwitchWithOptionalExtraPart("-withSource", "truth", "only warnings for which source is available");
            this.addSwitchWithOptionalExtraPart("-hashChanged", "truth", "only warnings for which the stored hash is not the same as the calculated hash");
            this.addOption("-excludeBugs", "baseline bug collection", "exclude bugs already contained in the baseline bug collection");
            this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
            this.addOption("-include", "filter file", "include only bugs matching given filter");
            this.addOption("-annotation", "text", "allow only warnings containing this text in a user annotation");
            this.addSwitchWithOptionalExtraPart("-withMessages", "truth", "generated XML should contain textual messages");
            this.addOption("-maxDuration", "# versions", "only issues present in at most this many versions");
            this.addOption("-after", "when", "allow only warnings that first occurred after this version");
            this.addOption("-before", "when", "allow only warnings that first occurred before this version");
            this.addOption("-first", "when", "allow only warnings that first occurred in this version");
            this.addOption("-last", "when", "allow only warnings that last occurred in this version");
            this.addOption("-trimToVersion", "when", "trim bug collection to exclude information about versions after this one");
            this.addOption("-fixed", "when", "allow only warnings that last occurred in the previous version (clobbers last)");
            this.addOption("-present", "when", "allow only warnings present in this version");
            this.addOption("-absent", "when", "allow only warnings absent in this version");
            this.addOption("-maybeMutated", "when", "allow only warnings that might have mutated/fixed/born in this version");
            this.addSwitchWithOptionalExtraPart("-hasField", "truth", "allow only warnings that are annotated with a field");
            this.addSwitchWithOptionalExtraPart("-hasLocal", "truth", "allow only warnings that are annotated with a local variable");
            this.addSwitchWithOptionalExtraPart("-active", "truth", "allow only warnings alive in the last sequence number");
            this.addSwitch("-applySuppression", "exclude warnings that match the suppression filter");
            this.addSwitch("-purgeHistory", "remove all version history");
            this.addSwitchWithOptionalExtraPart("-sloppyUnique", "truth", "select only issues thought to be unique by the sloppy bug comparator ");
            this.makeOptionUnlisted("-sloppyUnique");
            this.addSwitchWithOptionalExtraPart("-introducedByChange", "truth", "allow only warnings introduced by a change of an existing class");
            this.addSwitchWithOptionalExtraPart("-removedByChange", "truth", "allow only warnings removed by a change of a persisting class");
            this.addSwitchWithOptionalExtraPart("-newCode", "truth", "allow only warnings introduced by the addition of a new class");
            this.addSwitchWithOptionalExtraPart("-removedCode", "truth", "allow only warnings removed by removal of a class");
            this.addOption("-priority", "level", "allow only warnings with this priority or higher");
            this.makeOptionUnlisted("-priority");
            this.addOption("-confidence", "level", "allow only warnings with this confidence or higher");
            this.addOption("-maxRank", "rank", "allow only warnings with this rank or lower");
            this.addSwitchWithOptionalExtraPart("-notAProblem", "truth", "Only issues with a consensus view that they are not a problem");
            this.addSwitchWithOptionalExtraPart("-shouldFix", "truth", "Only issues with a consensus view that they should be fixed");
            this.addOption("-class", "pattern", "allow only bugs whose primary class name matches this pattern");
            this.addOption("-calls", "pattern", "allow only bugs that involve a call to a method that matches this pattern (matches with method class or name)");
            this.addOption("-bugPattern", "pattern", "allow only bugs whose type matches this pattern");
            this.addOption("-category", "category", "allow only warnings with a category that starts with this string");
            this.addSwitch("-dontUpdateStats", "used when withSource is specified to only update bugs, not the class and package stats");
            this.addOption("-hashes", "hash file", "only bugs with instance hashes contained in the hash file");
        }

        public static long getVersionNum(BugCollection collection, String val, boolean roundToLaterVersion) {
            if (val == null) {
                return -1L;
            }
            HashMap<String, AppVersion> versions = new HashMap<String, AppVersion>();
            TreeMap<Long, AppVersion> timeStamps = new TreeMap<Long, AppVersion>();
            Iterator<AppVersion> i = collection.appVersionIterator();
            while (i.hasNext()) {
                AppVersion v = i.next();
                versions.put(v.getReleaseName(), v);
                timeStamps.put(v.getTimestamp(), v);
            }
            AppVersion v = collection.getCurrentAppVersion();
            versions.put(v.getReleaseName(), v);
            timeStamps.put(v.getTimestamp(), v);
            return FilterCommandLine.getVersionNum(versions, timeStamps, val, roundToLaterVersion, v.getSequenceNumber());
        }

        public static long getVersionNum(Map<String, AppVersion> versions, SortedMap<Long, AppVersion> timeStamps, String val, boolean roundToLaterVersion, long currentSeqNum) {
            if (val == null) {
                return -1L;
            }
            long numVersions = currentSeqNum + 1L;
            if ("last".equals(val) || "lastVersion".equals(val)) {
                return numVersions - 1L;
            }
            AppVersion v = versions.get(val);
            if (v != null) {
                return v.getSequenceNumber();
            }
            try {
                long time = 0L;
                time = val.endsWith("daysAgo") ? System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(val.substring(0, val.length() - 7)) : Date.parse(val);
                return FilterCommandLine.getAppropriateSeq(timeStamps, time, roundToLaterVersion);
            }
            catch (Exception e) {
                try {
                    long version = Long.parseLong(val);
                    if (version < 0L) {
                        version = numVersions + version;
                    }
                    return version;
                }
                catch (NumberFormatException e1) {
                    throw new IllegalArgumentException("Could not interpret version specification of '" + val + "'");
                }
            }
        }

        private static long getAppropriateSeq(SortedMap<Long, AppVersion> timeStamps, long when, boolean roundToLaterVersion) {
            if (roundToLaterVersion) {
                SortedMap<Long, AppVersion> geq = timeStamps.tailMap(when);
                if (geq.isEmpty()) {
                    return Long.MAX_VALUE;
                }
                return ((AppVersion)geq.get(geq.firstKey())).getSequenceNumber();
            }
            SortedMap<Long, AppVersion> leq = timeStamps.headMap(when);
            if (leq.isEmpty()) {
                return Long.MIN_VALUE;
            }
            return ((AppVersion)leq.get(leq.lastKey())).getSequenceNumber();
        }

        void adjustFilter(Project project, BugCollection collection) {
            long fixed;
            this.suppressionFilter = project.getSuppressionFilter();
            this.first = FilterCommandLine.getVersionNum(collection, this.firstAsString, true);
            this.maybeMutated = FilterCommandLine.getVersionNum(collection, this.maybeMutatedAsString, true);
            this.last = FilterCommandLine.getVersionNum(collection, this.lastAsString, true);
            this.before = FilterCommandLine.getVersionNum(collection, this.beforeAsString, true);
            this.after = FilterCommandLine.getVersionNum(collection, this.afterAsString, false);
            this.present = FilterCommandLine.getVersionNum(collection, this.presentAsString, true);
            this.absent = FilterCommandLine.getVersionNum(collection, this.absentAsString, true);
            if (this.sloppyUniqueSpecified) {
                this.uniqueSloppy = new TreeSet<BugInstance>(new SloppyBugComparator());
            }
            if ((fixed = FilterCommandLine.getVersionNum(collection, this.fixedAsString, true)) >= 0L) {
                this.last = fixed - 1L;
            }
        }

        boolean accept(BugCollection collection, BugInstance bug) {
            boolean result = this.evaluate(collection, bug);
            if (this.not) {
                return !result;
            }
            return result;
        }

        boolean evaluate(BugCollection collection, BugInstance bug) {
            boolean unique;
            for (Matcher m : this.includeFilter) {
                if (m.match(bug)) continue;
                return false;
            }
            for (Matcher m : this.excludeFilter) {
                if (!m.match(bug)) continue;
                return false;
            }
            if (this.excludedInstanceHashes.contains(bug.getInstanceHash())) {
                return false;
            }
            if (bug.getPriority() > this.priority) {
                return false;
            }
            if (this.firstAsString != null && bug.getFirstVersion() != this.first) {
                return false;
            }
            if (this.afterAsString != null && bug.getFirstVersion() <= this.after) {
                return false;
            }
            if (this.beforeAsString != null && bug.getFirstVersion() >= this.before) {
                return false;
            }
            if (this.hashesFromFile != null && !this.hashesFromFile.contains(bug.getInstanceHash())) {
                return false;
            }
            long lastSeen = bug.getLastVersion();
            if (lastSeen < 0L) {
                lastSeen = collection.getSequenceNumber();
            }
            long thisDuration = lastSeen - bug.getFirstVersion();
            if (this.duration > 0 && thisDuration > (long)this.duration) {
                return false;
            }
            if (!(this.lastAsString == null && this.fixedAsString == null || this.last >= 0L && bug.getLastVersion() == this.last)) {
                return false;
            }
            if (this.presentAsString != null && !this.bugLiveAt(bug, this.present)) {
                return false;
            }
            if (this.absentAsString != null && this.bugLiveAt(bug, this.absent)) {
                return false;
            }
            if (this.hasFieldSpecified && this.hasField != (bug.getPrimaryField() != null)) {
                return false;
            }
            if (this.hasLocalSpecified && this.hasLocal != (bug.getPrimaryLocalVariableAnnotation() != null)) {
                return false;
            }
            if (this.maxRank < Integer.MAX_VALUE && BugRanker.findRank(bug) > this.maxRank) {
                return false;
            }
            if (this.activeSpecified && this.active == bug.isDead()) {
                return false;
            }
            if (this.removedByChangeSpecified && bug.isRemovedByChangeOfPersistingClass() != this.removedByChange) {
                return false;
            }
            if (this.introducedByChangeSpecified && bug.isIntroducedByChangeOfExistingClass() != this.introducedByChange) {
                return false;
            }
            if (this.newCodeSpecified && this.newCode != (!bug.isIntroducedByChangeOfExistingClass() && bug.getFirstVersion() != 0L)) {
                return false;
            }
            if (this.removedCodeSpecified && this.removedCode != (!bug.isRemovedByChangeOfPersistingClass() && bug.isDead())) {
                return false;
            }
            if (this.bugPattern != null && !this.bugPattern.matcher(bug.getType()).find()) {
                return false;
            }
            if (this.classPattern != null && !this.classPattern.matcher(bug.getPrimaryClass().getClassName()).find()) {
                return false;
            }
            if (this.callsPattern != null) {
                MethodAnnotation m = bug.getAnnotationWithRole(MethodAnnotation.class, "METHOD_CALLED");
                if (m == null) {
                    return false;
                }
                if (!this.callsPattern.matcher(m.getClassName()).find() && !this.callsPattern.matcher(m.getMethodName()).find()) {
                    return false;
                }
            }
            if (!(this.maybeMutatedAsString == null || this.atMutationPoint(bug) && this.mutationPoints.contains(this.getBugLocation(bug)))) {
                return false;
            }
            BugPattern thisBugPattern = bug.getBugPattern();
            if (!this.categoryKey.isEmpty() && thisBugPattern != null && !this.categoryKey.contains(thisBugPattern.getCategory())) {
                return false;
            }
            if (this.hashChangedSpecified && bug.isInstanceHashConsistent() == this.hashChanged) {
                return false;
            }
            if (this.applySuppressionSpecified && this.applySuppression && this.suppressionFilter.match(bug)) {
                return false;
            }
            SourceLineAnnotation primarySourceLineAnnotation = bug.getPrimarySourceLineAnnotation();
            if (this.knownSourceSpecified && primarySourceLineAnnotation.isUnknown() == this.knownSource) {
                return false;
            }
            if (this.withSourceSpecified && sourceSearcher.findSource(primarySourceLineAnnotation) != this.withSource) {
                return false;
            }
            return !this.sloppyUniqueSpecified || (unique = this.uniqueSloppy.add(bug)) == this.sloppyUnique;
        }

        private void addCategoryKey(String argument) {
            DetectorFactoryCollection i18n = DetectorFactoryCollection.instance();
            block0: for (String x : argument.split("[,|]")) {
                for (BugCategory category : i18n.getBugCategoryObjects()) {
                    if (!category.getAbbrev().equals(x) && !category.getCategory().equals(x)) continue;
                    this.categoryKey.add(category.getCategory());
                    continue block0;
                }
            }
        }

        private boolean bugLiveAt(BugInstance bug, long now) {
            if (now < bug.getFirstVersion()) {
                return false;
            }
            return !bug.isDead() || bug.getLastVersion() >= now;
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            option = option.substring(1);
            if (optionExtraPart.length() == 0) {
                this.setField(option, true);
            } else {
                this.setField(option, Boolean.parseBoolean(optionExtraPart));
            }
            this.setField(option + "Specified", true);
        }

        private void setField(String fieldName, boolean value) {
            try {
                Field f = FilterCommandLine.class.getField(fieldName);
                f.setBoolean(this, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            block15: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                block24: {
                                                    block23: {
                                                        block22: {
                                                            block21: {
                                                                block20: {
                                                                    block19: {
                                                                        block18: {
                                                                            block17: {
                                                                                block16: {
                                                                                    block14: {
                                                                                        if (!"-priority".equals(option) && !"-confidence".equals(option)) break block14;
                                                                                        this.priority = Filter.parsePriority(argument);
                                                                                        break block15;
                                                                                    }
                                                                                    if (!"-maxRank".equals(option)) break block16;
                                                                                    this.maxRank = Integer.parseInt(argument);
                                                                                    break block15;
                                                                                }
                                                                                if (!"-first".equals(option)) break block17;
                                                                                this.firstAsString = argument;
                                                                                break block15;
                                                                            }
                                                                            if (!"-maybeMutated".equals(option)) break block18;
                                                                            this.maybeMutatedAsString = argument;
                                                                            break block15;
                                                                        }
                                                                        if (!"-last".equals(option)) break block19;
                                                                        this.lastAsString = argument;
                                                                        break block15;
                                                                    }
                                                                    if (!"-trimToVersion".equals(option)) break block20;
                                                                    this.trimToVersionAsString = argument;
                                                                    break block15;
                                                                }
                                                                if (!"-maxDuration".equals(option)) break block21;
                                                                this.duration = Integer.parseInt(argument);
                                                                break block15;
                                                            }
                                                            if (!"-fixed".equals(option)) break block22;
                                                            this.fixedAsString = argument;
                                                            break block15;
                                                        }
                                                        if (!"-after".equals(option)) break block23;
                                                        this.afterAsString = argument;
                                                        break block15;
                                                    }
                                                    if (!"-before".equals(option)) break block24;
                                                    this.beforeAsString = argument;
                                                    break block15;
                                                }
                                                if (!"-present".equals(option)) break block25;
                                                this.presentAsString = argument;
                                                break block15;
                                            }
                                            if (!"-absent".equals(option)) break block26;
                                            this.absentAsString = argument;
                                            break block15;
                                        }
                                        if (!"-category".equals(option)) break block27;
                                        this.addCategoryKey(argument);
                                        break block15;
                                    }
                                    if (!"-class".equals(option)) break block28;
                                    this.classPattern = Pattern.compile(argument.replace(',', '|'));
                                    break block15;
                                }
                                if (!"-calls".equals(option)) break block29;
                                this.callsPattern = Pattern.compile(argument.replace(',', '|'));
                                break block15;
                            }
                            if (!"-bugPattern".equals(option)) break block30;
                            this.bugPattern = Pattern.compile(argument);
                            break block15;
                        }
                        if (!"-annotation".equals(option)) break block31;
                        this.annotation = argument;
                        break block15;
                    }
                    if ("-excludeBugs".equals(option)) {
                        try {
                            ExcludingHashesBugReporter.addToExcludedInstanceHashes(this.excludedInstanceHashes, argument);
                        }
                        catch (DocumentException e) {
                            throw new IllegalArgumentException("Error processing include file: " + argument, e);
                        }
                    }
                    if ("-include".equals(option)) {
                        try {
                            this.includeFilter.add(new edu.umd.cs.findbugs.filter.Filter(argument));
                        }
                        catch (FilterException e) {
                            throw new IllegalArgumentException("Error processing include file: " + argument, e);
                        }
                    }
                    if ("-exclude".equals(option)) {
                        try {
                            this.excludeFilter.add(new edu.umd.cs.findbugs.filter.Filter(argument));
                        }
                        catch (FilterException e) {
                            throw new IllegalArgumentException("Error processing include file: " + argument, e);
                        }
                    }
                    if (!"-hashes".equals(option)) break block32;
                    this.hashesFromFile = new HashSet();
                    BufferedReader in = null;
                    try {
                        String h;
                        in = new BufferedReader(UTF8.fileReader(argument));
                        while ((h = in.readLine()) != null) {
                            this.hashesFromFile.add(h);
                        }
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException("Error reading hashes from " + argument, e);
                        }
                        catch (Throwable throwable) {
                            Util.closeSilently(in);
                            throw throwable;
                        }
                    }
                    Util.closeSilently(in);
                    break block15;
                }
                throw new IllegalArgumentException("can't handle command line argument of " + option);
            }
        }

        public void getReady(SortedBugCollection origCollection) {
            if (this.maybeMutatedAsString != null) {
                HashSet<String> addedIssues = new HashSet<String>();
                HashSet<String> removedIssues = new HashSet<String>();
                for (BugInstance b : origCollection) {
                    if (b.getFirstVersion() == this.maybeMutated) {
                        addedIssues.add(this.getBugLocation(b));
                        continue;
                    }
                    if (b.getLastVersion() != this.maybeMutated - 1L) continue;
                    removedIssues.add(this.getBugLocation(b));
                }
                addedIssues.remove(null);
                addedIssues.retainAll(removedIssues);
                this.mutationPoints = addedIssues;
            }
        }

        private boolean atMutationPoint(BugInstance b) {
            return b.getFirstVersion() == this.maybeMutated || b.getLastVersion() == this.maybeMutated - 1L;
        }

        private String getBugLocation(BugInstance b) {
            MethodAnnotation m = b.getPrimaryMethod();
            FieldAnnotation f = b.getPrimaryField();
            String point = m != null ? m.toString() : (f != null ? f.toString() : null);
            return point;
        }
    }
}

