/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.DiscoverSourceDirectories;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ba.ClassNotFoundExceptionParser;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IErrorLogger;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.gui2.NewProjectWizard;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SourceDirectoryWizard
extends JDialog {
    private static final int MIN_STEP = 1;
    private static final int MAX_STEP = 2;
    private JFileChooser chooser;
    private final Project project;
    private final NewProjectWizard parentGUI;
    private DefaultListModel<String> foundModel;
    private DefaultListModel<String> progressModel;
    private JList<String> jList2;
    public Thread discover;
    private JButton browseButton;
    private JLabel card1Explanation1Label;
    private JLabel card1Explanation2Label;
    private JLabel card1Explanation3Label;
    private JLabel card1TitleLabel;
    private JPanel contentPanel;
    private JLabel errorMessageLabel;
    private JButton finshButton;
    private JPanel firstPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList<String> jList1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton nextButton;
    private JButton previousButton;
    private JPanel secondPanel;
    private JTextField sourceRootBox;
    private JLabel sourceRootLabel;
    private JLabel srcFileIconLabel;
    private int step;

    public SourceDirectoryWizard(Frame parent, boolean modal, Project project, NewProjectWizard parentGUI) {
        super(parent, modal);
        this.parentGUI = parentGUI;
        this.project = project;
        this.initComponents();
        this.setStep(1);
    }

    private void initComponents() {
        this.foundModel = new DefaultListModel();
        this.progressModel = new DefaultListModel();
        this.contentPanel = new JPanel();
        this.secondPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jList2 = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.firstPanel = new JPanel();
        this.sourceRootLabel = new JLabel();
        this.sourceRootBox = new JTextField();
        this.srcFileIconLabel = new JLabel();
        this.card1TitleLabel = new JLabel();
        this.chooser = new JFileChooser();
        this.browseButton = new JButton();
        this.card1Explanation1Label = new JLabel();
        this.card1Explanation2Label = new JLabel();
        this.card1Explanation3Label = new JLabel();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.finshButton = new JButton();
        this.errorMessageLabel = new JLabel();
        Dimension d = new Dimension(600, 425);
        this.setPreferredSize(d);
        this.setDefaultCloseOperation(2);
        this.setTitle("SpotBugs Source Directory Configuration Wizard");
        this.getContentPane().setLayout(null);
        this.jList2.setModel(this.progressModel);
        this.contentPanel.setLayout(new CardLayout());
        this.secondPanel.setLayout(null);
        this.jScrollPane1.setViewportView(this.jList1);
        this.secondPanel.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(250, 50, 258, 130);
        this.jLabel1.setFont(new Font("SansSerif", 0, 14));
        this.jLabel1.setText("Source directories found:");
        this.secondPanel.add(this.jLabel1);
        this.jLabel1.setBounds(250, 30, 173, 17);
        this.jLabel2.setFont(new Font("SansSerif", 0, 14));
        this.jLabel2.setText("Click Finish to accept this");
        this.secondPanel.add(this.jLabel2);
        this.jLabel2.setBounds(40, 90, 173, 17);
        this.jLabel3.setFont(new Font("SansSerif", 0, 14));
        this.jLabel3.setText("list of source directories");
        this.secondPanel.add(this.jLabel3);
        this.jLabel3.setBounds(40, 110, 165, 17);
        this.contentPanel.add((Component)this.secondPanel, "card2");
        this.jScrollPane2.setViewportView(this.jList2);
        this.firstPanel.add(this.jScrollPane2);
        this.jScrollPane2.setBounds(200, 250, 250, 75);
        this.firstPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.firstPanel.setLayout(null);
        this.sourceRootLabel.setText("Top-level source directory:");
        this.firstPanel.add(this.sourceRootLabel);
        this.sourceRootLabel.setBounds(30, 220, 168, 17);
        this.firstPanel.add(this.sourceRootBox);
        this.sourceRootBox.setBounds(200, 210, 250, 29);
        this.srcFileIconLabel.setIcon(new ImageIcon("/usr/share/icons/default.kde/128x128/mimetypes/source_java.png"));
        this.firstPanel.add(this.srcFileIconLabel);
        this.srcFileIconLabel.setBounds(50, 80, 128, 128);
        this.card1TitleLabel.setFont(new Font("Dialog", 1, 24));
        this.card1TitleLabel.setText("Where are your source files?");
        this.firstPanel.add(this.card1TitleLabel);
        this.card1TitleLabel.setBounds(150, 20, 353, 29);
        this.browseButton.setText("Browse...");
        this.firstPanel.add(this.browseButton);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceDirectoryWizard.this.chooser.setFileSelectionMode(1);
                SourceDirectoryWizard.this.chooser.setMultiSelectionEnabled(true);
                SourceDirectoryWizard.this.chooser.setApproveButtonText("Choose");
                SourceDirectoryWizard.this.chooser.setDialogTitle("Choose the directory");
                if (SourceDirectoryWizard.this.chooser.showOpenDialog(SourceDirectoryWizard.this) == 0) {
                    File[] selectedFiles;
                    for (File selectedFile : selectedFiles = SourceDirectoryWizard.this.chooser.getSelectedFiles()) {
                        SourceDirectoryWizard.this.sourceRootBox.setText(selectedFile.getAbsolutePath());
                    }
                    SourceDirectoryWizard.this.nextButton.setEnabled(!"".equals(SourceDirectoryWizard.this.sourceRootBox.getText()));
                }
            }
        });
        this.browseButton.setBounds(450, 210, 100, 28);
        this.card1Explanation1Label.setFont(new Font("SansSerif", 0, 14));
        this.card1Explanation1Label.setText("Enter the top-level directory");
        this.firstPanel.add(this.card1Explanation1Label);
        this.card1Explanation1Label.setBounds(230, 80, 193, 17);
        this.card1Explanation2Label.setFont(new Font("SansSerif", 0, 14));
        this.card1Explanation2Label.setText("containing your application's");
        this.firstPanel.add(this.card1Explanation2Label);
        this.card1Explanation2Label.setBounds(230, 100, 198, 17);
        this.card1Explanation3Label.setFont(new Font("SansSerif", 0, 14));
        this.card1Explanation3Label.setText("source files.");
        this.firstPanel.add(this.card1Explanation3Label);
        this.card1Explanation3Label.setBounds(230, 120, 82, 17);
        this.contentPanel.add((Component)this.firstPanel, "card1");
        this.getContentPane().add(this.contentPanel);
        this.contentPanel.setBounds(0, 0, 750, 300);
        this.previousButton.setText("<< Previous");
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceDirectoryWizard.this.previousButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.previousButton);
        this.previousButton.setBounds(150, 350, 100, 29);
        this.nextButton.setText("Next >>");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceDirectoryWizard.this.nextButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.nextButton);
        this.nextButton.setBounds(250, 350, 100, 29);
        this.finshButton.setText("Finish");
        this.finshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceDirectoryWizard.this.finshButtonActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.finshButton);
        this.finshButton.setBounds(350, 350, 100, 29);
        this.errorMessageLabel.setFont(new Font("SansSerif", 1, 14));
        this.errorMessageLabel.setForeground(new Color(255, 0, 0));
        this.getContentPane().add(this.errorMessageLabel);
        this.errorMessageLabel.setBounds(0, 300, 500, 20);
        this.pack();
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (this.step > 1) {
            this.setStep(this.step - 1);
        }
        this.progressModel.removeAllElements();
        this.foundModel.removeAllElements();
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.discover = new Thread(){

            @Override
            public void run() {
                IErrorLogger errorLogger = new IErrorLogger(){

                    @Override
                    public void reportMissingClass(ClassNotFoundException ex) {
                        String className = ClassNotFoundExceptionParser.getMissingClassName(ex);
                        if (className != null) {
                            this.logError("Missing class: " + className);
                        } else {
                            this.logError("Missing class: " + ex);
                        }
                    }

                    @Override
                    public void reportMissingClass(ClassDescriptor classDescriptor) {
                        this.logError("Missing class: " + classDescriptor.toDottedClassName());
                    }

                    @Override
                    public void logError(String message) {
                        System.err.println("Error: " + message);
                    }

                    @Override
                    public void logError(String message, Throwable e) {
                        this.logError(message + ": " + e.getMessage());
                    }

                    @Override
                    public void reportSkippedAnalysis(MethodDescriptor method) {
                        this.logError("Skipped analysis of method " + method.toString());
                    }
                };
                DiscoverSourceDirectories.Progress progress = new DiscoverSourceDirectories.Progress(){

                    @Override
                    public void startRecursiveDirectorySearch() {
                        SourceDirectoryWizard.this.progressModel.addElement("Scanning directories...");
                    }

                    @Override
                    public void doneRecursiveDirectorySearch() {
                    }

                    @Override
                    public void startScanningArchives(int numArchivesToScan) {
                        SourceDirectoryWizard.this.progressModel.addElement("Scanning " + numArchivesToScan + " archives..");
                    }

                    @Override
                    public void doneScanningArchives() {
                    }

                    @Override
                    public void startScanningClasses(int numClassesToScan) {
                        SourceDirectoryWizard.this.progressModel.addElement("Scanning " + numClassesToScan + " classes...");
                    }

                    @Override
                    public void finishClass() {
                    }

                    @Override
                    public void doneScanningClasses() {
                    }

                    @Override
                    public void finishArchive() {
                    }

                    @Override
                    public void startArchive(String name) {
                    }
                };
                DiscoverSourceDirectories discoverSourceDirectories = new DiscoverSourceDirectories();
                discoverSourceDirectories.setProject(SourceDirectoryWizard.this.project);
                discoverSourceDirectories.setRootSourceDirectory(SourceDirectoryWizard.this.sourceRootBox.getText());
                discoverSourceDirectories.setErrorLogger(errorLogger);
                discoverSourceDirectories.setProgress(progress);
                try {
                    discoverSourceDirectories.execute();
                }
                catch (CheckedAnalysisException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                SourceDirectoryWizard.this.jList1.setModel(SourceDirectoryWizard.this.foundModel);
                for (String srcDir : discoverSourceDirectories.getDiscoveredSourceDirectoryList()) {
                    SourceDirectoryWizard.this.foundModel.addElement(srcDir);
                }
                if (SourceDirectoryWizard.this.step < 2) {
                    SourceDirectoryWizard.this.setStep(SourceDirectoryWizard.this.step + 1);
                }
            }
        };
        this.discover.start();
    }

    private void finshButtonActionPerformed(ActionEvent evt) {
        if (this.parentGUI != null) {
            this.parentGUI.setSourceDirecs(this.foundModel);
        }
        if (this.discover != null && this.discover.isAlive()) {
            this.discover.stop();
        }
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SourceDirectoryWizard dialog = new SourceDirectoryWizard((Frame)new JFrame(), true, new Project(), null);
                dialog.setVisible(true);
            }
        });
    }

    private void setStep(int step) {
        if (step < 1 || step > 2) {
            throw new IllegalArgumentException("Invalid step " + step);
        }
        this.step = step;
        this.previousButton.setEnabled(step != 1);
        this.nextButton.setEnabled(step != 2 && !"".equals(this.sourceRootBox.getText()));
        CardLayout cards = (CardLayout)this.contentPanel.getLayout();
        cards.show(this.contentPanel, "card" + step);
    }
}

