/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CheckBoxList;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SorterTableColumnModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class SorterDialog
extends FBDialog {
    private JTableHeader preview;
    private final ArrayList<SortableCheckBox> checkBoxSortList = new ArrayList();
    JButton sortApply;

    public static SorterDialog getInstance() {
        return new SorterDialog();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((SorterTableColumnModel)this.preview.getColumnModel()).createFrom(MainFrame.getInstance().getSorter());
            this.setSorterCheckBoxes();
        }
    }

    private SorterDialog() {
        this.setTitle("Group Bugs By...");
        this.add(this.createSorterPane());
        this.pack();
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.preview.setColumnModel(new SorterTableColumnModel(MainFrame.getInstance().getSorter().getOrder()));
    }

    private JPanel createSorterPane() {
        JPanel insidePanel = new JPanel();
        insidePanel.setLayout(new GridBagLayout());
        this.preview = new JTableHeader();
        Sortables[] sortables = MainFrame.getInstance().getAvailableSortables();
        this.preview.setColumnModel(new SorterTableColumnModel(sortables));
        for (Sortables s : sortables) {
            if (s == Sortables.DIVIDER) continue;
            this.checkBoxSortList.add(new SortableCheckBox(s));
        }
        this.setSorterCheckBoxes();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(2, 5, 2, 5);
        insidePanel.add((Component)new JLabel("<html><h2>1. Choose bug properties"), gbc);
        insidePanel.add(new CheckBoxList<JCheckBox>(this.checkBoxSortList.toArray(new JCheckBox[this.checkBoxSortList.size()])), gbc);
        JTable t = new JTable(new DefaultTableModel(0, sortables.length));
        t.setTableHeader(this.preview);
        this.preview.setCursor(Cursor.getPredefinedCursor(10));
        insidePanel.add((Component)new JLabel("<html><h2>2. Drag and drop to change grouping priority"), gbc);
        insidePanel.add((Component)this.createAppropriatelySizedScrollPane(t), gbc);
        this.sortApply = new JButton(L10N.getLocalString("dlg.apply_btn", "Apply"));
        this.sortApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.getInstance().getSorter().createFrom((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel());
                ((BugTreeModel)MainFrame.getInstance().getTree().getModel()).checkSorter();
                SorterDialog.this.dispose();
            }
        });
        gbc.fill = 0;
        insidePanel.add((Component)this.sortApply, gbc);
        JPanel sorter = new JPanel();
        sorter.setLayout(new BorderLayout());
        sorter.add((Component)new JScrollPane(insidePanel), "Center");
        return sorter;
    }

    private JScrollPane createAppropriatelySizedScrollPane(JTable t) {
        JScrollPane sp = new JScrollPane(t);
        int num = (int)((double)Driver.getFontSize() * 1.2);
        sp.setPreferredSize(new Dimension(670, 10 + num));
        return sp;
    }

    private void setSorterCheckBoxes() {
        SorterTableColumnModel sorter = MainFrame.getInstance().getSorter();
        for (SortableCheckBox c : this.checkBoxSortList) {
            c.setSelected(sorter.isShown(c.sortable));
        }
    }

    void freeze() {
        this.sortApply.setEnabled(false);
    }

    void thaw() {
        this.sortApply.setEnabled(true);
    }

    class SortableCheckBox
    extends JCheckBox {
        final Sortables sortable;

        SortableCheckBox(Sortables s) {
            super(s == Sortables.DIVIDER ? L10N.getLocalString("sort.divider", "[divider]") : s.toString());
            this.sortable = s;
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ((SorterTableColumnModel)SorterDialog.this.preview.getColumnModel()).setVisible(SortableCheckBox.this.sortable, SortableCheckBox.this.isSelected());
                }
            });
        }
    }
}

