/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.CheckBoxList;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.NewFilterFrame;
import edu.umd.cs.findbugs.gui2.WideComboBox;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;

public class PreferencesFrame
extends FBDialog {
    private static final Logger LOGGER = Logger.getLogger(PreferencesFrame.class.getName());
    private static final int TAB_MIN = 1;
    private static final int TAB_MAX = 20;
    private static final int FONT_MIN = 10;
    private static final int FONT_MAX = 99;
    private static PreferencesFrame instance;
    private final CheckBoxList<MatchBox> filterCheckBoxList = new CheckBoxList();
    private JTextField tabTextField;
    private JTextField fontTextField;
    private JTextField packagePrefixLengthTextField;
    private final Map<Plugin, EnabledSettings> pluginEnabledStatus = new HashMap<Plugin, EnabledSettings>();
    private JPanel pluginPanelCenter;
    private boolean pluginsAdded = false;
    private final JPanel filterPane;
    private final JTabbedPane mainTabPane;

    public static PreferencesFrame getInstance() {
        if (instance == null) {
            instance = new PreferencesFrame();
        }
        return instance;
    }

    public void showFilterPane() {
        this.mainTabPane.setSelectedComponent(this.filterPane);
    }

    private PreferencesFrame() {
        this.setTitle(L10N.getLocalString("dlg.fil_sup_ttl", "Preferences"));
        this.setModal(true);
        this.mainTabPane = new JTabbedPane();
        this.mainTabPane.add("General", this.createPropertiesPane());
        this.filterPane = this.createFilterPane();
        this.mainTabPane.add(L10N.getLocalString("pref.filters", "Filters"), this.filterPane);
        this.mainTabPane.add("Plugins", this.createPluginPane());
        MainFrame.getInstance().updateStatusBar();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 0));
        top.add(Box.createHorizontalStrut(5));
        top.add(this.mainTabPane);
        top.add(Box.createHorizontalStrut(5));
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(new JButton(new AbstractAction(L10N.getLocalString("pref.close", "Close")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.handleWindowClose();
                PreferencesFrame.this.setVisible(false);
            }
        }));
        bottom.add(Box.createHorizontalStrut(5));
        this.add(Box.createVerticalStrut(5));
        this.add(top);
        this.add(Box.createVerticalStrut(5));
        this.add(bottom);
        this.add(Box.createVerticalStrut(5));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PreferencesFrame.this.resetPropertiesPane();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PreferencesFrame.this.handleWindowClose();
            }
        });
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    private void handleWindowClose() {
        TreeModel bt = MainFrame.getInstance().getTree().getModel();
        if (bt instanceof BugTreeModel) {
            ((BugTreeModel)bt).checkSorter();
        }
        Project project = this.getCurrentProject();
        boolean changed = this.pluginsAdded;
        this.pluginsAdded = false;
        ArrayList<String> enabledPlugins = new ArrayList<String>();
        ArrayList<String> disabledPlugins = new ArrayList<String>();
        for (Map.Entry<Plugin, EnabledSettings> entry : this.pluginEnabledStatus.entrySet()) {
            Plugin plugin = entry.getKey();
            EnabledSettings enabled = entry.getValue();
            if (project != null) {
                Boolean newSetting = enabled.project;
                Boolean existingSetting = project.getPluginStatus(plugin);
                boolean sameSettings = Objects.equals(existingSetting, newSetting);
                if (!sameSettings) {
                    project.setPluginStatusTrinary(plugin.getPluginId(), newSetting);
                    changed = true;
                }
            }
            if (enabled.global) {
                enabledPlugins.add(plugin.getPluginId());
            } else {
                disabledPlugins.add(plugin.getPluginId());
            }
            if (plugin.isGloballyEnabled() == enabled.global) continue;
            plugin.setGloballyEnabled(enabled.global);
            changed = true;
        }
        if (changed && project != null) {
            MainFrame.getInstance().updateBugTree();
            MainFrame.getInstance().setProjectChanged(true);
        }
        if (project == null) {
            GUISaveState.getInstance().setPluginsEnabled(enabledPlugins, disabledPlugins);
            GUISaveState.getInstance().save();
        }
    }

    private Project getCurrentProject() {
        BugCollection bugCollection = MainFrame.getInstance().getBugCollection();
        return bugCollection == null ? null : bugCollection.getProject();
    }

    private JPanel createPluginPane() {
        JPanel pluginPanel = new JPanel();
        pluginPanel.setLayout(new BorderLayout());
        this.pluginPanelCenter = new JPanel();
        pluginPanel.add((Component)this.pluginPanelCenter, "Center");
        this.pluginPanelCenter.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pluginPanelCenter.setLayout(new GridBagLayout());
        JButton addButton = new JButton("Install new plugin...");
        JPanel south = new JPanel();
        south.add(addButton);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.addChoosableFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "SpotBugs Plugin (*.jar)";
                    }

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        if (!f.canRead()) {
                            return false;
                        }
                        return f.getName().endsWith(".jar");
                    }
                });
                chooser.setDialogTitle("Select a SpotBugs plugin jar");
                int retvalue = chooser.showDialog(PreferencesFrame.this, "Install");
                if (retvalue == 0) {
                    File f = chooser.getSelectedFile();
                    try {
                        Plugin plugin = Plugin.loadCustomPlugin(f, PreferencesFrame.this.getCurrentProject());
                        GUISaveState guiSaveState = GUISaveState.getInstance();
                        URL url = f.toURI().toURL();
                        guiSaveState.addCustomPlugin(url);
                        guiSaveState.setPluginEnabled(plugin.getPluginId());
                        plugin.setGloballyEnabled(true);
                        guiSaveState.save();
                        PreferencesFrame.this.pluginsAdded = true;
                        PreferencesFrame.this.rebuildPluginCheckboxes();
                    }
                    catch (PluginException | MalformedURLException e1) {
                        LOGGER.log(Level.WARNING, "Could not load " + f.getPath(), e1);
                        JOptionPane.showMessageDialog(PreferencesFrame.this, "Could not load " + f.getPath() + "\n\n" + e1.getClass().getSimpleName() + ": " + e1.getMessage(), "Error Loading Plugin", 0);
                    }
                }
            }
        });
        pluginPanel.add((Component)south, "South");
        return pluginPanel;
    }

    EnabledSettings isEnabled(@CheckForNull Project project, Plugin plugin) {
        return new EnabledSettings(plugin.isGloballyEnabled(), project == null ? null : project.getPluginStatus(plugin));
    }

    private void rebuildPluginCheckboxes() {
        Project currentProject = this.getCurrentProject();
        this.pluginPanelCenter.removeAll();
        if (currentProject != null) {
            GridBagConstraints g = new GridBagConstraints();
            g.fill = 0;
            g.insets = new Insets(5, 5, 5, 5);
            g.gridy = 0;
            g.anchor = 10;
            g.gridx = 2;
            this.pluginPanelCenter.add((Component)new JLabel("Project Setting"), g);
        }
        Collection<Plugin> plugins = Plugin.getAllPlugins();
        int added = 0;
        for (final Plugin plugin : plugins) {
            boolean cannotDisable;
            if (plugin.isCorePlugin()) continue;
            String text = plugin.getShortDescription();
            String id = plugin.getPluginId();
            if (text == null) {
                text = id;
            }
            final URL url = plugin.getPluginLoader().getURL();
            String pluginUrlStr = url.toExternalForm();
            if ("file".equals(url.getProtocol())) {
                try {
                    pluginUrlStr = new File(URLDecoder.decode(url.getPath(), "UTF-8")).getAbsolutePath();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            text = String.format("<html>%s<br><font style='font-weight:normal;font-style:italic'>%s", text, pluginUrlStr);
            EnabledSettings enabled = this.isEnabled(currentProject, plugin);
            final JCheckBox checkGlobal = new JCheckBox(text, enabled.global);
            boolean bl = cannotDisable = plugin.isEnabledByDefault() && plugin.cannotDisable();
            if (cannotDisable) {
                if (!enabled.global) {
                    throw new IllegalStateException(plugin.getPluginId() + " is enabled by default and cannot be disabled, but is disabled");
                }
                checkGlobal.setEnabled(false);
            } else {
                checkGlobal.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            JPopupMenu menu = new JPopupMenu();
                            JMenuItem item = new JMenuItem("Uninstall " + plugin.getShortDescription() + "...");
                            item.addActionListener(new UninstallClickListener(plugin, url));
                            menu.add(item);
                            menu.show(checkGlobal, e.getX(), e.getY());
                        }
                    }
                });
                checkGlobal.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((EnabledSettings)((PreferencesFrame)PreferencesFrame.this).pluginEnabledStatus.get((Object)plugin)).global = checkGlobal.isSelected();
                    }
                });
            }
            checkGlobal.setVerticalTextPosition(1);
            String longText = plugin.getDetailedDescription();
            if (longText != null) {
                checkGlobal.setToolTipText("<html>" + longText + "</html>");
            }
            this.pluginEnabledStatus.put(plugin, enabled);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            gbc.insets = new Insets(0, 5, 0, 5);
            gbc.gridy = added + 1;
            gbc.anchor = 18;
            this.pluginPanelCenter.add((Component)checkGlobal, gbc);
            if (currentProject != null && !cannotDisable) {
                final WideComboBox<String> combo = new WideComboBox<String>(new String[]{"DEFAULT", "DISABLED", "ENABLED"});
                if (enabled.project == null) {
                    combo.setSelectedIndex(0);
                } else {
                    combo.setSelectedIndex(enabled.project != false ? 2 : 1);
                }
                combo.setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        if (index == -1) {
                            if (value.equals("DEFAULT")) {
                                value = "Default";
                            }
                            if (value.equals("DISABLED")) {
                                value = "Disabled";
                            }
                            if (value.equals("ENABLED")) {
                                value = "Enabled";
                            }
                        } else {
                            if (value.equals("DEFAULT")) {
                                value = "Default (use global setting)";
                            }
                            if (value.equals("DISABLED")) {
                                value = "Disabled for this project";
                            }
                            if (value.equals("ENABLED")) {
                                value = "Enabled for this project";
                            }
                        }
                        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    }
                });
                combo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Boolean[] array = new Boolean[]{null, false, true};
                        int i = combo.getSelectedIndex();
                        if (i < 0 || i > 2) {
                            return;
                        }
                        ((EnabledSettings)((PreferencesFrame)PreferencesFrame.this).pluginEnabledStatus.get((Object)plugin)).project = array[i];
                    }
                });
                gbc.gridx = 2;
                gbc.fill = 0;
                gbc.weightx = 0.0;
                this.pluginPanelCenter.add(combo, gbc);
            }
            ++added;
        }
        if (added == 0) {
            JLabel label = new JLabel("<html>No plugins are loaded.<br> Try installing <u><font color=blue>fb-contrib</font></u> - or write your own<br>plugin for your project's needs!");
            label.setCursor(Cursor.getPredefinedCursor(12));
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        LaunchBrowser.showDocument(new URL("https://sourceforge.net/projects/fb-contrib/"));
                    }
                    catch (MalformedURLException e1) {
                        throw new IllegalStateException(e1);
                    }
                }
            });
            label.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.pluginPanelCenter.add(label);
        }
        this.pack();
    }

    private void addField(JPanel p, GridBagConstraints c, int y, String lbl, JComponent field) {
        c.gridy = y;
        JLabel l = new JLabel(lbl, 11);
        l.setLabelFor(field);
        c.anchor = 22;
        c.gridx = 0;
        p.add((Component)l, c);
        c.anchor = 21;
        c.gridx = 1;
        p.add((Component)field, c);
    }

    private JPanel createPropertiesPane() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.ipady = 5;
        c.ipadx = 5;
        float currFS = Driver.getFontSize();
        this.tabTextField = new JTextField(Integer.toString(GUISaveState.getInstance().getTabSize()));
        this.tabTextField.setPreferredSize(new Dimension((int)(currFS * 4.0f), (int)(currFS * 2.0f)));
        this.addField(mainPanel, c, 0, "Tab size", this.tabTextField);
        this.fontTextField = new JTextField(Float.toString(GUISaveState.getInstance().getFontSize()));
        this.fontTextField.setPreferredSize(new Dimension((int)(currFS * 6.0f), (int)(currFS * 2.0f)));
        this.addField(mainPanel, c, 1, "Font size", this.fontTextField);
        this.packagePrefixLengthTextField = new JTextField(Integer.toString(GUISaveState.getInstance().getPackagePrefixSegments()));
        this.packagePrefixLengthTextField.setPreferredSize(new Dimension((int)(currFS * 4.0f), (int)(currFS * 2.0f)));
        this.addField(mainPanel, c, 2, "Package prefix length", this.packagePrefixLengthTextField);
        contentPanel.add((Component)mainPanel, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(new JButton(new AbstractAction("Apply"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.changeTabSize();
                PreferencesFrame.this.changeFontSize();
                PreferencesFrame.this.changePackagePrefixLength();
            }
        }));
        bottomPanel.add(new JButton(new AbstractAction("Reset"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesFrame.this.resetPropertiesPane();
            }
        }));
        contentPanel.add((Component)bottomPanel, "South");
        return contentPanel;
    }

    private void changeTabSize() {
        int tabSize;
        try {
            tabSize = Integer.decode(this.tabTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in tab size field.", "Tab Size Error", 1);
            return;
        }
        if (tabSize < 1 || tabSize > 20) {
            JOptionPane.showMessageDialog(instance, "Tab size exceedes range (1 - 20).", "Tab Size Excedes Range", 1);
            return;
        }
        if (tabSize != GUISaveState.getInstance().getTabSize()) {
            GUISaveState.getInstance().setTabSize(tabSize);
            MainFrame.getInstance().getSourceCodeDisplayer().clearCache();
            MainFrame.getInstance().syncBugInformation();
        }
    }

    private void changeFontSize() {
        float fontSize;
        try {
            fontSize = Float.parseFloat(this.fontTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in font size field.", "Font Size Error", 1);
            return;
        }
        if (fontSize < 10.0f || fontSize > 99.0f) {
            JOptionPane.showMessageDialog(instance, "Font size exceedes range (10 - 99).", "Font Size Exceedes Range", 1);
            return;
        }
        if (fontSize != GUISaveState.getInstance().getFontSize()) {
            GUISaveState.getInstance().setFontSize(fontSize);
            JOptionPane.showMessageDialog(instance, "To implement the new font size please restart SpotBugs.", "Changing Font", 1);
        }
    }

    private void changePackagePrefixLength() {
        int value;
        try {
            value = Integer.parseInt(this.packagePrefixLengthTextField.getText());
        }
        catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(instance, "Error in package prefix length field.", "Package Prefix Length Error", 1);
            return;
        }
        if (value < 1 || value > 12) {
            JOptionPane.showMessageDialog(instance, "package prefix length exceedes range (1 - 12).", "package prefix lengthe exceedes range", 1);
            return;
        }
        if (value != GUISaveState.getInstance().getPackagePrefixSegments()) {
            GUISaveState.getInstance().setPackagePrefixSegments(value);
            BugTreeModel bt = (BugTreeModel)MainFrame.getInstance().getTree().getModel();
            bt.needToRebuild();
            bt.checkSorter();
        }
    }

    private void resetPropertiesPane() {
        this.tabTextField.setText(Integer.toString(GUISaveState.getInstance().getTabSize()));
        this.fontTextField.setText(Float.toString(GUISaveState.getInstance().getFontSize()));
        this.rebuildPluginCheckboxes();
    }

    private JPanel createFilterPane() {
        JButton addButton = new JButton(L10N.getLocalString("dlg.add_dot_btn", "Add..."));
        JButton removeButton = new JButton(L10N.getLocalString("dlg.remove_btn", "Remove"));
        JButton removeAllButton = new JButton(L10N.getLocalString("dlg.remove_all_btn", "Remove All"));
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        filterPanel.add((Component)new JLabel("<HTML>These rules control which bugs are shown and which are hidden in this project"), gbc);
        gbc.gridheight = 4;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        filterPanel.add((Component)new JScrollPane(this.filterCheckBoxList), gbc);
        this.updateFilterPanel();
        gbc.gridheight = 1;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        filterPanel.add((Component)addButton, gbc);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewFilterFrame.open();
            }
        });
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        filterPanel.add((Component)removeButton, gbc);
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object[] selected = PreferencesFrame.this.filterCheckBoxList.getSelectedValues();
                if (selected.length == 0) {
                    return;
                }
                for (Object o : selected) {
                    MatchBox box = (MatchBox)o;
                    MainFrame.getInstance().getProject().getSuppressionFilter().removeChild(box.getMatcher());
                }
                FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
                MainFrame.getInstance().setProjectChanged(true);
                PreferencesFrame.this.updateFilterPanel();
            }
        });
        gbc.gridy = 3;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 0, 0, 0);
        filterPanel.add((Component)removeAllButton, gbc);
        removeAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean needsRebuild = false;
                Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
                if (!suppressionFilter.isEmpty()) {
                    needsRebuild = true;
                }
                suppressionFilter.clear();
                if (needsRebuild) {
                    FilterActivity.notifyListeners(FilterListener.Action.UNFILTERING, null);
                }
                MainFrame.getInstance().setProjectChanged(true);
                PreferencesFrame.this.updateFilterPanel();
            }
        });
        gbc.gridy = 4;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        filterPanel.add(Box.createGlue(), gbc);
        return filterPanel;
    }

    void updateFilterPanel() {
        ArrayList<MatchBox> boxes = new ArrayList<MatchBox>();
        final Filter f = MainFrame.getInstance().getProject().getSuppressionFilter();
        for (final Matcher m : f.getChildren()) {
            MatchBox box = new MatchBox(m.toString(), m);
            box.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    boolean wasSelected;
                    boolean isSelected = ((JCheckBox)evt.getSource()).isSelected();
                    if (isSelected == (wasSelected = f.isEnabled(m))) {
                        return;
                    }
                    f.setEnabled(m, isSelected);
                    PreferencesFrame.updateFilters(isSelected);
                }
            });
            box.setSelected(f.isEnabled(m));
            boxes.add(box);
        }
        this.filterCheckBoxList.setListData((MatchBox[])boxes.toArray(new MatchBox[boxes.size()]));
    }

    public static void updateFilters(boolean addedFilter) {
        FilterActivity.notifyListeners(addedFilter ? FilterListener.Action.FILTERING : FilterListener.Action.UNFILTERING, null);
        MainFrame.getInstance().setProjectChanged(true);
    }

    private class UninstallClickListener
    implements ActionListener {
        private final Plugin plugin;
        private final URL url;

        public UninstallClickListener(Plugin plugin, URL url) {
            this.plugin = plugin;
            this.url = url;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showOptionDialog(PreferencesFrame.this, "Are you sure you want to uninstall " + this.plugin.getShortDescription() + "?\n\nNo files will be deleted from your computer.", "", 0, 3, null, new Object[]{"Uninstall", "Cancel"}, "Cancel");
            if (result == 0) {
                if (!GUISaveState.getInstance().removeCustomPlugin(this.url)) {
                    if ("file".equals(this.url.getProtocol())) {
                        String path = this.url.toExternalForm();
                        try {
                            path = new File(URLDecoder.decode(this.url.getPath(), "UTF-8")).getAbsolutePath();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                        try {
                            StringSelection contents = new StringSelection(path);
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, contents);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        JOptionPane.showMessageDialog(PreferencesFrame.this, "The plugin could not be uninstalled automatically.\n\nYou can try to delete this plugin manually: \n" + path + "\n\n(This path has been copied to your clipboard)", "Error", 0);
                    } else {
                        JOptionPane.showMessageDialog(PreferencesFrame.this, "This plugin is not actually in the list of plugins...\nNot sure what to do...\n " + this.url.toExternalForm() + "\n\nPlugin URL's:\n" + GUISaveState.getInstance().getCustomPlugins(), "Error", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(PreferencesFrame.this, "Changes will take effect after you restart SpotBugs.");
                }
            }
        }
    }

    private static class MatchBox
    extends JCheckBox {
        Matcher m;

        MatchBox(String text, Matcher m) {
            super(text);
            this.m = m;
        }

        Matcher getMatcher() {
            return this.m;
        }
    }

    private static class EnabledSettings {
        public boolean global;
        public Boolean project;

        private EnabledSettings(boolean global, Boolean project) {
            this.global = global;
            this.project = project;
        }
    }
}

