/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class InfiniteRecursiveLoop
extends OpcodeStackDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private boolean seenTransferOfControl;
    private boolean seenReturn;
    private boolean seenStateChange;
    private int largestBranchTarget;
    private static final boolean DEBUG = SystemProperties.getBoolean("irl.debug");

    public InfiniteRecursiveLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        this.seenTransferOfControl = false;
        this.seenStateChange = false;
        this.seenReturn = false;
        this.largestBranchTarget = -1;
        if (DEBUG) {
            System.out.println();
            System.out.println(" --- " + this.getFullyQualifiedMethodName());
            System.out.println();
        }
    }

    @Override
    public void sawBranchTo(int target) {
        if (target == this.getNextPC()) {
            return;
        }
        if (this.largestBranchTarget < target) {
            this.largestBranchTarget = target;
        }
        this.seenTransferOfControl = true;
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item it1;
        int r1;
        OpcodeStack.Item it0;
        int r0;
        if (this.seenReturn && this.seenTransferOfControl && this.seenStateChange) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.stack);
            System.out.println(this.getPC() + " : " + Const.getOpcodeName(seen));
        }
        if ((seen == 182 || seen == 185) && "add".equals(this.getNameConstantOperand()) && "(Ljava/lang/Object;)Z".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() >= 2 && (r0 = (it0 = this.stack.getStackItem(0)).getRegisterNumber()) == (r1 = (it1 = this.stack.getStackItem(1)).getRegisterNumber()) && r0 > 0) {
            this.bugReporter.reportBug(new BugInstance(this, "IL_CONTAINER_ADDED_TO_ITSELF", 2).addClassAndMethod(this).addSourceLine(this));
        }
        if ((seen == 182 || seen == 183 || seen == 185 || seen == 184) && this.getNameConstantOperand().equals(this.getMethodName()) && this.getSigConstantOperand().equals(this.getMethodSig()) && seen == 184 == this.getMethod().isStatic() && seen == 183 == (this.getMethod().isPrivate() && !this.getMethod().isStatic() || "<init>".equals(this.getMethodName()))) {
            Type[] arguments = this.getMethod().getArgumentTypes();
            int parameters = arguments.length;
            if (!this.getMethod().isStatic()) {
                ++parameters;
            }
            XMethod xMethod = XFactory.createReferencedXMethod(this);
            if (DEBUG) {
                System.out.println("IL: Checking...");
                System.out.println(xMethod);
                System.out.println("vs. " + this.getClassName() + "." + this.getMethodName() + " : " + this.getMethodSig());
            }
            if (xMethod.getClassName().replace('.', '/').equals(this.getClassName()) || seen == 185) {
                boolean match3;
                boolean sameMethod;
                int firstParameter = 0;
                if ("<init>".equals(this.getMethodName())) {
                    firstParameter = 1;
                }
                boolean match1 = !this.seenStateChange;
                for (int i = firstParameter; match1 && i < parameters; ++i) {
                    OpcodeStack.Item it = this.stack.getStackItem(parameters - 1 - i);
                    if (it.isInitialParameter() && it.getRegisterNumber() == i) continue;
                    match1 = false;
                }
                boolean bl = sameMethod = seen == 184 || "<init>".equals(this.getNameConstantOperand());
                if (!sameMethod) {
                    if (DEBUG) {
                        System.out.println("Stack is " + this.stack);
                    }
                    OpcodeStack.Item p = this.stack.getStackItem(parameters - 1);
                    if (DEBUG) {
                        System.out.println("parameters = " + parameters + ", Item is " + p);
                    }
                    String sig = p.getSignature();
                    sameMethod = p.isInitialParameter() && p.getRegisterNumber() == 0 && sig.equals("L" + this.getClassName() + ";");
                }
                boolean match2 = sameMethod && !this.seenTransferOfControl;
                boolean bl2 = match3 = sameMethod && !this.seenReturn && this.largestBranchTarget < this.getPC();
                if (match1 || match2 || match3) {
                    if (DEBUG) {
                        System.out.println("IL: " + sameMethod + " " + match1 + " " + match2 + " " + match3);
                    }
                    this.bugReporter.reportBug(new BugInstance(this, "IL_INFINITE_RECURSIVE_LOOP", 1).addClassAndMethod(this).addSourceLine(this));
                }
            }
        }
        switch (seen) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                this.seenReturn = true;
                this.seenTransferOfControl = true;
                break;
            }
            case 191: {
                this.seenTransferOfControl = true;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 179: 
            case 181: {
                this.seenStateChange = true;
                break;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                if ("print".equals(this.getNameConstantOperand()) || "println".equals(this.getNameConstantOperand()) || "log".equals(this.getNameConstantOperand()) || "toString".equals(this.getNameConstantOperand())) break;
                this.seenStateChange = true;
                break;
            }
        }
    }
}

