/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.type.TypeAnalysis;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.detect.FindNoSideEffectMethods;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.POP;
import org.apache.bcel.generic.POP2;
import org.apache.bcel.generic.StoreInstruction;
import org.apache.bcel.generic.Type;

public class FindUselessObjects
implements Detector {
    private static final int MAX_ITERATIONS = 50;
    private final BugReporter reporter;
    private final FindNoSideEffectMethods.NoSideEffectMethodsDatabase noSideEffectMethods;

    public FindUselessObjects(BugReporter reporter) {
        this.reporter = reporter;
        this.noSideEffectMethods = Global.getAnalysisCache().getDatabase(FindNoSideEffectMethods.NoSideEffectMethodsDatabase.class);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        for (Method method : classContext.getMethodsInCallOrder()) {
            if (method.isAbstract() || method.isNative()) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (CheckedAnalysisException e) {
                this.reporter.logError("Error analyzing " + method + " (class: " + classContext.getJavaClass().getClassName() + ")", e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CheckedAnalysisException {
        boolean changed;
        LocalVariableTable lvt = method.getLocalVariableTable();
        UselessValuesContext context = new UselessValuesContext(classContext, method);
        context.initObservedValues();
        if (context.isEmpty()) {
            return;
        }
        context.enhanceViaMergeTree();
        int iteration = 0;
        do {
            changed = false;
            if (++iteration > 50) {
                AnalysisContext.logError("FindUselessObjects: " + classContext.getClassDescriptor().getDottedClassName() + "." + method.getName() + method.getSignature() + ": cannot converge after " + 50 + " iterations; method is skipped");
                return;
            }
            Iterator<GenLocation> iterator = context.genIterator();
            while (iterator.hasNext() && !context.isEmpty()) {
                GenLocation location = iterator.next();
                Instruction inst = location.getHandle().getInstruction();
                ValueNumberFrame before = location.frameBefore();
                if (!before.isValid()) continue;
                if (inst instanceof IINC) {
                    int index = ((IINC)inst).getIndex();
                    Set<ValueInfo> vals = context.getLiveVals((ValueNumber)before.getValue(index));
                    if (vals == null) continue;
                    changed |= context.propagateValues(vals, null, (ValueNumber)location.frameAfter().getValue(index));
                    continue;
                }
                int nconsumed = inst.consumeStack(context.cpg);
                if (nconsumed <= 0) continue;
                ValueNumber[] vns = new ValueNumber[nconsumed];
                before.getTopStackWords(vns);
                block12: for (int i = 0; i < nconsumed; ++i) {
                    ValueNumber vn = vns[i];
                    Set<ValueInfo> vals = context.getLiveVals(vn);
                    if (vals == null) continue;
                    switch (inst.getOpcode()) {
                        case 58: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: {
                            for (ValueInfo vi : vals) {
                                if (vi.var != null || vi.origValue != vn.getNumber()) continue;
                                int index = ((StoreInstruction)inst).getIndex();
                                LocalVariable lv = lvt == null ? null : lvt.getLocalVariable(index, location.getHandle().getNext().getPosition());
                                vi.var = lv == null ? "var$" + index : lv.getName();
                                vi.hasObjectOnlyCall = false;
                                changed = true;
                            }
                            continue block12;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 92: 
                        case 93: 
                        case 95: 
                        case 192: 
                        case 194: 
                        case 254: 
                        case 255: {
                            continue block12;
                        }
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 133: 
                        case 134: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 146: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 150: 
                        case 151: 
                        case 152: 
                        case 190: {
                            changed |= context.propagateValues(vals, null, (ValueNumber)location.frameAfter().getTopValue());
                            continue block12;
                        }
                        case 46: 
                        case 47: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 180: {
                            changed |= context.propagateValues(vals, vn, (ValueNumber)location.frameAfter().getTopValue());
                            continue block12;
                        }
                        case 79: 
                        case 80: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 181: {
                            if (i == 0) {
                                ValueNumber value = vns[vns.length - 1];
                                if (!(value.hasFlag(16) || value.hasFlag(4) || context.observedValues.containsKey(value.getNumber()))) {
                                    changed |= context.setDerivedEscape(vals, vn);
                                }
                                changed |= context.setObjectOnly(vals, vn);
                                continue block12;
                            }
                            if (context.escaped(vns[0])) {
                                changed |= context.setEscape(vals);
                                continue block12;
                            }
                            changed |= context.propagateValues(vals, null, vns[0]);
                            continue block12;
                        }
                        case 182: 
                        case 183: 
                        case 184: 
                        case 185: {
                            FindNoSideEffectMethods.MethodSideEffectStatus status;
                            MethodDescriptor m = new MethodDescriptor((InvokeInstruction)inst, context.cpg);
                            XMethod xMethod = null;
                            try {
                                Type type = (Type)location.typeFrameBefore().getStackValue(nconsumed - 1);
                                xMethod = Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptorFromSignature(type.getSignature())).findMatchingMethod(m);
                            }
                            catch (CheckedAnalysisException type) {
                                // empty catch block
                            }
                            if (xMethod != null) {
                                m = xMethod.getMethodDescriptor();
                            }
                            if ((status = this.noSideEffectMethods.status(m)) == FindNoSideEffectMethods.MethodSideEffectStatus.NSE || status == FindNoSideEffectMethods.MethodSideEffectStatus.SE_CLINIT) {
                                if (m.getName().equals("<init>")) {
                                    if (vns[0].equals(context.thisValue)) {
                                        changed |= context.setEscape(vals);
                                        continue block12;
                                    }
                                    changed |= context.propagateValues(vals, null, vns[0]);
                                    continue block12;
                                }
                                changed |= context.propagateToReturnValue(vals, vn, location, m);
                                continue block12;
                            }
                            if (status == FindNoSideEffectMethods.MethodSideEffectStatus.OBJ) {
                                if (i == 0) {
                                    changed |= context.setDerivedEscape(vals, vn);
                                    changed |= context.propagateToReturnValue(vals, vn, location, m);
                                    changed |= context.setObjectOnly(vals, vn);
                                    continue block12;
                                }
                                if (!context.escaped(vns[0])) {
                                    changed |= context.propagateValues(vals, null, vns[0]);
                                    changed |= context.propagateToReturnValue(vals, vn, location, m);
                                    continue block12;
                                }
                            }
                            changed |= context.setEscape(vals);
                            continue block12;
                        }
                        default: {
                            changed |= context.setEscape(vals);
                        }
                    }
                }
            }
        } while (changed);
        context.report();
    }

    @Override
    public void report() {
    }

    private static class ExceptionLocation
    implements GenLocation {
        BasicBlock b;
        ValueNumberAnalysis vna;
        TypeAnalysis ta;

        public ExceptionLocation(TypeAnalysis ta, ValueNumberAnalysis vna, BasicBlock block) {
            this.vna = vna;
            this.ta = ta;
            this.b = block;
        }

        @Override
        public InstructionHandle getHandle() {
            return this.b.getExceptionThrower();
        }

        @Override
        public ValueNumberFrame frameBefore() {
            return (ValueNumberFrame)this.vna.getStartFact(this.b);
        }

        @Override
        public ValueNumberFrame frameAfter() {
            return (ValueNumberFrame)this.vna.getResultFact(this.b);
        }

        @Override
        public TypeFrame typeFrameBefore() {
            return (TypeFrame)this.ta.getStartFact(this.b);
        }

        public String toString() {
            return "ex: " + this.b.getExceptionThrower() + " at " + this.b;
        }
    }

    private static class RegularLocation
    implements GenLocation {
        Location loc;
        ValueNumberAnalysis vna;
        TypeAnalysis ta;

        public RegularLocation(TypeAnalysis ta, ValueNumberAnalysis vna, Location loc) {
            this.ta = ta;
            this.vna = vna;
            this.loc = loc;
        }

        @Override
        public InstructionHandle getHandle() {
            return this.loc.getHandle();
        }

        @Override
        public ValueNumberFrame frameBefore() {
            return this.vna.getFactAtLocation(this.loc);
        }

        @Override
        public ValueNumberFrame frameAfter() {
            return this.vna.getFactAfterLocation(this.loc);
        }

        @Override
        public TypeFrame typeFrameBefore() throws DataflowAnalysisException {
            return (TypeFrame)this.ta.getFactAtLocation(this.loc);
        }

        public String toString() {
            return this.loc.toString();
        }
    }

    private static interface GenLocation {
        public InstructionHandle getHandle();

        public TypeFrame typeFrameBefore() throws DataflowAnalysisException;

        public ValueNumberFrame frameBefore();

        public ValueNumberFrame frameAfter();
    }

    private class UselessValuesContext {
        ValueNumberAnalysis vna;
        TypeAnalysis ta;
        CFG cfg;
        int count;
        Map<Integer, ValueInfo> observedValues = new HashMap<Integer, ValueInfo>();
        ConstantPoolGen cpg;
        Map<Integer, Set<ValueInfo>> values;
        ValueNumber thisValue;
        ClassContext classContext;
        Method method;

        UselessValuesContext(ClassContext classContext, Method method) throws CheckedAnalysisException {
            this.classContext = classContext;
            this.method = method;
            this.cfg = classContext.getCFG(method);
            this.cpg = this.cfg.getMethodGen().getConstantPool();
            this.ta = (TypeAnalysis)classContext.getTypeDataflow(method).getAnalysis();
            this.vna = (ValueNumberAnalysis)classContext.getValueNumberDataflow(method).getAnalysis();
        }

        void initObservedValues() throws DataflowAnalysisException {
            Iterator<Location> iterator = this.cfg.locationIterator();
            while (iterator.hasNext()) {
                InvokeInstruction inv;
                Location location = iterator.next();
                Instruction instruction = location.getHandle().getInstruction();
                if (instruction instanceof ANEWARRAY || instruction instanceof NEWARRAY || instruction instanceof MULTIANEWARRAY) {
                    int number = ((ValueNumber)this.vna.getFactAfterLocation(location).getTopValue()).getNumber();
                    TypeFrame typeFrame = (TypeFrame)this.ta.getFactAfterLocation(location);
                    if (!typeFrame.isValid()) continue;
                    Type type = (Type)typeFrame.getTopValue();
                    this.observedValues.put(number, new ValueInfo(number, location, type));
                    continue;
                }
                if (!(instruction instanceof INVOKESPECIAL) || !(inv = (InvokeInstruction)instruction).getMethodName(this.cpg).equals("<init>") || !FindUselessObjects.this.noSideEffectMethods.hasNoSideEffect(new MethodDescriptor(inv, this.cpg))) continue;
                int number = ((ValueNumber)this.vna.getFactAtLocation(location).getStackValue(inv.consumeStack(this.cpg) - 1)).getNumber();
                TypeFrame typeFrame = (TypeFrame)this.ta.getFactAtLocation(location);
                if (!typeFrame.isValid()) continue;
                Type type = (Type)typeFrame.getStackValue(inv.consumeStack(this.cpg) - 1);
                this.observedValues.put(number, new ValueInfo(number, location, type));
            }
            this.thisValue = this.vna.getThisValue();
            if (this.thisValue != null) {
                this.observedValues.remove(this.thisValue.getNumber());
            }
            this.count = this.observedValues.size();
        }

        void enhanceViaMergeTree() {
            this.values = new HashMap<Integer, Set<ValueInfo>>();
            for (Map.Entry<Integer, ValueInfo> entry : this.observedValues.entrySet()) {
                BitSet outputSet = this.vna.getMergeTree().getTransitiveOutputSet(entry.getKey());
                outputSet.set(entry.getKey());
                entry.getValue().origValues = outputSet;
                int i = outputSet.nextSetBit(0);
                while (i >= 0) {
                    Set<ValueInfo> list = this.values.get(i);
                    if (list == null) {
                        list = new HashSet<ValueInfo>();
                        this.values.put(i, list);
                    }
                    list.add(entry.getValue());
                    i = outputSet.nextSetBit(i + 1);
                }
            }
        }

        boolean setEscape(Set<ValueInfo> vals) {
            boolean result = false;
            for (ValueInfo vi : vals) {
                result |= !vi.escaped;
                vi.escaped = true;
                --this.count;
            }
            return result;
        }

        boolean setDerivedEscape(Set<ValueInfo> vals, ValueNumber vn) {
            boolean result = false;
            for (ValueInfo vi : vals) {
                if (!vi.origValues.get(vn.getNumber())) continue;
                result |= !vi.derivedEscaped;
                vi.derivedEscaped = true;
            }
            return result;
        }

        boolean setUsed(Set<ValueInfo> vals) {
            boolean result = false;
            for (ValueInfo vi : vals) {
                result |= !vi.used;
                vi.used = true;
            }
            return result;
        }

        boolean setObjectOnly(Set<ValueInfo> vals, ValueNumber vn) {
            boolean result = false;
            for (ValueInfo vi : vals) {
                if (vi.origValues.get(vn.getNumber()) || !vi.derivedEscaped && vi.derivedValues.get(vn.getNumber())) {
                    result |= !vi.hasObjectOnlyCall;
                    vi.hasObjectOnlyCall = true;
                    continue;
                }
                result |= !vi.escaped;
                vi.escaped = true;
                --this.count;
            }
            return result;
        }

        boolean propagateValues(Set<ValueInfo> vals, ValueNumber origNumber, ValueNumber vn) {
            Set<ValueInfo> list;
            int number = vn.getNumber();
            if (vals.size() == 1 && vals.iterator().next().origValue == number) {
                return false;
            }
            boolean result = this.setUsed(vals);
            if (origNumber != null) {
                for (ValueInfo vi : vals) {
                    if (!vi.origValues.get(origNumber.getNumber()) || vi.derivedValues.get(number)) continue;
                    vi.derivedValues.set(number);
                    result = true;
                }
            }
            if ((list = this.values.get(number)) == null) {
                list = new HashSet<ValueInfo>();
                this.values.put(number, list);
            }
            result |= list.addAll(vals);
            BitSet outputSet = this.vna.getMergeTree().getTransitiveOutputSet(number);
            int i = outputSet.nextSetBit(0);
            while (i >= 0) {
                list = this.values.get(i);
                if (list == null) {
                    list = new HashSet<ValueInfo>();
                    this.values.put(i, list);
                }
                result |= list.addAll(vals);
                i = outputSet.nextSetBit(i + 1);
            }
            return result;
        }

        boolean propagateToReturnValue(Set<ValueInfo> vals, ValueNumber vn, GenLocation location, MethodDescriptor m) throws DataflowAnalysisException {
            for (ValueInfo vi : vals) {
                if (!vi.type.getSignature().startsWith("[") || !vi.hasObjectOnlyCall || vi.var != null || vn.getNumber() != vi.origValue) continue;
                vi.escaped = true;
                --this.count;
            }
            if (Type.getReturnType(m.getSignature()) == Type.VOID || location instanceof ExceptionLocation) {
                return false;
            }
            InstructionHandle nextHandle = location.getHandle().getNext();
            if (nextHandle == null || nextHandle.getInstruction() instanceof POP || nextHandle.getInstruction() instanceof POP2) {
                return false;
            }
            return this.propagateValues(vals, null, (ValueNumber)location.frameAfter().getTopValue());
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        Iterator<GenLocation> genIterator() {
            return new Iterator<GenLocation>(){
                Iterator<Location> locIterator;
                Iterator<BasicBlock> blockIterator;
                GenLocation next;
                {
                    this.locIterator = UselessValuesContext.this.cfg.locationIterator();
                    this.blockIterator = UselessValuesContext.this.cfg.blockIterator();
                    this.next = this.advance();
                }

                private GenLocation advance() {
                    if (this.locIterator.hasNext()) {
                        return new RegularLocation(UselessValuesContext.this.ta, UselessValuesContext.this.vna, this.locIterator.next());
                    }
                    while (this.blockIterator.hasNext()) {
                        BasicBlock block = this.blockIterator.next();
                        if (!block.isExceptionThrower() || UselessValuesContext.this.cfg.getOutgoingEdgeWithType(block, 0) != null) continue;
                        return new ExceptionLocation(UselessValuesContext.this.ta, UselessValuesContext.this.vna, block);
                    }
                    return null;
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public GenLocation next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    GenLocation cur = this.next;
                    this.next = this.advance();
                    return cur;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        boolean escaped(ValueNumber vn) {
            Set<ValueInfo> vals = this.values.get(vn.getNumber());
            if (vals == null) {
                return true;
            }
            for (ValueInfo vi : vals) {
                if (!vi.escaped) continue;
                return true;
            }
            return false;
        }

        Set<ValueInfo> getLiveVals(ValueNumber vn) {
            Set<ValueInfo> vals = this.values.get(vn.getNumber());
            if (vals == null) {
                return null;
            }
            if (vals.size() == 1) {
                return vals.iterator().next().escaped ? null : vals;
            }
            HashSet<ValueInfo> result = new HashSet<ValueInfo>();
            for (ValueInfo vi : vals) {
                if (vi.escaped) continue;
                result.add(vi);
            }
            return result.isEmpty() ? null : result;
        }

        void report() {
            for (ValueInfo vi : this.observedValues.values()) {
                if (vi.escaped || vi.hasObjectOnlyCall && vi.used && vi.var == null || !vi.hasObjectOnlyCall && (!vi.used || vi.var == null)) continue;
                BugInstance bug = new BugInstance(vi.var == null ? "UC_USELESS_OBJECT_STACK" : "UC_USELESS_OBJECT", 2).addClassAndMethod(this.classContext.getJavaClass(), this.method);
                if (vi.var != null) {
                    bug.add(new StringAnnotation(vi.var));
                }
                FindUselessObjects.this.reporter.reportBug(bug.addType(vi.type).addSourceLine(this.classContext, this.method, vi.created));
            }
        }
    }

    private static class ValueInfo {
        Location created;
        String var;
        int origValue;
        boolean hasObjectOnlyCall;
        boolean escaped;
        boolean used;
        boolean derivedEscaped;
        public BitSet origValues;
        public BitSet derivedValues = new BitSet();
        Type type;

        public ValueInfo(int origValue, Location location, Type type) {
            this.created = location;
            this.origValue = origValue;
            this.type = type;
        }

        public String toString() {
            return "[" + (this.escaped ? "E" : "-") + (this.hasObjectOnlyCall ? "O" : "-") + (this.used ? "U" : "-") + (this.derivedEscaped ? "D" : "-") + "] " + (this.var == null ? "" : this.var + " ") + this.type + " " + this.created;
        }
    }
}

