/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.detect.FindSelfComparison2;
import edu.umd.cs.findbugs.util.EditDistance;
import edu.umd.cs.findbugs.util.Util;
import java.util.BitSet;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LineNumberTable;

public class FindSelfComparison
extends OpcodeStackDetector {
    final BugAccumulator bugAccumulator;
    int putFieldPC = Integer.MIN_VALUE;
    OpcodeStack.Item putFieldObj;
    OpcodeStack.Item putFieldValue;
    XField putFieldXField;
    int lastMethodCall;
    static final boolean DEBUG = SystemProperties.getBoolean("fsc.debug");
    int whichRegister;
    int registerLoadCount;

    public FindSelfComparison(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(Code obj) {
        if (DEBUG) {
            System.out.println(this.getFullyQualifiedMethodName());
        }
        this.whichRegister = -1;
        this.registerLoadCount = 0;
        this.lastMethodCall = -1;
        this.resetDoubleAssignmentState();
        super.visit(obj);
        this.resetDoubleAssignmentState();
        this.bugAccumulator.reportAccumulatedBugs();
        if (DEBUG) {
            System.out.println();
        }
    }

    private void resetDoubleAssignmentState() {
        this.putFieldPC = Integer.MIN_VALUE;
        this.putFieldXField = null;
        this.putFieldValue = null;
        this.putFieldObj = null;
    }

    @Override
    public void sawBranchTo(int target) {
        this.resetDoubleAssignmentState();
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item obj;
        if (DEBUG) {
            System.out.printf("%3d %-15s %s%n", this.getPC(), Const.getOpcodeName(seen), this.stack);
        }
        if (this.stack.hasIncomingBranches(this.getPC())) {
            this.resetDoubleAssignmentState();
        }
        if (seen == 181) {
            int second;
            int first;
            LineNumberTable table;
            obj = this.stack.getStackItem(1);
            OpcodeStack.Item value = this.stack.getStackItem(0);
            XField f = this.getXFieldOperand();
            XClass x = this.getXClassOperand();
            if (this.putFieldPC + 10 > this.getPC() && f != null && obj != null && f.equals(this.putFieldXField) && !f.isSynthetic() && obj.sameValue(this.putFieldObj) && x != null && !((table = this.getCode().getLineNumberTable()) != null ? (first = table.getSourceLine(this.putFieldPC)) + 1 != (second = table.getSourceLine(this.getPC())) && first != second : this.putFieldPC + 3 != this.getPC())) {
                boolean storeOfDefaultValue;
                int priority = 2;
                if (value.equals(this.putFieldValue) && this.putFieldPC + 3 != this.getPC()) {
                    ++priority;
                }
                boolean bl = storeOfDefaultValue = this.putFieldValue.isNull() || this.putFieldValue.hasConstantValue(0);
                if (storeOfDefaultValue) {
                    ++priority;
                }
                if (f.isVolatile()) {
                    ++priority;
                }
                XField intendedTarget = null;
                double minimumDistance = 2.0;
                int matches = 0;
                for (XField xField : x.getXFields()) {
                    if (f.equals(xField) || xField.isStatic() || xField.isFinal() || xField.isSynthetic() || !xField.getSignature().equals(f.getSignature())) continue;
                    double distance = EditDistance.editDistanceRatio(f.getName(), xField.getName());
                    ++matches;
                    if (!(minimumDistance > distance)) continue;
                    minimumDistance = distance;
                    intendedTarget = xField;
                }
                if (minimumDistance > 0.6 && (matches > 1 || storeOfDefaultValue)) {
                    intendedTarget = null;
                } else if (intendedTarget != null) {
                    --priority;
                }
                BugInstance bug = new BugInstance(this, "SA_FIELD_DOUBLE_ASSIGNMENT", priority).addClassAndMethod(this).addReferencedField(this);
                if (intendedTarget != null) {
                    bug.addField(intendedTarget).describe("FIELD_DID_YOU_MEAN");
                }
                this.bugAccumulator.accumulateBug(bug, this);
            }
            this.putFieldPC = this.getPC();
            this.putFieldXField = f;
            this.putFieldObj = obj;
            this.putFieldValue = value;
        } else if (this.isReturn(seen)) {
            this.resetDoubleAssignmentState();
        } else if (seen == 180 && Util.nullSafeEquals(this.getXFieldOperand(), this.putFieldXField) && (obj = this.stack.getStackItem(0)).sameValue(this.putFieldObj)) {
            this.resetDoubleAssignmentState();
        }
        switch (seen) {
            case 182: 
            case 185: {
                String sig;
                SignatureParser parser;
                int numParameters;
                String name;
                boolean booleanComparisonMethod;
                if (this.getClassName().toLowerCase().indexOf("test") >= 0 || this.getMethodName().toLowerCase().indexOf("test") >= 0 || this.getSuperclassName().toLowerCase().indexOf("test") >= 0 || this.getNextOpcode() == 87 || !(booleanComparisonMethod = FindSelfComparison2.booleanComparisonMethod(name = this.getNameConstantOperand())) && !FindSelfComparison2.comparatorMethod(name) || (numParameters = (parser = new SignatureParser(sig = this.getSigConstantOperand())).getNumParameters()) != 1 && (seen != 184 || numParameters != 2) || (!booleanComparisonMethod || !sig.endsWith(";)Z")) && (!FindSelfComparison2.comparatorMethod(name) || !sig.endsWith(";)I"))) break;
                this.checkForSelfOperation(seen, "COMPARISON");
                break;
            }
            case 100: 
            case 101: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.checkForSelfOperation(seen, "COMPUTATION");
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                break;
            }
            case 148: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.checkForSelfOperation(seen, "COMPARISON");
                break;
            }
        }
        if (this.isRegisterLoad() && seen != 132) {
            if (this.getRegisterOperand() == this.whichRegister) {
                ++this.registerLoadCount;
            } else {
                this.whichRegister = this.getRegisterOperand();
                this.registerLoadCount = 1;
            }
        } else {
            this.whichRegister = -1;
            this.registerLoadCount = 0;
        }
        if (this.isMethodCall()) {
            this.lastMethodCall = this.getPC();
        }
    }

    private void checkForSelfOperation(int opCode, String op) {
        LocalVariableAnnotation localVariableAnnotation;
        OpcodeStack.Item item0 = this.stack.getStackItem(0);
        OpcodeStack.Item item1 = this.stack.getStackItem(1);
        if ("D".equals(item0.getSignature()) || "F".equals(item0.getSignature())) {
            return;
        }
        if ("D".equals(item1.getSignature()) || "F".equals(item1.getSignature())) {
            return;
        }
        BitSet linesMentionedMultipleTimes = this.getClassContext().linesMentionedMultipleTimes(this.getMethod());
        SourceLineAnnotation source = SourceLineAnnotation.fromVisitedInstruction(this);
        boolean possibleClone = source.getStartLine() > 0 && linesMentionedMultipleTimes.get(source.getStartLine());
        LineNumberTable lineNumberTable = this.getCode().getLineNumberTable();
        int linesDifference = 0;
        if (item0.getPC() != -1 && item1.getPC() != -1) {
            if (lineNumberTable != null) {
                int line0 = lineNumberTable.getSourceLine(item0.getPC());
                int line1 = lineNumberTable.getSourceLine(item1.getPC());
                int firstPos = Math.min(item0.getPC(), item1.getPC());
                if (firstPos < this.lastMethodCall && line0 != line1) {
                    return;
                }
                linesDifference = Math.abs(line0 - line1);
            } else {
                int firstPos = Math.min(item0.getPC(), item1.getPC());
                int lastPos = Math.max(item0.getPC(), item1.getPC());
                if (firstPos < this.lastMethodCall && lastPos - firstPos > 4) {
                    return;
                }
                linesDifference = (lastPos - firstPos) / 10;
            }
        }
        XField field0 = item0.getXField();
        XField field1 = item1.getXField();
        int fr0 = item0.getFieldLoadedFromRegister();
        int fr1 = item1.getFieldLoadedFromRegister();
        if (field0 != null && field0.equals(field1) && (field0.isStatic() || fr0 != -1 && fr0 == fr1)) {
            int priority = 2;
            if (field0.isVolatile()) {
                ++priority;
            }
            if (linesDifference > 1) {
                if (possibleClone) {
                    return;
                }
                ++priority;
            }
            BugInstance bug = new BugInstance(this, "SA_FIELD_SELF_" + op, priority).addClassAndMethod(this).addField(field0);
            if (this.isMethodCall()) {
                bug.addCalledMethod(this);
            }
            this.bugAccumulator.accumulateBug(bug, this);
        } else if (opCode == 130 && item0.sameValue(item1) && (localVariableAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation(this, item0)) != null) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "SA_LOCAL_SELF_" + op, linesDifference > 1 ? 2 : 1).addClassAndMethod(this).add(localVariableAnnotation), this);
        }
    }
}

