/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.Code;

public class FindFieldSelfAssignment
extends OpcodeStackDetector
implements StatelessDetector {
    private final BugReporter bugReporter;
    private static final boolean DEBUG = SystemProperties.getBoolean("fsa.debug");
    int state;
    int register;
    int lastMethodCall;
    Set<String> initializedFields = new HashSet<String>();
    XField possibleOverwrite;

    public FindFieldSelfAssignment(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Code obj) {
        this.state = 0;
        this.lastMethodCall = -1;
        if (DEBUG) {
            System.out.println(this.getXMethod());
        }
        super.visit(obj);
        this.possibleOverwrite = null;
        if (DEBUG) {
            System.out.println();
        }
        this.initializedFields.clear();
    }

    @Override
    public void sawOpcode(int seen) {
        if (DEBUG) {
            System.out.printf("%5d %12s %s%n", this.getPC(), Const.getOpcodeName(seen), this.stack);
        }
        if (seen == 181) {
            OpcodeStack.Item top = this.stack.getStackItem(0);
            OpcodeStack.Item next = this.stack.getStackItem(1);
            if (this.possibleOverwrite != null && this.possibleOverwrite.equals(this.getXFieldOperand())) {
                this.bugReporter.reportBug(new BugInstance(this, "SA_FIELD_SELF_ASSIGNMENT", 1).addClassAndMethod(this).addReferencedField(this).addSourceLine(this));
            }
            this.possibleOverwrite = null;
            if (this.stack.getStackDepth() >= 4 && this.getNextOpcode() == 181) {
                OpcodeStack.Item third = this.stack.getStackItem(2);
                OpcodeStack.Item fourth = this.stack.getStackItem(3);
                XField f2 = third.getXField();
                int registerNumber2 = fourth.getRegisterNumber();
                if (f2 != null && f2.equals(this.getXFieldOperand()) && registerNumber2 >= 0 && registerNumber2 == third.getFieldLoadedFromRegister() && !third.sameValue(top) && (third.getPC() == -1 || third.getPC() > this.lastMethodCall)) {
                    this.possibleOverwrite = f2;
                }
            }
            XField f = top.getXField();
            int registerNumber = next.getRegisterNumber();
            if (f != null && f.equals(this.getXFieldOperand()) && registerNumber >= 0 && registerNumber == top.getFieldLoadedFromRegister() && (top.getPC() == -1 || top.getPC() > this.lastMethodCall)) {
                int priority = 2;
                LocalVariableAnnotation possibleMatch = LocalVariableAnnotation.findMatchingIgnoredParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                if (possibleMatch != null) {
                    --priority;
                } else {
                    possibleMatch = LocalVariableAnnotation.findUniqueBestMatchingParameter(this.getClassContext(), this.getMethod(), this.getNameConstantOperand(), this.getSigConstantOperand());
                }
                if (possibleMatch == null) {
                    String signature = this.stack.getLVValue(registerNumber).getSignature();
                    for (int i = 0; i < this.stack.getNumLocalValues(); ++i) {
                        OpcodeStack.Item lvValue;
                        if (i == this.register || (lvValue = this.stack.getLVValue(i)) == null || !lvValue.getSignature().equals(signature)) continue;
                        --priority;
                        break;
                    }
                }
                this.bugReporter.reportBug(new BugInstance(this, "SA_FIELD_SELF_ASSIGNMENT", priority).addClassAndMethod(this).addReferencedField(this).addOptionalAnnotation(possibleMatch).addSourceLine(this));
            }
        } else {
            this.possibleOverwrite = null;
        }
        if (this.isMethodCall()) {
            this.lastMethodCall = this.getPC();
        }
        switch (this.state) {
            case 0: {
                if (seen != 89) break;
                this.state = 6;
                break;
            }
            case 6: {
                if (this.isRegisterStore()) {
                    this.state = 7;
                    this.register = this.getRegisterOperand();
                    break;
                }
                this.state = 0;
                break;
            }
            case 7: {
                if (this.isRegisterStore() && this.register == this.getRegisterOperand()) {
                    this.bugReporter.reportBug(new BugInstance(this, "SA_LOCAL_DOUBLE_ASSIGNMENT", 2).addClassAndMethod(this).add(LocalVariableAnnotation.getLocalVariableAnnotation(this.getMethod(), this.register, this.getPC(), this.getPC() - 1)).addSourceLine(this));
                }
                this.state = 0;
                break;
            }
        }
    }
}

