/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.analysis;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;

public class AnnotationValue {
    private final ClassDescriptor annotationClass;
    private final Map<String, Object> valueMap = new HashMap<String, Object>(4);
    private final Map<String, Object> typeMap = new HashMap<String, Object>(4);

    public AnnotationValue(ClassDescriptor annotationClass) {
        this.annotationClass = annotationClass;
    }

    public AnnotationValue(String annotationClass) {
        this.annotationClass = DescriptorFactory.createClassDescriptorFromSignature(annotationClass);
    }

    public ClassDescriptor getAnnotationClass() {
        return this.annotationClass;
    }

    public Object getValue(String name) {
        return this.valueMap.get(name);
    }

    public Object getDesc(String name) {
        return this.typeMap.get(name);
    }

    public String toString() {
        return this.annotationClass + ":" + this.valueMap.toString();
    }

    private static String canonicalString(String s) {
        if ("value".equals(s)) {
            return "value";
        }
        return s;
    }

    public AnnotationVisitor getAnnotationVisitor() {
        return new AnnotationVisitor(393216){

            @Override
            public void visit(String name, Object value) {
                name = AnnotationValue.canonicalString(name);
                AnnotationValue.this.valueMap.put(name, value);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, String desc) {
                name = AnnotationValue.canonicalString(name);
                AnnotationValue newValue = new AnnotationValue(desc);
                AnnotationValue.this.valueMap.put(name, newValue);
                AnnotationValue.this.typeMap.put(name, desc);
                return newValue.getAnnotationVisitor();
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                name = AnnotationValue.canonicalString(name);
                return new AnnotationArrayVisitor(name);
            }

            @Override
            public void visitEnd() {
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                name = AnnotationValue.canonicalString(name);
                AnnotationValue.this.valueMap.put(name, new EnumValue(desc, value));
                AnnotationValue.this.typeMap.put(name, desc);
            }
        };
    }

    private final class AnnotationArrayVisitor
    extends AnnotationVisitor {
        private final String name;
        private final List<Object> outerList;
        private final List<Object> result;

        private AnnotationArrayVisitor(String name) {
            super(393216);
            this.result = new LinkedList<Object>();
            this.name = name = AnnotationValue.canonicalString(name);
            this.outerList = null;
        }

        private AnnotationArrayVisitor(List<Object> outerList) {
            super(393216);
            this.result = new LinkedList<Object>();
            this.name = null;
            this.outerList = outerList;
        }

        @Override
        public void visit(String name, Object value) {
            this.result.add(value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AnnotationValue newValue = new AnnotationValue(desc);
            this.result.add(newValue);
            return newValue.getAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new AnnotationArrayVisitor(this.result);
        }

        @Override
        public void visitEnd() {
            if (this.name != null) {
                AnnotationValue.this.valueMap.put(this.name, this.result.toArray());
            } else {
                this.outerList.add(this.result.toArray());
            }
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.result.add(new EnumValue(desc, value));
        }
    }
}

