/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojPlugin;
import org.openstreetmap.josm.plugins.agpifoj.ImageDisplay;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PrimaryDateParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelateGpxWithImages
implements ActionListener {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    AgpifojLayer yLayer = null;
    Vector gpxLst = new Vector();
    JPanel panel = null;
    JComboBox cbGpx = null;
    JTextField tfTimezone = null;
    JTextField tfOffset = null;
    JRadioButton rbAllImg = null;
    JRadioButton rbUntaggedImg = null;
    JRadioButton rbNoExifImg = null;

    public CorrelateGpxWithImages(AgpifojLayer agpifojLayer) {
        this.yLayer = agpifojLayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Layer layer;
        Object object;
        Object object422;
        Collection collection = Main.map.mapView.getAllLayers();
        for (Object object422 : collection) {
            if (!(object422 instanceof GpxLayer)) continue;
            this.gpxLst.add(new GpxDataWrapper(((GpxLayer)object422).name, ((GpxLayer)object422).data, ((GpxLayer)object422).data.storageFile));
        }
        for (GpxData object32 : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(object32.storageFile.getName(), object32, object32.storageFile));
        }
        if (this.gpxLst.size() == 0) {
            this.gpxLst.add(I18n.tr((String)"<No GPX track loaded yet>"));
        }
        object422 = new JPanel();
        ((Container)object422).setLayout(new FlowLayout());
        ((Container)object422).add(new JLabel(I18n.tr((String)"GPX track: ")));
        this.cbGpx = new JComboBox(this.gpxLst);
        ((Container)object422).add(this.cbGpx);
        JButton jButton = new JButton(I18n.tr((String)"Open another GPX trace"));
        jButton.setIcon(ImageProvider.get((String)"agpifoj-open"));
        jButton.addActionListener(new LoadGpxDataActionListener());
        ((Container)object422).add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr((String)"Timezone: ")), gridBagConstraints);
        float f = Float.parseFloat(Main.pref.get("tagimages.doublegpstimezone", "0.0"));
        if ((double)f == 0.0) {
            f = -Long.parseLong(Main.pref.get("tagimages.gpstimezone", "0"));
        }
        this.tfTimezone = new JTextField();
        this.tfTimezone.setText(this.formatTimezone(f));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.tfTimezone, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr((String)"Offset:")), gridBagConstraints);
        long l = Long.parseLong(Main.pref.get("tagimages.delta", "0")) / 1000L;
        this.tfOffset = new JTextField();
        this.tfOffset.setText(Long.toString(l));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.tfOffset, gridBagConstraints);
        JButton jButton2 = new JButton(I18n.tr((String)"<html>I can take a picture of my GPS receiver.<br>Can this help?</html>"));
        jButton2.addActionListener(new SetOffsetActionListener());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel(I18n.tr((String)"Update position for: ")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.rbAllImg = new JRadioButton(I18n.tr((String)"All images"));
        jPanel.add((Component)this.rbAllImg, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.rbNoExifImg = new JRadioButton(I18n.tr((String)"Images with no exif position"));
        jPanel.add((Component)this.rbNoExifImg, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.rbUntaggedImg = new JRadioButton(I18n.tr((String)"Not yet tagged images"));
        jPanel.add((Component)this.rbUntaggedImg, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbAllImg);
        buttonGroup.add(this.rbNoExifImg);
        buttonGroup.add(this.rbUntaggedImg);
        this.rbUntaggedImg.setSelected(true);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)object422, "First");
        this.panel.add((Component)jPanel, "Center");
        boolean bl = false;
        GpxDataWrapper gpxDataWrapper = null;
        while (!bl) {
            block20: {
                int arrayList = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr((String)"Correlate images with GPX track"), 2);
                if (arrayList == 2) {
                    return;
                }
                Iterator<AgpifojLayer.ImageEntry> n = this.cbGpx.getSelectedItem();
                if (n == null || !(n instanceof GpxDataWrapper)) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"You should select a GPX track"), I18n.tr((String)"No selected GPX track"), 0);
                    continue;
                }
                gpxDataWrapper = (GpxDataWrapper)((Object)n);
                Float f2 = this.parseTimezone(this.tfTimezone.getText().trim());
                if (f2 == null) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing timezone.\nExpected format: {0}", (Object[])new Object[]{"+H:MM"}), I18n.tr((String)"Invalid timezone"), 0);
                    continue;
                }
                f = f2.floatValue();
                object = this.tfOffset.getText().trim();
                if (((String)object).length() > 0) {
                    try {
                        l = Long.parseLong((String)object);
                        break block20;
                    }
                    catch (NumberFormatException numberFormatException) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing offset.\nExpected format: {0}", (Object[])new Object[]{"number"}), I18n.tr((String)"Invalid offset"), 0);
                        continue;
                    }
                }
                l = 0L;
            }
            Main.pref.put("tagimages.doublegpstimezone", Double.toString(f));
            Main.pref.put("tagimages.gpstimezone", Long.toString(-((long)f)));
            Main.pref.put("tagimages.delta", Long.toString(l * 1000L));
            bl = true;
        }
        ArrayList<AgpifojLayer.ImageEntry> arrayList = new ArrayList<AgpifojLayer.ImageEntry>(this.yLayer.data.size());
        if (this.rbAllImg.isSelected()) {
            for (AgpifojLayer.ImageEntry imageEntry : this.yLayer.data) {
                if (imageEntry.time == null) continue;
                arrayList.add(imageEntry);
            }
        } else if (this.rbNoExifImg.isSelected()) {
            for (AgpifojLayer.ImageEntry imageEntry : this.yLayer.data) {
                if (imageEntry.time == null || imageEntry.exifCoor != null) continue;
                arrayList.add(imageEntry);
            }
        } else {
            for (AgpifojLayer.ImageEntry imageEntry : this.yLayer.data) {
                if (imageEntry.time == null || imageEntry.coor != null) continue;
                arrayList.add(imageEntry);
            }
        }
        int n = this.matchGpxTrack(arrayList, gpxDataWrapper.data, (long)(f * 3600000.0f) + l * 1000L);
        Collection collection2 = Main.map.mapView.getAllLayers();
        object = collection2.iterator();
        boolean bl2 = false;
        while (object.hasNext()) {
            layer = (Layer)object.next();
            if (layer == this.yLayer) continue;
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            layer.visitBoundingBox(boundingXYVisitor);
            if (boundingXYVisitor.min == null || boundingXYVisitor.max == null) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            layer = new BoundingXYVisitor();
            this.yLayer.visitBoundingBox((BoundingXYVisitor)layer);
            Main.map.mapView.recalculateCenterScale((BoundingXYVisitor)layer);
        }
        Main.map.repaint();
        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Found {0} matchs of {1} in GPX track {2}", (Object[])new Object[]{n, arrayList.size(), gpxDataWrapper.name}), I18n.tr((String)"GPX Track loaded"), arrayList.size() > 0 && n == 0 ? 2 : 1);
    }

    private int matchGpxTrack(ArrayList<AgpifojLayer.ImageEntry> arrayList, GpxData gpxData, long l) {
        int n = 0;
        Collections.sort(arrayList, new Comparator<AgpifojLayer.ImageEntry>(){

            @Override
            public int compare(AgpifojLayer.ImageEntry imageEntry, AgpifojLayer.ImageEntry imageEntry2) {
                return imageEntry.time.compareTo(imageEntry2.time);
            }
        });
        PrimaryDateParser primaryDateParser = new PrimaryDateParser();
        for (GpxTrack gpxTrack : gpxData.tracks) {
            for (Collection collection : gpxTrack.trackSegs) {
                long l2 = 0L;
                WayPoint wayPoint = null;
                for (WayPoint wayPoint2 : collection) {
                    String string = (String)wayPoint2.attr.get("time");
                    if (string != null) {
                        try {
                            long l3 = primaryDateParser.parse(string).getTime() + l;
                            n += this.matchPoints(arrayList, wayPoint, l2, wayPoint2, l3);
                            wayPoint = wayPoint2;
                            l2 = l3;
                        }
                        catch (ParseException parseException) {
                            System.err.println("Error while parsing date \"" + string + '\"');
                            parseException.printStackTrace();
                            wayPoint = null;
                            l2 = 0L;
                        }
                        continue;
                    }
                    wayPoint = null;
                    l2 = 0L;
                }
            }
        }
        return n;
    }

    private int matchPoints(ArrayList<AgpifojLayer.ImageEntry> arrayList, WayPoint wayPoint, long l, WayPoint wayPoint2, long l2) {
        int n = 0;
        int n2 = this.getLastIndexOfListBefore(arrayList, l2);
        if (n2 >= 0 && n2 < arrayList.size() && arrayList.get((int)n2).time.getTime() > l) {
            Double d = null;
            Double d2 = null;
            Double d3 = null;
            if (wayPoint != null) {
                double d4 = this.getDistance(wayPoint, wayPoint2);
                d = new Double(1000.0 * d4 / (double)(l2 - l));
                try {
                    d2 = new Double((String)wayPoint.attr.get("ele"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                d3 = new Double((String)wayPoint2.attr.get("ele"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (n2 >= 0 && arrayList.get((int)n2).time.getTime() == l2) {
                arrayList.get((int)n2).pos = wayPoint2.eastNorth;
                arrayList.get((int)n2).coor = Main.proj.eastNorth2latlon(arrayList.get((int)n2).pos);
                arrayList.get((int)n2).speed = d;
                arrayList.get((int)n2).elevation = d3;
                ++n;
                --n2;
            }
            if (l != 0L) {
                long l3;
                while (n2 >= 0 && (l3 = arrayList.get((int)n2).time.getTime()) > l) {
                    arrayList.get((int)n2).pos = new EastNorth(wayPoint.eastNorth.east() + (wayPoint2.eastNorth.east() - wayPoint.eastNorth.east()) * (double)(l3 - l) / (double)(l2 - l), wayPoint.eastNorth.north() + (wayPoint2.eastNorth.north() - wayPoint.eastNorth.north()) * (double)(l3 - l) / (double)(l2 - l));
                    arrayList.get((int)n2).coor = Main.proj.eastNorth2latlon(arrayList.get((int)n2).pos);
                    arrayList.get((int)n2).speed = d;
                    if (d3 != null && d2 != null) {
                        arrayList.get((int)n2).elevation = d2 + (d3 - d2) * (double)(l3 - l) / (double)(l2 - l);
                    }
                    ++n;
                    --n2;
                }
            }
        }
        return n;
    }

    private int getLastIndexOfListBefore(ArrayList<AgpifojLayer.ImageEntry> arrayList, long l) {
        int n = arrayList.size();
        if (n == 0 || l < arrayList.get((int)0).time.getTime()) {
            return -1;
        }
        if (l > arrayList.get((int)(n - 1)).time.getTime()) {
            return n;
        }
        if (l == arrayList.get((int)(n - 1)).time.getTime()) {
            return n - 1;
        }
        if (l == arrayList.get((int)0).time.getTime()) {
            int n2 = 0;
            while (n2 + 1 < n && arrayList.get((int)(n2 + 1)).time.getTime() == l) {
                ++n2;
            }
            return n2;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 1;
        while (n5 - n4 > 1) {
            n3 = (n5 + n4) / 2;
            long l2 = arrayList.get((int)n3).time.getTime();
            if (l2 < l) {
                n4 = n3;
                continue;
            }
            if (l2 > l) {
                n5 = n3;
                continue;
            }
            while (n3 + 1 < n && arrayList.get((int)(n3 + 1)).time.getTime() == l) {
                ++n3;
            }
            return n3;
        }
        return n4;
    }

    private String formatTimezone(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        if (d < 0.0) {
            stringBuffer.append('-');
            d = -d;
        } else {
            stringBuffer.append('+');
        }
        stringBuffer.append((long)d).append(':');
        int n = (int)(d % 1.0 * 60.0);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    private Float parseTimezone(String string) {
        int n;
        int n2;
        if (string.length() == 0) {
            return new Float(0.0f);
        }
        int n3 = 43;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n4 = 1;
        block12: for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            switch (n) {
                case 32: {
                    if (n4 == 2 && stringBuffer.length() == 0) continue block12;
                    return null;
                }
                case 43: 
                case 45: {
                    if (n4 == 1) {
                        n3 = n;
                        n4 = 2;
                        continue block12;
                    }
                    return null;
                }
                case 46: 
                case 58: {
                    if (n4 == 2) {
                        n4 = 3;
                        continue block12;
                    }
                    return null;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    switch (n4) {
                        case 1: 
                        case 2: {
                            n4 = 2;
                            stringBuffer.append((char)n);
                            continue block12;
                        }
                        case 3: {
                            stringBuffer2.append((char)n);
                            continue block12;
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        n2 = 0;
        n = 0;
        try {
            n2 = Integer.parseInt(stringBuffer.toString());
            if (stringBuffer2.length() > 0) {
                n = Integer.parseInt(stringBuffer2.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n2 > 12 || n > 59) {
            return null;
        }
        return new Float(((double)n2 + (double)n / 60.0) * (double)(n3 == 45 ? -1 : 1));
    }

    public double getDistance(WayPoint wayPoint, WayPoint wayPoint2) {
        double d = wayPoint.latlon.lat() * Math.PI / 180.0;
        double d2 = wayPoint.latlon.lon() * Math.PI / 180.0;
        double d3 = wayPoint2.latlon.lat() * Math.PI / 180.0;
        double d4 = wayPoint2.latlon.lon() * Math.PI / 180.0;
        double d5 = Math.atan2(Math.sqrt(Math.pow(Math.cos(d3) * Math.sin(d4 - d2), 2.0) + Math.pow(Math.cos(d) * Math.sin(d3) - Math.sin(d) * Math.cos(d3) * Math.cos(d4 - d2), 2.0)), Math.sin(d) * Math.sin(d3) + Math.cos(d) * Math.cos(d3) * Math.cos(d4 - d2)) * 6372795.0;
        return d5;
    }

    private class SetOffsetActionListener
    implements ActionListener {
        JPanel panel;
        JLabel lbExifTime;
        JTextField tfGpsTime;
        JComboBox cbTimezones;
        ImageDisplay imgDisp;
        JList imgList;

        private SetOffsetActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)new JLabel(I18n.tr((String)"<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>")), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            this.panel.add((Component)this.imgDisp, "Center");
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr((String)"Photo time (from exif):")), gridBagConstraints);
            this.lbExifTime = new JLabel();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.lbExifTime, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr((String)"Gps time (read from the above photo): ")), gridBagConstraints);
            this.tfGpsTime = new JTextField();
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(150, this.tfGpsTime.getMinimumSize().height));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.tfGpsTime, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.2;
            jPanel.add((Component)new JLabel(I18n.tr((String)" [dd/mm/yyyy hh:mm:ss]")), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr((String)"I'm in the timezone of: ")), gridBagConstraints);
            Vector<String> vector = new Vector<String>();
            String[] stringArray = TimeZone.getAvailableIDs();
            for (String object2 : stringArray) {
                TimeZone bl = TimeZone.getTimeZone(object2);
                String n = new StringBuffer(object2).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)bl.getRawOffset() / 3600000.0)).append(')').toString();
                vector.add(n);
            }
            Collections.sort(vector);
            this.cbTimezones = new JComboBox(vector);
            Object object3 = Main.pref.get("tagimages.timezoneid", "");
            TimeZone timeZone = ((String)object3).length() == 0 ? TimeZone.getDefault() : TimeZone.getTimeZone((String)object3);
            this.cbTimezones.setSelectedItem(new StringBuffer(timeZone.getID()).append(" (").append(CorrelateGpxWithImages.this.formatTimezone((double)timeZone.getRawOffset() / 3600000.0)).append(')').toString());
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.cbTimezones, gridBagConstraints);
            this.panel.add((Component)jPanel, "South");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.imgList = new JList(new AbstractListModel(){

                public Object getElementAt(int n) {
                    return CorrelateGpxWithImages.this.yLayer.data.get((int)n).file.getName();
                }

                public int getSize() {
                    return CorrelateGpxWithImages.this.yLayer.data.size();
                }
            });
            this.imgList.getSelectionModel().setSelectionMode(0);
            this.imgList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = SetOffsetActionListener.this.imgList.getSelectedIndex();
                    SetOffsetActionListener.this.imgDisp.setImage(CorrelateGpxWithImages.this.yLayer.data.get((int)n).file);
                    Date date = CorrelateGpxWithImages.this.yLayer.data.get((int)n).time;
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy ").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setCaretPosition(SetOffsetActionListener.this.tfGpsTime.getText().length());
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr((String)"No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)new JScrollPane(this.imgList), "Center");
            JButton jButton = new JButton(I18n.tr((String)"Open an other photo"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
                    jFileChooser.setAcceptAllFileFilterUsed(false);
                    jFileChooser.setMultiSelectionEnabled(false);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setFileFilter(AgpifojPlugin.JPEG_FILE_FILTER);
                    jFileChooser.showOpenDialog(Main.parent);
                    File file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    SetOffsetActionListener.this.imgDisp.setImage(file);
                    Date date = null;
                    try {
                        date = ExifReader.readTime((File)file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(new SimpleDateFormat("dd/MM/yyyy ").format(date));
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr((String)"No date"));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)jButton, "Last");
            this.panel.add((Component)jPanel2, "Before");
            boolean bl = false;
            while (!bl) {
                long l;
                int n = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr((String)"Synchronize time from a photo of the GPS receiver"), 2);
                if (n == 2) {
                    return;
                }
                try {
                    l = simpleDateFormat.parse(this.lbExifTime.getText()).getTime() - simpleDateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing the date.\nPlease use the requested format"), I18n.tr((String)"Invalid date"), 0);
                    continue;
                }
                String parseException = (String)this.cbTimezones.getSelectedItem();
                int n2 = parseException.lastIndexOf(40);
                object3 = parseException.substring(0, n2 - 1);
                String string = parseException.substring(n2 + 1, parseException.length() - 1);
                Main.pref.put("tagimages.timezoneid", (String)object3);
                CorrelateGpxWithImages.this.tfOffset.setText(Long.toString(l / 1000L));
                CorrelateGpxWithImages.this.tfTimezone.setText(string);
                bl = true;
            }
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void actionPerformed(ActionEvent actionEvent) {
            block13: {
                JFileChooser jFileChooser = new JFileChooser(Main.pref.get("lastDirectory"));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isDirectory() || file.getName().toLowerCase().endsWith(".gpx") || file.getName().toLowerCase().endsWith(".gpx.gz");
                    }

                    public String getDescription() {
                        return I18n.tr((String)"GPX Files (*.gpx *.gpx.gz)");
                    }
                });
                jFileChooser.showOpenDialog(Main.parent);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                try {
                    Object object;
                    CorrelateGpxWithImages.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                    Main.pref.put("lastDirectory", file.getPath());
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        if (!(CorrelateGpxWithImages.this.gpxLst.get(i) instanceof GpxDataWrapper)) continue;
                        object = (GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (!file.equals(((GpxDataWrapper)object).file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!file.getName().equals(((GpxDataWrapper)object).name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"File {0} is loaded yet under the name \"{1}\"", (Object[])new Object[]{file.getName(), ((GpxDataWrapper)object).name}));
                        }
                        return;
                    }
                    GpxData gpxData = null;
                    try {
                        object = file.getName().toLowerCase().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
                        gpxData = new GpxReader((InputStream)object, (File)file).data;
                        gpxData.storageFile = file;
                    }
                    catch (SAXException sAXException) {
                        sAXException.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Error while parsing {0}", (Object[])new Object[]{file.getName()}) + ": " + sAXException.getMessage());
                        CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Could not read \"{0}\"", (Object[])new Object[]{file.getName()}) + "\n" + iOException.getMessage());
                        CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    loadedGpxData.add(gpxData);
                    if (CorrelateGpxWithImages.this.gpxLst.get(0) instanceof String) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                    }
                    CorrelateGpxWithImages.this.gpxLst.add(new GpxDataWrapper(file.getName(), gpxData, file));
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.panel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class GpxDataWrapper {
        String name;
        GpxData data;
        File file;

        public GpxDataWrapper(String string, GpxData gpxData, File file) {
            this.name = string;
            this.data = gpxData;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CorrelateParameters {
        GpxData gpxData;
        float timezone;
        long offset;
    }
}

