/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.agpifoj;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojDialog;
import org.openstreetmap.josm.plugins.agpifoj.AgpifojLayer;
import org.openstreetmap.josm.tools.I18n;

public class AgpifojPlugin
extends Plugin {
    public AgpifojPlugin() {
        MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)new Action());
    }

    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
        if (mapFrame2 != null) {
            AgpifojDialog agpifojDialog = AgpifojDialog.getInstance();
            IconToggleButton iconToggleButton = mapFrame2.addToggleDialog((ToggleDialog)agpifojDialog);
            boolean bl = false;
            for (Layer layer : mapFrame2.mapView.getAllLayers()) {
                if (!(layer instanceof AgpifojLayer)) continue;
                bl = true;
                break;
            }
            iconToggleButton.setSelected(bl);
        } else {
            AgpifojDialog.getInstance().displayImage(null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Action
    extends JosmAction {
        public Action() {
            super(I18n.tr((String)"Open images with AgPifoJ..."), "agpifoj-open", I18n.tr((String)"Load set of images as a new layer."), null, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(Main.pref.get("tagimages.lastdirectory"));
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().toLowerCase().endsWith(".jpg");
                }

                public String getDescription() {
                    return I18n.tr((String)"JPEG images (*.jpg)");
                }
            });
            jFileChooser.showOpenDialog(Main.parent);
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray == null || fileArray.length == 0) {
                return;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            this.addRecursiveFiles(arrayList, fileArray);
            Main.pref.put("tagimages.lastdirectory", jFileChooser.getCurrentDirectory().getPath());
            AgpifojLayer.create(arrayList);
        }

        private void addRecursiveFiles(List<File> list, File[] fileArray) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    this.addRecursiveFiles(list, file.listFiles());
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".jpg")) continue;
                list.add(file);
            }
        }
    }
}

